/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.editor;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightings;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ptp.internal.rdt.editor.actions.PrintAction;
import org.eclipse.ptp.rdt.editor.info.IRemoteCEditorInfoProvider;
import org.eclipse.ptp.rdt.editor.info.IRemoteCEditorInfoProviderSaveAsExtension;
import org.eclipse.ptp.rdt.editor.info.RemoteCInfoProviderUtilities;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class RemoteCEditor
extends CEditor
implements HelpListener {
    private IEditorInput input;
    private List<IRemoteCEditorInfoProvider> infoProviders;
    private IRemoteCEditorInfoProvider provider;
    ISourceViewer viewer;

    public RemoteCEditor() {
        this.setEditorContextMenuId("#RemoteCEditorContext");
        this.setRulerContextMenuId("#RemoteCEditorRulerContext");
        this.setOutlinerContextMenuId("#RemoteCEditorOutlinerContext");
    }

    protected ActionGroup createSelectionSearchGroup() {
        ActionGroup selectionSearchGroup;
        if (this.provider != null && (selectionSearchGroup = this.provider.createSelectionSearchGroup(this)) != null) {
            return selectionSearchGroup;
        }
        return super.createSelectionSearchGroup();
    }

    protected ActionGroup createOpenViewActionGroup() {
        ActionGroup openViewActionGroup;
        if (this.provider != null && (openViewActionGroup = this.provider.createOpenViewActionGroup(this)) != null) {
            return openViewActionGroup;
        }
        return super.createOpenViewActionGroup();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.provider != null) {
            if (this.isSemanticHighlightingEnabled()) {
                this.provider.installSemanticHighlighting(this.getSourceViewer(), this.getPreferenceStore());
            }
            if (this.provider.isInactiveHighlightingEnabled(this.getPreferenceStore())) {
                this.provider.installInactiveHighlighting(this.getPreferenceStore(), this.getSharedColors());
            }
            this.provider.doPostCreatePartControl(parent);
        }
    }

    public Object getAdapter(Class required) {
        Object result;
        if (ISourceViewer.class.equals((Object)required)) {
            return this.getSourceViewer();
        }
        if (this.provider != null && (result = this.provider.getAdapter(required)) != null) {
            return result;
        }
        return super.getAdapter(required);
    }

    public CContentOutlinePage getOutlinePage() {
        CContentOutlinePage page;
        if (this.fOutlinePage == null && this.provider != null && (page = this.provider.getOutlinePage(this)) != null) {
            this.fOutlinePage = page;
            this.fOutlinePage.addSelectionChangedListener((ISelectionChangedListener)this);
            RemoteCEditor.setOutlinePageInput((CContentOutlinePage)this.fOutlinePage, (IEditorInput)this.getEditorInput());
            return this.fOutlinePage;
        }
        return super.getOutlinePage();
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        SourceViewerConfiguration newSourceViewerConfiguration;
        super.setPreferenceStore(store);
        if (this.provider != null && (newSourceViewerConfiguration = this.provider.getSourceViewerConfiguration(store, this.getSourceViewerConfiguration())) != null) {
            this.setSourceViewerConfiguration(newSourceViewerConfiguration);
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        this.input = input;
        this.provider = RemoteCInfoProviderUtilities.getApplicableEditorInfoProvider(this.infoProviders, input);
        if (this.provider != null) {
            IEditorInput alternateInput;
            IDocumentProvider oldProvider = this.getDocumentProvider();
            IDocumentProvider p = this.provider.getDocumentProvider(oldProvider);
            if (p != null) {
                IEditorInput oldInput = this.getEditorInput();
                if (oldInput != null && oldProvider != null) {
                    oldProvider.disconnect((Object)oldInput);
                }
                this.setDocumentProvider(p);
            }
            if ((alternateInput = this.provider.getAlternateInput(input)) != null) {
                input = alternateInput;
            }
            this.provider.preDoSetInput(input);
        }
        super.doSetInput(input);
        if (this.provider != null) {
            String title;
            Image img = this.provider.getTitleImage();
            if (img != null) {
                this.setTitleImage(img);
            }
            if ((title = this.provider.getTitle(input)) != null) {
                this.setPartName(input.getName());
            }
            this.provider.postDoSetInput(input);
        }
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        if (this.provider != null) {
            this.provider.editorContextMenuAboutToShow(menu);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (this.provider != null) {
            this.provider.fillActionBars(actionBars);
        }
    }

    public boolean shouldProcessLocalParsingCompletions() {
        if (this.provider != null) {
            return this.provider.shouldProcessLocalParsingCompletions();
        }
        return super.shouldProcessLocalParsingCompletions();
    }

    protected boolean isSemanticHighlightingEnabled() {
        if (this.provider != null) {
            return this.provider.isSemanticHighlightingEnabled(this.getPreferenceStore());
        }
        return super.isSemanticHighlightingEnabled();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.infoProviders = RemoteCInfoProviderUtilities.getEditorInfoProviders();
        for (IRemoteCEditorInfoProvider provider : this.infoProviders) {
            provider.initializeEditor(this);
        }
    }

    public void displayMessage(String message) {
        this.setStatusLineMessage(message);
    }

    public String getTitleToolTip() {
        String titleTooltip;
        if (this.provider != null && (titleTooltip = this.provider.getTitleTooltip()) != null) {
            return titleTooltip;
        }
        return super.getTitleToolTip();
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        if (this.provider != null && !this.provider.doPrePerformSave(overwrite)) {
            return;
        }
        if (this.provider != null && this.provider instanceof IRemoteCEditorInfoProviderSaveAsExtension && ((IRemoteCEditorInfoProviderSaveAsExtension)((Object)this.provider)).forceSaveToSaveAs(this.input)) {
            this.performSaveAs(progressMonitor);
        } else {
            super.performSave(overwrite, progressMonitor);
        }
        if (this.provider != null) {
            this.provider.doPostPerformSave();
        }
    }

    protected void createActions() {
        super.createActions();
        if (this.provider != null) {
            this.provider.createActions(this.getVerticalRuler());
        }
        IAction print = this.getAction(ITextEditorActionConstants.PRINT);
        this.setAction(ITextEditorActionConstants.PRINT, (IAction)new PrintAction(print, this));
    }

    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        super.dispose();
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        if (this.provider != null && this.provider.getAnnotationRulerColumnWidth() != 0) {
            return new AnnotationRulerColumn(this.provider.getAnnotationRulerColumnWidth(), this.getAnnotationAccess());
        }
        return super.createAnnotationRulerColumn(ruler);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.viewer = super.createSourceViewer(parent, ruler, styles);
        this.viewer.getTextWidget().addHelpListener((HelpListener)this);
        if (this.provider != null && this.isFoldingEnabled()) {
            this.provider.installRemoteCodeFolding(this.viewer);
        }
        return this.viewer;
    }

    public void helpRequested(HelpEvent e) {
        if (this.provider != null) {
            this.provider.helpRequested(e);
        }
    }

    protected void createUndoRedoActions() {
        super.createUndoRedoActions();
        if (this.provider != null) {
            this.provider.createUndoRedoActions();
        }
    }

    public void doRevertToSaved() {
        if (this.provider != null) {
            this.provider.doPreRevertToSaved();
        }
        super.doRevertToSaved();
        if (this.provider != null) {
            this.provider.doPostRevertToSaved();
        }
    }

    public void aboutToBeReconciled() {
        if (this.provider != null) {
            this.provider.aboutToBeReconciled();
        }
        super.aboutToBeReconciled();
    }

    public IWorkingCopy getInputCElement() {
        ICElement result;
        if (this.provider != null && (result = this.provider.getInputCElement()) != null) {
            return (IWorkingCopy)result;
        }
        return super.getInputCElement();
    }

    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        boolean doReconcile = true;
        if (this.provider != null) {
            doReconcile = this.provider.reconciled(ast, force, progressMonitor);
        }
        if (doReconcile) {
            super.reconciled(ast, force, progressMonitor);
        }
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean doSaveAs = true;
        if (this.provider != null) {
            doSaveAs = this.provider.doPrePerformSaveAs(progressMonitor);
        }
        if (doSaveAs) {
            super.performSaveAs(progressMonitor);
        }
        if (this.provider != null) {
            this.provider.doPostPerformSaveAs();
        }
    }

    protected void validateState(IEditorInput input) {
        boolean doValidation = true;
        if (this.provider != null) {
            doValidation = this.provider.validateState(input);
        }
        if (doValidation) {
            super.validateState(input);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        if (this.provider != null) {
            this.provider.rulerContextMenuAboutToShow(menu);
        }
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] additional;
        String[] result = super.collectContextMenuPreferencePages();
        if (this.provider != null && (additional = this.provider.collectContextMenuPreferencePages()) != null && additional.length > 0) {
            String[] newResult = new String[result.length + additional.length + 1];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(additional, 0, newResult, result.length, additional.length);
            newResult[newResult.length - 1] = "org.eclipse.ptp.rdt.ui.editor.PrintPreferencePage";
            result = newResult;
        }
        return result;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
        if (this.provider != null) {
            IPreferenceStore store = this.getPreferenceStore();
            if (SemanticHighlightings.affectsEnablement((IPreferenceStore)store, (PropertyChangeEvent)event) || this.isEnableScalablilityMode() && "scalability.semanticHighlight".equals(event.getProperty())) {
                if (this.isSemanticHighlightingEnabled()) {
                    this.provider.installSemanticHighlighting(this.getSourceViewer(), store);
                    this.provider.refreshRemoteSemanticManager();
                } else {
                    this.provider.uninstallSemanticHighlighting();
                }
            }
            if (this.provider.isInactiveHighlightingEnabled(store)) {
                this.provider.installInactiveHighlighting(store, this.getSharedColors());
                if (event.getProperty().equals(this.provider.getInactiveHighlightColorKey())) {
                    this.provider.updateInactiveHighlightColor();
                }
            } else {
                this.provider.uninstallInactiveHighlighting();
            }
        }
    }

    public void uninstallProjectionModelUpdater() {
        super.uninstallProjectionModelUpdater();
    }

    public void updateDirtyIndicator() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                RemoteCEditor.this.firePropertyChange(257);
            }
        });
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.ptp.rdt.editor.RemoteCEditorScope"});
    }
}

