/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.Activator;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.messages.Messages;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards.SyncConfigToBuildConfigWizardPage;
import org.eclipse.ptp.internal.rdt.sync.cdt.ui.wizards.WizardUtil;
import org.eclipse.ptp.internal.rdt.sync.ui.wizards.SyncWizardDataCache;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.ui.AbstractSynchronizeWizardExtension;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeWizardExtensionDescriptor;

public class SynchronizeWizardExtension
extends AbstractSynchronizeWizardExtension {
    private static final String DEFAULT_BUILD_CONFIG_ID = "default-build-config-id";
    private static final String ProjectNameKey = "project-name";
    private static final String ConfigMapKey = "config-map";
    private SyncConfigToBuildConfigWizardPage fWizardPage;

    public SynchronizeWizardExtension(ISynchronizeWizardExtensionDescriptor descriptor) {
        super(descriptor);
    }

    public WizardPage createConvertProjectWizardPage() {
        this.fWizardPage = new SyncConfigToBuildConfigWizardPage(SyncConfigToBuildConfigWizardPage.WizardMode.ADD_SYNC);
        return this.fWizardPage;
    }

    private static IConfiguration findBuildConfigByName(String name, IConfiguration[] configArray) {
        IConfiguration[] iConfigurationArray = configArray;
        int n = configArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            if (config.getName().equals(name)) {
                return config;
            }
            ++n2;
        }
        return null;
    }

    private IProject getAndValidateProject() {
        String projectName = SyncWizardDataCache.getProperty((String)ProjectNameKey);
        if (projectName == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        assert (project != null) : String.valueOf(Messages.SynchronizeWizardExtension_0) + projectName;
        return project;
    }

    private boolean isCDTProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature");
        }
        catch (CoreException e) {
            Activator.log(e);
            return false;
        }
    }

    private boolean isSyncProject(IProject project) {
        return RemoteSyncNature.hasNature((IProject)project);
    }

    public void performFinish() {
        IProject project = this.getAndValidateProject();
        assert (this.isSyncProject(project) && this.isCDTProject(project)) : String.valueOf(Messages.SynchronizeWizardExtension_1) + project.getName();
        Map configMap = SyncWizardDataCache.getMap((String)ConfigMapKey);
        SyncConfig[] allSyncConfigs = SyncConfigManager.getConfigs((IProject)project);
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] allBuildConfigs = buildInfo.getManagedProject().getConfigurations();
        HashSet<IConfiguration> localBuildConfigs = new HashSet<IConfiguration>();
        HashSet<IConfiguration> remoteBuildConfigs = new HashSet<IConfiguration>();
        SyncConfig[] syncConfigArray = allSyncConfigs;
        int n = allSyncConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            SyncConfig config = syncConfigArray[n2];
            String defaultBuildConfigName = (String)configMap.get(config.getName());
            if (defaultBuildConfigName != null) {
                IConfiguration defaultBuildConfig = SynchronizeWizardExtension.findBuildConfigByName(defaultBuildConfigName, allBuildConfigs);
                if (defaultBuildConfig != null) {
                    config.setProperty(DEFAULT_BUILD_CONFIG_ID, defaultBuildConfig.getId());
                    if (SyncConfigManager.isLocal((SyncConfig)config)) {
                        localBuildConfigs.add(defaultBuildConfig);
                    } else {
                        remoteBuildConfigs.add(defaultBuildConfig);
                    }
                    if (SyncConfigManager.isActive((IProject)project, (SyncConfig)config)) {
                        ManagedBuildManager.setDefaultConfiguration((IProject)project, (IConfiguration)defaultBuildConfig);
                    }
                } else {
                    Activator.getDefault().logErrorMessage(String.valueOf(Messages.SynchronizeWizardExtension_2) + defaultBuildConfigName);
                }
            }
            ++n2;
        }
        syncConfigArray = allBuildConfigs;
        n = allBuildConfigs.length;
        n2 = 0;
        while (n2 < n) {
            SyncConfig buildConfig = syncConfigArray[n2];
            WizardUtil.modifyBuildConfigForSync((IConfiguration)buildConfig);
            if (localBuildConfigs.contains(buildConfig) && !remoteBuildConfigs.contains(buildConfig)) {
                WizardUtil.modifyLocalBuildConfigForSync((IConfiguration)buildConfig);
            } else {
                WizardUtil.modifyRemoteBuildConfigForSync((IConfiguration)buildConfig);
            }
            ++n2;
        }
        try {
            SyncConfigManager.saveConfigs((IProject)project);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }
}

