/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui.widgets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.LSFQueryControl;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.LSFQueryDialog;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ApplicationQueryControl
extends LSFQueryControl {
    public ApplicationQueryControl(Composite parent, IWidgetDescriptor wd) {
        super(parent, wd);
    }

    @Override
    protected void configureQueryButton(Button button, final IRemoteConnection connection) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ApplicationQueryControl.this.getQueryResponse(connection)) {
                    ApplicationQueryControl.this.dialog = new LSFQueryDialog(ApplicationQueryControl.this.getShell(), Messages.ApplicationQueryControl_0, ApplicationQueryControl.this.columnLabels, ApplicationQueryControl.this.commandResponse, false);
                    ApplicationQueryControl.this.dialog.setSelectedValue(ApplicationQueryControl.this.selectedValues);
                    int selection = ApplicationQueryControl.this.dialog.open();
                    if (selection == 0) {
                        ApplicationQueryControl.this.selectedValues = ApplicationQueryControl.this.dialog.getSelectedValues();
                        ApplicationQueryControl.this.notifyListeners();
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean getQueryResponse(IRemoteConnection connection) {
        IRemoteServices remoteServices = connection.getRemoteServices();
        IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, new String[]{"bapp", "-w"});
        IRemoteProcess process = null;
        try {
            process = processBuilder.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            if (process.exitValue() != 0) return true;
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String data = reader.readLine();
            boolean headerLine = true;
            while (data != null) {
                if (headerLine) {
                    if (data.equals("No application profiles found.")) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ApplicationQueryControl_2, (String)Messages.ApplicationQueryControl_3);
                        reader.close();
                        return false;
                    }
                    headerLine = false;
                }
                data = reader.readLine();
            }
            reader.close();
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            data = reader.readLine();
            headerLine = true;
            this.commandResponse.clear();
            while (data != null) {
                if (headerLine) {
                    this.columnLabels = data.split(" +");
                    headerLine = false;
                } else {
                    String[] columnData = data.split(" +");
                    this.commandResponse.add(columnData);
                }
                data = reader.readLine();
            }
            reader.close();
            return true;
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error querying reservations:\n" + e.getMessage()));
            return false;
        }
    }
}

