/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.model;

import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDICondition;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDIBreakpoint;
import org.eclipse.ptp.internal.debug.core.pdi.SessionObject;
import org.eclipse.ptp.internal.debug.core.pdi.model.Condition;

public abstract class Breakpoint
extends SessionObject
implements IPDIBreakpoint {
    private static int internal_counter = 0;
    private IPDICondition condition;
    private int bpid = -1;
    private int type;
    private boolean enable;
    private boolean deleted = false;
    private int internal_id;
    private TaskSet pendingTasks;

    public Breakpoint(IPDISession session, TaskSet tasks, int type, IPDICondition condition, boolean enabled) {
        super(session, tasks);
        this.type = type;
        this.condition = condition;
        this.enable = enabled;
        this.internal_id = internal_counter++;
        this.pendingTasks = tasks.copy();
    }

    public int getBreakpointID() {
        return this.bpid;
    }

    public IPDICondition getCondition() throws PDIException {
        if (this.condition == null) {
            this.condition = new Condition(0, new String(), null);
        }
        return this.condition;
    }

    public int getInternalID() {
        return this.internal_id;
    }

    public TaskSet getPendingTasks() {
        return this.pendingTasks;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isEnabled() {
        return this.enable;
    }

    public boolean isHardware() {
        return this.type == 2;
    }

    public boolean isTemporary() {
        return this.type == 1;
    }

    public void setBreakpointID(int bpid) {
        this.bpid = bpid;
    }

    public void setCondition(IPDICondition condition) {
        this.condition = condition;
    }

    public void setDeleted() {
        this.deleted = true;
    }

    public void setEnabled(boolean enabled) {
        this.enable = enabled;
    }
}

