/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JobStatusData {
    private static final String JOB_OUTERR_READY = "JOB_OUTERR_READY";
    public static final String SUBMITTED = "SUBMITTED";
    public static final String RUNNING = "RUNNING";
    public static final String COMPLETED = "COMPLETED";
    public static final String FAILED = "FAILED";
    public static final String CANCELED = "CANCELED";
    public static final String SYSTEM_TYPE_ATTR = "systemType";
    public static final String STDOUT_REMOTE_FILE_ATTR = "stdoutRemotePath";
    public static final String STDERR_REMOTE_FILE_ATTR = "stderrRemotePath";
    public static final String INTERACTIVE_ATTR = "interactive";
    public static final String STATE_ATTR = "state";
    public static final String STATE_DETAIL_ATTR = "stateDetail";
    public static final String OID_ATTR = "oid";
    public static final String QUEUE_NAME_ATTR = "queueName";
    public static final String OWNER_ATTR = "owner";
    public static final String CONTROL_ID_ATTR = "controlId";
    private boolean fOutReady = false;
    private boolean fErrReady = false;
    private boolean fRemoved = false;
    private final Map<String, String> fAttrs = new HashMap<String, String>();
    private final String fJobId;

    private static boolean detailIsFinal(String detail) {
        return CANCELED.equals(detail) || FAILED.equals(detail) || JOB_OUTERR_READY.equals(detail);
    }

    public JobStatusData(String jobId, String[][] attrs) {
        this.fJobId = jobId;
        this.setState(SUBMITTED);
        this.setStateDetail(SUBMITTED);
        String[][] stringArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] attr = stringArray[n2];
            this.fAttrs.put(attr[0], attr[1]);
            ++n2;
        }
        this.fOutReady = this.getString(STDOUT_REMOTE_FILE_ATTR) != null && JOB_OUTERR_READY.equals(this.getStateDetail());
        this.fErrReady = this.getString(STDERR_REMOTE_FILE_ATTR) != null && JOB_OUTERR_READY.equals(this.getStateDetail());
    }

    public boolean getErrReady() {
        return this.fErrReady;
    }

    public String getJobId() {
        return this.fJobId;
    }

    public Set<String> getKeys() {
        return this.fAttrs.keySet();
    }

    public boolean getOutReady() {
        return this.fOutReady;
    }

    public String getState() {
        return this.fAttrs.get(STATE_ATTR);
    }

    public String getStateDetail() {
        return this.fAttrs.get(STATE_DETAIL_ATTR);
    }

    public String getString(String key) {
        return this.fAttrs.get(key);
    }

    public boolean isCompleted() {
        return this.getState().equals(COMPLETED);
    }

    public boolean isInteractive() {
        String interactive = this.fAttrs.get(INTERACTIVE_ATTR);
        if (interactive != null) {
            try {
                return Boolean.parseBoolean(interactive);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean isRemoved() {
        return this.fRemoved;
    }

    public void putString(String key, String value) {
        this.fAttrs.put(key, value);
    }

    public void setErrReady(boolean errReady) {
        this.fErrReady = errReady;
    }

    public void setOid(String oid) {
        this.fAttrs.put(OID_ATTR, oid);
    }

    public void setOutReady(boolean outReady) {
        this.fOutReady = outReady;
    }

    public void setRemoved() {
        this.fRemoved = true;
    }

    public void setState(String state) {
        this.fAttrs.put(STATE_ATTR, state);
    }

    public void setStateDetail(String stateDetail) {
        this.fAttrs.put(STATE_DETAIL_ATTR, stateDetail);
        this.fOutReady = this.getString(STDOUT_REMOTE_FILE_ATTR) != null && JOB_OUTERR_READY.equals(stateDetail);
        this.fErrReady = this.getString(STDERR_REMOTE_FILE_ATTR) != null && JOB_OUTERR_READY.equals(stateDetail);
    }

    public void updateState(String state, String stateDetail) {
        if (!JobStatusData.detailIsFinal(this.getStateDetail())) {
            this.setState(state);
            this.setStateDetail(stateDetail);
        }
    }
}

