/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ems.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.internal.ems.ui.AsyncRepopulationStrategy;
import org.eclipse.ptp.internal.ems.ui.messages.Messages;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class SearchableChecklist
extends Composite {
    private final Group group;
    private Label instructions = null;
    private Text searchBox = null;
    private Table table = null;
    private TableColumn enableColumn = null;
    private TableColumn textColumn = null;
    private Button clearSelection = null;
    private Button loadDefaults = null;
    private Button reloadList = null;
    private Comparator<String> comparator = null;
    private Set<String> items = Collections.emptySet();
    private Set<String> selectedItems = new HashSet<String>();

    public SearchableChecklist(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.group = new Group((Composite)this, 16);
        this.group.setText("");
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 10;
        layout.horizontalSpacing = 25;
        this.group.setLayout((Layout)layout);
        this.createInstructionalMessage();
        this.createSearchBox();
        this.createTable();
        this.createButtons();
        this.layout();
    }

    private void createInstructionalMessage() {
        this.instructions = new Label((Composite)this.group, 64);
        this.instructions.setLayoutData((Object)new GridData(4, 128, true, false, 2, 2));
    }

    private void createSearchBox() {
        Label filter = new Label((Composite)this.group, 64);
        GridData gd = new GridData(4, 1024, true, false);
        gd.widthHint = 150;
        filter.setLayoutData((Object)gd);
        filter.setText(Messages.SearchableChecklist_SearchBoxLabel);
        filter.setForeground(this.getDisplay().getSystemColor(17));
        this.searchBox = new Text((Composite)this.group, 900);
        gd = new GridData(4, 128, true, false);
        gd.widthHint = 150;
        this.searchBox.setLayoutData((Object)gd);
        this.searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchableChecklist.this.refresh();
                if (SearchableChecklist.this.table != null && SearchableChecklist.this.table.getItemCount() == 1) {
                    SearchableChecklist.this.highlightItem(0);
                }
            }
        });
        this.searchBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (SearchableChecklist.this.table != null && SearchableChecklist.this.table.getItemCount() == 1) {
                    SearchableChecklist.this.clearFilterAndSelectHighlighted(SearchableChecklist.this.table.getItem(0).getText(1));
                }
            }
        });
    }

    private void highlightItem(int index) {
        Color yellow = this.table.getDisplay().getSystemColor(7);
        Color black = this.table.getDisplay().getSystemColor(2);
        this.table.getItem(index).setBackground(yellow);
        this.table.getItem(index).setForeground(black);
    }

    private void clearFilterAndSelectHighlighted(String item) {
        this.selectedItems.add(item);
        this.searchBox.setText("");
        this.refresh();
        this.highlightItem(item);
        this.removeHighlightingAfterDelay(item);
    }

    private void highlightItem(String item) {
        int index = 0;
        while (index < this.table.getItemCount()) {
            if (this.table.getItem(index).getText(1).equals(item)) {
                this.highlightItem(index);
                break;
            }
            ++index;
        }
    }

    private void removeHighlightingAfterDelay(final String item) {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                SearchableChecklist.this.table.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int index = 0;
                        while (index < SearchableChecklist.this.table.getItemCount()) {
                            if (SearchableChecklist.this.table.getItem(index).getText(1).equals(item)) {
                                SearchableChecklist.this.removeHightingFromItem(index);
                                break;
                            }
                            ++index;
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule(1500L);
    }

    private void removeHightingFromItem(int index) {
        this.table.getItem(index).setBackground(this.table.getBackground());
        this.table.getItem(index).setForeground(this.table.getForeground());
    }

    private void createTable() {
        this.table = new Table((Composite)this.group, 2594);
        GridData gd = new GridData(4, 4, true, true, 3, 1);
        gd.heightHint = 75;
        this.table.setLayoutData((Object)gd);
        this.table.setLinesVisible(false);
        this.table.setHeaderVisible(true);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    TableItem item = (TableItem)e.item;
                    String moduleName = item.getText(1);
                    if (item.getChecked()) {
                        SearchableChecklist.this.selectedItems.add(moduleName);
                    } else {
                        SearchableChecklist.this.selectedItems.remove(moduleName);
                    }
                }
            }
        });
        this.enableColumn = new TableColumn(this.table, 0);
        this.textColumn = new TableColumn(this.table, 0);
    }

    private void createButtons() {
        this.clearSelection = new Button((Composite)this.group, 8);
        this.clearSelection.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.clearSelection.setText(Messages.SearchableChecklist_ClearSelection);
        this.clearSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchableChecklist.this.setItems(SearchableChecklist.this.items, Collections.<String>emptySet());
            }
        });
        this.loadDefaults = new Button((Composite)this.group, 8);
        this.loadDefaults.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.loadDefaults.setText(Messages.SearchableChecklist_SelectDefaults);
        this.reloadList = new Button((Composite)this.group, 8);
        this.reloadList.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.reloadList.setText(Messages.SearchableChecklist_ReloadList);
    }

    public void addClearButtonSelectonListener(SelectionListener listener) {
        this.clearSelection.addSelectionListener(listener);
    }

    public void addDefaultButtonSelectonListener(SelectionListener listener) {
        this.loadDefaults.addSelectionListener(listener);
    }

    public void addReloadButtonSelectonListener(SelectionListener listener) {
        this.reloadList.addSelectionListener(listener);
    }

    private Pattern compilePattern() {
        String patternText = this.searchBox.getText().trim();
        if (patternText.equals("")) {
            return null;
        }
        patternText = "\\Q" + patternText.replace("\\E", "\\\\E") + "\\E";
        patternText = patternText.replace("*", "\\E.*\\Q");
        patternText = patternText.replace("?", "\\E.?\\Q");
        return Pattern.compile(patternText, 2);
    }

    private boolean matches(Pattern pattern, String moduleName) {
        if (pattern == null) {
            return true;
        }
        Matcher matcher = pattern.matcher(moduleName);
        if (matcher.find()) {
            return matcher.start() == 0;
        }
        return false;
    }

    public void setColumnHeaders(String checkboxColumnHeader, String textColumnHeader) {
        this.enableColumn.setText(checkboxColumnHeader);
        this.enableColumn.pack();
        this.textColumn.setText(textColumnHeader);
        this.textColumn.pack();
        this.layout(true, true);
    }

    public void setInstructions(String message, int widthHint) {
        GridData gd = (GridData)this.instructions.getLayoutData();
        gd.widthHint = widthHint;
        this.setInstructions(message);
    }

    public void setInstructions(String message) {
        this.instructions.setText(message);
        this.layout(true, true);
    }

    public void setComparator(Comparator<String> comparator) {
        this.comparator = comparator;
    }

    public Set<String> getAllItems() {
        return Collections.unmodifiableSet(this.items);
    }

    public Set<String> getSelectedItems() {
        return Collections.unmodifiableSet(this.selectedItems);
    }

    public void setItems(Set<String> items, Set<String> selectedItems) {
        TreeSet<String> itemsCopy = new TreeSet<String>(this.comparator);
        itemsCopy.addAll(items);
        this.items = Collections.unmodifiableSet(itemsCopy);
        this.selectedItems = new HashSet<String>(selectedItems);
        this.selectedItems.retainAll(this.items);
        this.refresh();
    }

    private void refresh() {
        this.table.removeAll();
        Pattern pattern = this.compilePattern();
        for (String moduleName : this.items) {
            if (!this.matches(pattern, moduleName)) continue;
            TableItem item = new TableItem(this.table, 0);
            item.setText(1, moduleName);
            item.setChecked(this.selectedItems.contains(moduleName));
        }
        this.textColumn.pack();
        this.layout();
    }

    public void asyncRepopulate(AsyncRepopulationStrategy strategy) {
        this.setItems(Collections.<String>emptySet(), Collections.<String>emptySet());
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(1, strategy.getMessage());
        tableItem.setForeground(this.getDisplay().getSystemColor(33));
        this.textColumn.pack();
        this.setEnabled(false);
        AsyncRepopulationJob job = new AsyncRepopulationJob(strategy);
        job.setPriority(10);
        job.schedule();
    }

    public void setEnabledAndVisible(boolean value) {
        this.setEnabled(value);
        this.setVisible(value);
        this.layout(true, true);
    }

    public void setTitle(String description) {
        this.group.setText(description);
        this.layout(true, true);
    }

    private final class AsyncRepopulationJob
    extends Job {
        private final AsyncRepopulationStrategy strategy;

        public AsyncRepopulationJob(AsyncRepopulationStrategy strategy) {
            super(strategy.getMessage());
            this.strategy = strategy;
        }

        protected IStatus run(IProgressMonitor monitor) {
            TreeSet<String> modulesToSelect;
            TreeSet<String> modules;
            try {
                modules = new TreeSet<String>(this.strategy.computeItems(monitor));
                modulesToSelect = new TreeSet<String>(this.strategy.computeSelectedItems(monitor));
            }
            catch (Exception e) {
                if (!SearchableChecklist.this.isDisposed()) {
                    SearchableChecklist.this.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!SearchableChecklist.this.table.isDisposed()) {
                                SearchableChecklist.this.table.getItem(0).setText(1, String.valueOf(e.getClass().getSimpleName()) + ": " + e.getLocalizedMessage());
                            }
                        }
                    });
                }
                return new Status(4, "org.eclipse.ptp.ems.ui", 4, e.getLocalizedMessage(), (Throwable)e);
            }
            if (!SearchableChecklist.this.isDisposed()) {
                SearchableChecklist.this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SearchableChecklist.this.table.isDisposed()) {
                            SearchableChecklist.this.setItems(modules, modulesToSelect);
                            AsyncRepopulationJob.this.strategy.afterRepopulation();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

