/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.core;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.core.Preferences;

public class PreferencesAdapter
implements IPreferenceStore {
    private final ListenerList fListeners = new ListenerList(1);
    private final PreferenceChangeListener fListener = new PreferenceChangeListener();
    private final String fPrefsQualifier;
    private boolean fSilent;
    private boolean fNeedsSaving = false;

    public PreferencesAdapter(String qualifier) {
        this.fPrefsQualifier = qualifier;
        Preferences.addPreferenceChangeListener(this.fPrefsQualifier, this.fListener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public boolean contains(String name) {
        return Preferences.contains(this.fPrefsQualifier, name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.fNeedsSaving = true;
        if (!this.fSilent) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        return Preferences.getBoolean(this.fPrefsQualifier, name);
    }

    public boolean getDefaultBoolean(String name) {
        return Preferences.getDefaultBoolean(this.fPrefsQualifier, name, false);
    }

    public double getDefaultDouble(String name) {
        return Preferences.getDefaultDouble(this.fPrefsQualifier, name, 0.0);
    }

    public float getDefaultFloat(String name) {
        return Preferences.getDefaultFloat(this.fPrefsQualifier, name, 0.0f);
    }

    public int getDefaultInt(String name) {
        return Preferences.getDefaultInt(this.fPrefsQualifier, name, 0);
    }

    public long getDefaultLong(String name) {
        return Preferences.getDefaultLong(this.fPrefsQualifier, name, 0L);
    }

    public String getDefaultString(String name) {
        return Preferences.getDefaultString(this.fPrefsQualifier, name, "");
    }

    public double getDouble(String name) {
        return Preferences.getDouble(this.fPrefsQualifier, name);
    }

    public float getFloat(String name) {
        return Preferences.getFloat(this.fPrefsQualifier, name);
    }

    public int getInt(String name) {
        return Preferences.getInt(this.fPrefsQualifier, name);
    }

    public long getLong(String name) {
        return Preferences.getLong(this.fPrefsQualifier, name);
    }

    public String getString(String name) {
        return Preferences.getString(this.fPrefsQualifier, name);
    }

    public boolean isDefault(String name) {
        return Preferences.isDefault(this.fPrefsQualifier, name);
    }

    public boolean needsSaving() {
        return this.fNeedsSaving;
    }

    public void putValue(String name, String value) {
        try {
            this.fSilent = true;
            Preferences.setString(this.fPrefsQualifier, name, value);
        }
        finally {
            this.fSilent = false;
        }
    }

    public void setDefault(String name, double value) {
        Preferences.setDefaultDouble(this.fPrefsQualifier, name, value);
    }

    public void setDefault(String name, float value) {
        Preferences.setDefaultFloat(this.fPrefsQualifier, name, value);
    }

    public void setDefault(String name, int value) {
        Preferences.setDefaultInt(this.fPrefsQualifier, name, value);
    }

    public void setDefault(String name, long value) {
        Preferences.setDefaultLong(this.fPrefsQualifier, name, value);
    }

    public void setDefault(String name, String defaultObject) {
        Preferences.setDefaultString(this.fPrefsQualifier, name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        Preferences.setDefaultBoolean(this.fPrefsQualifier, name, value);
    }

    public void setToDefault(String name) {
        Preferences.setToDefault(this.fPrefsQualifier, name);
    }

    public void setValue(String name, double value) {
        Preferences.setDouble(this.fPrefsQualifier, name, value);
    }

    public void setValue(String name, float value) {
        Preferences.setFloat(this.fPrefsQualifier, name, value);
    }

    public void setValue(String name, int value) {
        Preferences.setInt(this.fPrefsQualifier, name, value);
    }

    public void setValue(String name, long value) {
        Preferences.setLong(this.fPrefsQualifier, name, value);
    }

    public void setValue(String name, String value) {
        Preferences.setString(this.fPrefsQualifier, name, value);
    }

    public void setValue(String name, boolean value) {
        Preferences.setBoolean(this.fPrefsQualifier, name, value);
    }

    private class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            PreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
        }
    }
}

