/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlighting;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingPresenter;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingReconciler;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ptp.internal.rdt.editor.RemoteCEditor;
import org.eclipse.ptp.internal.rdt.ui.editor.IRemoteSemanticHighlightingService;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class RemoteSemanticHighlightingReconciler
extends SemanticHighlightingReconciler {
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    protected SemanticHighlightingManager.HighlightingStyle[] fHighlightings;
    protected SemanticHighlightingManager.HighlightingStyle[] fJobHighlightings;
    private RemoteCEditor fRemoteEditor;
    private Job fJob;
    private final Object fJobLock = new Object();

    private void parsePositions(String positions) {
        String[] positionList = positions.split(",");
        int i = 0;
        while (i < positionList.length) {
            int lgtIndex = Integer.parseInt(positionList[i + 2]);
            if (this.fJobHighlightings[lgtIndex].isEnabled()) {
                int offset = Integer.parseInt(positionList[i]);
                int length = Integer.parseInt(positionList[i + 1]);
                this.addPosition(offset, length, this.fJobHighlightings[lgtIndex]);
            }
            i += 3;
        }
        this.sortPositions();
    }

    private void addPosition(int offset, int length, SemanticHighlightingManager.HighlightingStyle highlighting) {
        boolean isExisting = false;
        int i = 0;
        int n = this.fRemovedPositions.size();
        while (i < n) {
            SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)this.fRemovedPositions.get(i);
            if (position != null && position.isEqual(offset, length, highlighting)) {
                isExisting = true;
                this.fRemovedPositions.set(i, null);
                --this.fNOfRemovedPositions;
                break;
            }
            ++i;
        }
        if (!isExisting) {
            SemanticHighlightingManager.HighlightedPosition position = this.fJobPresenter.createHighlightedPosition(offset, length, highlighting);
            this.fAddedPositions.add(position);
        }
    }

    private IRemoteSemanticHighlightingService getSemanticHighlightingService(IProject project) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (!(serviceProvider instanceof IIndexServiceProvider2)) {
            return null;
        }
        IRemoteSemanticHighlightingService service = ((IIndexServiceProvider2)serviceProvider).getRemoteSemanticHighlightingService();
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        IProject project;
        IRemoteSemanticHighlightingService rsgs;
        String foundPositions;
        IWorkingCopy workingCopy;
        boolean updatePresentation;
        TextPresentation textPresentation;
        block23: {
            block22: {
                Object object;
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    if (this.fIsReconciling) {
                        return;
                    }
                    this.fIsReconciling = true;
                }
                textPresentation = null;
                updatePresentation = false;
                this.fJobPresenter = this.fPresenter;
                this.fJobSemanticHighlightings = this.fSemanticHighlightings;
                this.fJobHighlightings = this.fHighlightings;
                try {
                    if (this.fJobPresenter != null && this.fJobSemanticHighlightings != null && this.fJobHighlightings != null) break block22;
                    this.fJobPresenter = null;
                    this.fJobSemanticHighlightings = null;
                    this.fJobHighlightings = null;
                    object = this.fReconcileLock;
                }
                catch (Throwable throwable) {
                    this.fJobPresenter = null;
                    this.fJobSemanticHighlightings = null;
                    this.fJobHighlightings = null;
                    Object object3 = this.fReconcileLock;
                    synchronized (object3) {
                        this.fIsReconciling = false;
                    }
                    throw throwable;
                }
                synchronized (object) {
                    this.fIsReconciling = false;
                }
                return;
            }
            IWorkingCopyManager fManager = CUIPlugin.getDefault().getWorkingCopyManager();
            workingCopy = fManager.getWorkingCopy(this.fRemoteEditor.getEditorInput());
            if (workingCopy != null) break block23;
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            Object object = this.fReconcileLock;
            synchronized (object) {
                this.fIsReconciling = false;
            }
            return;
        }
        this.fJobPresenter.setCanceled(progressMonitor != null && progressMonitor.isCanceled());
        this.startReconcilingPositions();
        if (!this.fJobPresenter.isCanceled() && (foundPositions = (rsgs = this.getSemanticHighlightingService(project = this.fRemoteEditor.getInputCElement().getCProject().getProject())).computeSemanticHighlightingPositions(workingCopy)) != null && foundPositions.compareTo("") != 0) {
            this.parsePositions(foundPositions);
            updatePresentation = true;
        }
        if (!this.fJobPresenter.isCanceled() && updatePresentation) {
            textPresentation = this.fJobPresenter.createPresentation(this.fAddedPositions, this.fRemovedPositions);
            this.updatePresentation(textPresentation, this.fAddedPositions, this.fRemovedPositions);
        }
        this.stopReconcilingPositions();
        this.fJobPresenter = null;
        this.fJobSemanticHighlightings = null;
        this.fJobHighlightings = null;
        Object object = this.fReconcileLock;
        synchronized (object) {
            this.fIsReconciling = false;
        }
    }

    private void sortPositions() {
        List oldPositions = this.fRemovedPositions;
        ArrayList<SemanticHighlightingManager.HighlightedPosition> newPositions = new ArrayList<SemanticHighlightingManager.HighlightedPosition>(this.fNOfRemovedPositions);
        int i = 0;
        int n = oldPositions.size();
        while (i < n) {
            SemanticHighlightingManager.HighlightedPosition current = (SemanticHighlightingManager.HighlightedPosition)oldPositions.get(i);
            if (current != null) {
                newPositions.add(current);
            }
            ++i;
        }
        this.fRemovedPositions = newPositions;
        Collections.sort(this.fAddedPositions, new Comparator<Position>(){

            @Override
            public int compare(Position p1, Position p2) {
                return p1.getOffset() - p2.getOffset();
            }
        });
    }

    protected void updatePresentation(TextPresentation textPresentation, List<SemanticHighlightingManager.HighlightedPosition> addedPositions, List<SemanticHighlightingManager.HighlightedPosition> removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        RemoteCEditor editor = this.fRemoteEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    public void install(RemoteCEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter fPresenter2, SemanticHighlighting[] semanticHighlightings, SemanticHighlightingManager.HighlightingStyle[] highlightings) {
        this.fPresenter = fPresenter2;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.fRemoteEditor = editor;
        if (this.fRemoteEditor != null) {
            this.fRemoteEditor.addReconcileListener((ICReconcilingListener)this);
        }
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        if (this.fRemoteEditor != null) {
            this.fRemoteEditor.removeReconcileListener((ICReconcilingListener)this);
            this.fRemoteEditor = null;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    public void refresh() {
        this.reconciled(null, true, (IProgressMonitor)new NullProgressMonitor());
    }
}

