/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPVariable
extends PDOMCPPBinding
implements ICPPVariable {
    private static final int TYPE_OFFSET = 28;
    private static final int VALUE_OFFSET = 34;
    protected static final int ANNOTATIONS = 40;
    protected static final int RECORD_SIZE = 41;

    public PDOMCPPVariable(PDOMLinkage linkage, PDOMNode parent, IVariable variable) throws CoreException {
        super(linkage, parent, variable.getNameCharArray());
        Database db = this.getDB();
        this.setType(parent.getLinkage(), variable.getType());
        db.putByte(this.record + 40L, this.encodeFlags(variable));
        this.setValue(db, variable);
    }

    private void setValue(Database db, IVariable variable) throws CoreException {
        IValue val = variable.getInitialValue();
        ((PDOMLinkage)this.getLinkage()).storeValue(this.record + 34L, val);
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IVariable) {
            Database db = this.getDB();
            IVariable var = (IVariable)newBinding;
            IType newType = var.getType();
            this.setType(linkage, newType);
            this.setValue(db, var);
            db.putByte(this.record + 40L, this.encodeFlags(var));
        }
    }

    private void setType(PDOMLinkage linkage, IType newType) throws CoreException {
        linkage.storeType(this.record + 28L, newType);
    }

    protected byte encodeFlags(IVariable variable) {
        return PDOMCPPAnnotation.encodeAnnotation(variable);
    }

    public PDOMCPPVariable(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    @Override
    protected int getRecordSize() {
        return 41;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public IType getType() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 28L);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    @Override
    public IValue getInitialValue() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadValue(this.record + 34L);
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isAuto() {
        return PDOMCPPVariable.getBit(this.getByte(this.record + 40L), 0);
    }

    @Override
    public boolean isExtern() {
        return PDOMCPPVariable.getBit(this.getByte(this.record + 40L), 1);
    }

    @Override
    public boolean isExternC() {
        return PDOMCPPVariable.getBit(this.getByte(this.record + 40L), 6);
    }

    @Override
    public boolean isRegister() {
        return PDOMCPPVariable.getBit(this.getByte(this.record + 40L), 3);
    }

    @Override
    public boolean isStatic() {
        return PDOMCPPVariable.getBit(this.getByte(this.record + 40L), 4);
    }

    @Override
    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            return CPPVariableReadWriteFlags.getReadWriteFlags(name);
        }
        return 0;
    }
}

