/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.IRecursionResolvingBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNameBase;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.core.runtime.Assert;

public class CPPClassSpecialization
extends CPPSpecialization
implements ICPPClassSpecialization,
ICPPInternalClassTypeMixinHost {
    private ICPPClassSpecializationScope specScope;
    private ObjectMap specializationMap = ObjectMap.EMPTY_MAP;
    private final ThreadLocal<Set<IBinding>> fInProgress = new ThreadLocal();

    public CPPClassSpecialization(ICPPClassType specialized, IBinding owner, ICPPTemplateParameterMap argumentMap) {
        super(specialized, owner, argumentMap);
    }

    @Override
    public ICPPClassType getSpecializedBinding() {
        return (ICPPClassType)super.getSpecializedBinding();
    }

    @Override
    public IBinding specializeMember(IBinding original) {
        return this.specializeMember(original, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinding specializeMember(IBinding original, IASTNode point) {
        Set<IBinding> set;
        CPPClassSpecialization cPPClassSpecialization = this;
        synchronized (cPPClassSpecialization) {
            IBinding result = (IBinding)this.specializationMap.get(original);
            if (result != null) {
                return result;
            }
            set = this.fInProgress.get();
            if (set == null) {
                set = new HashSet<IBinding>();
                this.fInProgress.set(set);
            }
            if (!set.add(original)) {
                return RecursionResolvingBinding.createFor(original, point);
            }
        }
        IBinding result = CPPTemplates.createSpecialization(this, original, point);
        set.remove(original);
        CPPClassSpecialization cPPClassSpecialization2 = this;
        synchronized (cPPClassSpecialization2) {
            IBinding concurrent = (IBinding)this.specializationMap.get(original);
            if (concurrent != null) {
                return concurrent;
            }
            if (this.specializationMap == ObjectMap.EMPTY_MAP) {
                this.specializationMap = new ObjectMap(2);
            }
            this.specializationMap.put(original, result);
            return result;
        }
    }

    @Override
    public void checkForDefinition() {
    }

    @Override
    public ICPPASTCompositeTypeSpecifier getCompositeTypeSpecifier() {
        IASTNode definition = this.getDefinition();
        if (definition != null) {
            IASTNode node = definition;
            while (node instanceof IASTName) {
                node = node.getParent();
            }
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                return (ICPPASTCompositeTypeSpecifier)node;
            }
        }
        return null;
    }

    @Override
    public ICPPBase[] getBases() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getBases(null);
    }

    @Override
    public ICPPBase[] getBases(IASTNode point) {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getBases(this);
        }
        return scope.getBases(point);
    }

    @Override
    public ICPPField[] getDeclaredFields() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getDeclaredFields(null);
    }

    @Override
    public ICPPField[] getDeclaredFields(IASTNode point) {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getDeclaredFields(this);
        }
        return scope.getDeclaredFields(point);
    }

    @Override
    public ICPPMethod[] getDeclaredMethods() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getDeclaredMethods(null);
    }

    @Override
    public ICPPMethod[] getDeclaredMethods(IASTNode point) {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getDeclaredMethods(this);
        }
        return scope.getDeclaredMethods(point);
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getConstructors(null);
    }

    @Override
    public ICPPConstructor[] getConstructors(IASTNode point) {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getConstructors(this);
        }
        return scope.getConstructors(point);
    }

    @Override
    public IBinding[] getFriends() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getFriends(null);
    }

    @Override
    public IBinding[] getFriends(IASTNode point) {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getFriends(this);
        }
        return scope.getFriends(point);
    }

    @Override
    public ICPPClassType[] getNestedClasses() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getNestedClasses(null);
    }

    @Override
    public ICPPClassType[] getNestedClasses(IASTNode point) {
        ICPPClassSpecializationScope scope = this.getSpecializationScope();
        if (scope == null) {
            return ClassTypeHelper.getNestedClasses(this);
        }
        return scope.getNestedClasses(point);
    }

    @Override
    public IField[] getFields() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getFields(null);
    }

    @Override
    public IField[] getFields(IASTNode point) {
        return ClassTypeHelper.getFields(this, point);
    }

    @Override
    public IField findField(String name) {
        return ClassTypeHelper.findField(this, name);
    }

    @Override
    public ICPPMethod[] getMethods() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getMethods(null);
    }

    @Override
    public ICPPMethod[] getMethods(IASTNode point) {
        return ClassTypeHelper.getMethods(this, point);
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods() {
        CCorePlugin.log((Throwable)new Exception("Unsafe method call. Instantiation of dependent expressions may not work."));
        return this.getAllDeclaredMethods(null);
    }

    @Override
    public ICPPMethod[] getAllDeclaredMethods(IASTNode point) {
        return ClassTypeHelper.getAllDeclaredMethods(this, point);
    }

    @Override
    public int getKey() {
        if (this.getDefinition() != null) {
            return this.getCompositeTypeSpecifier().getKey();
        }
        return this.getSpecializedBinding().getKey();
    }

    @Override
    public ICPPClassScope getCompositeScope() {
        ICPPClassSpecializationScope specScope = this.getSpecializationScope();
        if (specScope != null) {
            return specScope;
        }
        ICPPASTCompositeTypeSpecifier typeSpecifier = this.getCompositeTypeSpecifier();
        if (typeSpecifier != null) {
            return typeSpecifier.getScope();
        }
        return null;
    }

    protected ICPPClassSpecializationScope getSpecializationScope() {
        this.checkForDefinition();
        if (this.getDefinition() != null) {
            return null;
        }
        if (this.specScope == null) {
            this.specScope = new CPPClassSpecializationScope(this);
        }
        return this.specScope;
    }

    @Override
    public boolean isSameType(IType type) {
        if (type == this) {
            return true;
        }
        if (type instanceof ITypedef) {
            return type.isSameType(this);
        }
        if (type instanceof ICPPClassSpecialization) {
            return CPPClassSpecialization.isSameClassSpecialization(this, (ICPPClassSpecialization)type);
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public boolean isAnonymous() {
        if (this.getNameCharArray().length > 0) {
            return false;
        }
        ICPPASTCompositeTypeSpecifier spec = this.getCompositeTypeSpecifier();
        if (spec == null) {
            return this.getSpecializedBinding().isAnonymous();
        }
        IASTNode node = spec.getParent();
        return node instanceof IASTSimpleDeclaration && ((IASTSimpleDeclaration)node).getDeclarators().length == 0;
    }

    public static boolean isSameClassSpecialization(ICPPClassSpecialization t1, ICPPClassSpecialization t2) {
        if (t2 instanceof ICPPTemplateInstance || t2 instanceof ICPPTemplateDefinition || t2 instanceof IProblemBinding) {
            return false;
        }
        if (t1.getKey() != t2.getKey()) {
            return false;
        }
        if (!CharArrayUtils.equals(t1.getNameCharArray(), t2.getNameCharArray())) {
            return false;
        }
        IBinding owner1 = t1.getOwner();
        IBinding owner2 = t2.getOwner();
        if (!(owner1 instanceof ICPPClassType) || !(owner2 instanceof ICPPClassType)) {
            return false;
        }
        return ((ICPPClassType)owner1).isSameType((ICPPClassType)owner2);
    }

    @Override
    public boolean isFinal() {
        ICPPASTCompositeTypeSpecifier typeSpecifier = this.getCompositeTypeSpecifier();
        if (typeSpecifier != null) {
            return typeSpecifier.isFinal();
        }
        return false;
    }

    @Override
    public int getVisibility(IBinding member) {
        return ClassTypeHelper.getVisibility(this, member);
    }

    public static class RecursionResolvingBinding
    extends ProblemBinding
    implements ICPPMember,
    IRecursionResolvingBinding {
        public static RecursionResolvingBinding createFor(IBinding original, IASTNode point) {
            if (original instanceof ICPPMethod) {
                return new RecursionResolvingMethod(point, original.getNameCharArray());
            }
            if (original instanceof ICPPField) {
                return new RecursionResolvingField(point, original.getNameCharArray());
            }
            return new RecursionResolvingBinding(point, original.getNameCharArray());
        }

        private RecursionResolvingBinding(IASTNode node, char[] arg) {
            super(node, 14, arg);
            Assert.isTrue((boolean)CPPASTNameBase.sAllowRecursionBindings, (String)this.getMessage());
        }

        @Override
        public int getVisibility() {
            return 1;
        }

        @Override
        public ICPPClassType getClassOwner() {
            return null;
        }
    }

    public static final class RecursionResolvingField
    extends RecursionResolvingBinding
    implements ICPPField {
        public RecursionResolvingField(IASTNode node, char[] arg) {
            super(node, arg);
        }

        @Override
        public ICompositeType getCompositeTypeOwner() {
            return null;
        }
    }

    public static final class RecursionResolvingMethod
    extends RecursionResolvingBinding
    implements ICPPMethod {
        public RecursionResolvingMethod(IASTNode node, char[] arg) {
            super(node, arg);
        }

        @Override
        public ICPPParameter[] getParameters() {
            return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
        }

        @Override
        public int getRequiredArgumentCount() {
            return 0;
        }

        @Override
        public IScope getFunctionScope() {
            return null;
        }

        @Override
        public boolean isNoReturn() {
            return false;
        }

        @Override
        public boolean isDestructor() {
            return false;
        }

        @Override
        public ICPPFunctionType getType() {
            return new ProblemFunctionType(this.getID());
        }

        @Override
        public boolean isOverride() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public boolean isConstexpr() {
            return false;
        }
    }
}

