/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class IncludeGroupStyle
implements Comparable<IncludeGroupStyle> {
    private static final String TAG_STYLE = "style";
    private static final String TAG_NAME = "name";
    private static final String TAG_PATTERN = "pattern";
    private static final String TAG_KEEP_TOGETHER = "keep_together";
    private static final String TAG_BLANK_LINE_BEFORE = "blank_line_before";
    private static final String TAG_RELATIVE_PATH = "relative_path";
    private static final String TAG_ANGLE_BRACKETS = "angle_brackets";
    private static final String TAG_ORDER = "order";
    private final IncludeKind includeKind;
    private boolean keepTogether;
    private boolean blankLineBefore;
    private boolean relativePath;
    private boolean angleBrackets;
    private Pattern headerNamePattern;
    private String name;
    private int order;

    public IncludeGroupStyle(IncludeKind includeKind) {
        if (includeKind == null || includeKind == IncludeKind.MATCHING_PATTERN) {
            throw new IllegalArgumentException();
        }
        this.includeKind = includeKind;
    }

    public IncludeGroupStyle(String name, Pattern headerNamePattern) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (headerNamePattern == null) {
            throw new IllegalArgumentException();
        }
        this.includeKind = IncludeKind.MATCHING_PATTERN;
        this.name = name;
        this.headerNamePattern = headerNamePattern;
    }

    public boolean isKeepTogether() {
        return this.keepTogether;
    }

    public void setKeepTogether(boolean value) {
        this.keepTogether = value;
    }

    public boolean isBlankLineBefore() {
        return this.blankLineBefore;
    }

    public void setBlankLineBefore(boolean value) {
        this.blankLineBefore = value;
    }

    public boolean isRelativePath() {
        return this.relativePath;
    }

    public void setRelativePath(boolean value) {
        assert (!this.includeKind.hasChildren());
        this.relativePath = value;
    }

    public boolean isAngleBrackets() {
        return this.angleBrackets;
    }

    public void setAngleBrackets(boolean value) {
        assert (!this.includeKind.hasChildren());
        this.angleBrackets = value;
    }

    public Pattern getHeaderNamePattern() {
        return this.headerNamePattern;
    }

    public void setHeaderNamePattern(Pattern headerNamePattern) {
        this.headerNamePattern = headerNamePattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IncludeKind getIncludeKind() {
        return this.includeKind;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public static IncludeGroupStyle fromMemento(IMemento memento, IncludeKind includeKind) {
        Integer order;
        IncludeGroupStyle style;
        if (includeKind == IncludeKind.MATCHING_PATTERN) {
            String name = IncludeGroupStyle.nullToEmpty(memento.getString(TAG_NAME));
            String pattern = IncludeGroupStyle.nullToEmpty(memento.getString(TAG_PATTERN));
            style = new IncludeGroupStyle(name, Pattern.compile(pattern));
        } else {
            style = new IncludeGroupStyle(includeKind);
        }
        style.setKeepTogether(IncludeGroupStyle.nullToFalse(memento.getBoolean(TAG_KEEP_TOGETHER)));
        style.setBlankLineBefore(IncludeGroupStyle.nullToFalse(memento.getBoolean(TAG_BLANK_LINE_BEFORE)));
        if (!includeKind.hasChildren()) {
            style.setRelativePath(IncludeGroupStyle.nullToFalse(memento.getBoolean(TAG_RELATIVE_PATH)));
            style.setAngleBrackets(IncludeGroupStyle.nullToFalse(memento.getBoolean(TAG_ANGLE_BRACKETS)));
        }
        if ((order = memento.getInteger(TAG_ORDER)) != null) {
            style.setOrder(order);
        }
        return style;
    }

    private static boolean nullToFalse(Boolean val) {
        return val != null && val != false;
    }

    private static String nullToEmpty(String val) {
        return val != null ? val : "";
    }

    public void saveToMemento(IMemento memento) {
        if (this.includeKind == IncludeKind.MATCHING_PATTERN) {
            memento.putString(TAG_NAME, this.name);
            memento.putString(TAG_PATTERN, this.headerNamePattern.toString());
        }
        memento.putBoolean(TAG_KEEP_TOGETHER, this.keepTogether);
        memento.putBoolean(TAG_BLANK_LINE_BEFORE, this.blankLineBefore);
        if (!this.includeKind.hasChildren()) {
            memento.putBoolean(TAG_RELATIVE_PATH, this.relativePath);
            memento.putBoolean(TAG_ANGLE_BRACKETS, this.angleBrackets);
        }
        if (this.keepTogether) {
            memento.putInteger(TAG_ORDER, this.order);
        }
    }

    public String toString() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_STYLE);
        this.saveToMemento((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            CUIPlugin.log(e);
        }
        return writer.toString();
    }

    public static IncludeGroupStyle fromString(String str, IncludeKind includeKind) {
        XMLMemento memento;
        StringReader reader = new StringReader(str);
        try {
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException workbenchException) {
            return null;
        }
        return IncludeGroupStyle.fromMemento((IMemento)memento, includeKind);
    }

    @Override
    public int compareTo(IncludeGroupStyle other) {
        if (this.keepTogether != other.keepTogether) {
            return this.keepTogether ? -1 : 1;
        }
        int c = this.order - other.order;
        if (c != 0) {
            return c;
        }
        return this.includeKind.ordinal() - other.includeKind.ordinal();
    }

    public static enum IncludeKind {
        RELATED(PreferencesMessages.IncludeCategoriesBlock_related_headers_node, PreferencesMessages.IncludeCategoriesBlock_related_headers_node_description, null),
        PARTNER(PreferencesMessages.IncludeCategoriesBlock_partner_header_node, PreferencesMessages.IncludeCategoriesBlock_partner_header_node_description, RELATED),
        IN_SAME_FOLDER(PreferencesMessages.IncludeCategoriesBlock_same_folder_header_node, PreferencesMessages.IncludeCategoriesBlock_same_folder_header_node_description, RELATED),
        IN_SUBFOLDER(PreferencesMessages.IncludeCategoriesBlock_subfolder_header_node, PreferencesMessages.IncludeCategoriesBlock_subfolder_header_node_description, RELATED),
        SYSTEM(PreferencesMessages.IncludeCategoriesBlock_system_headers_node, PreferencesMessages.IncludeCategoriesBlock_system_headers_node_description, null),
        SYSTEM_WITH_EXTENSION(PreferencesMessages.IncludeCategoriesBlock_system_headers_with_extension_node, PreferencesMessages.IncludeCategoriesBlock_system_headers_with_extension_node_description, SYSTEM),
        SYSTEM_WITHOUT_EXTENSION(PreferencesMessages.IncludeCategoriesBlock_system_headers_without_extension_node, PreferencesMessages.IncludeCategoriesBlock_system_headers_without_extension_node_description, SYSTEM),
        OTHER(PreferencesMessages.IncludeCategoriesBlock_unrelated_headers_node, PreferencesMessages.IncludeCategoriesBlock_unrelated_headers_node_description, null),
        IN_SAME_PROJECT(PreferencesMessages.IncludeCategoriesBlock_same_project_headers_node, PreferencesMessages.IncludeCategoriesBlock_same_project_headers_node_description, OTHER),
        IN_OTHER_PROJECT(PreferencesMessages.IncludeCategoriesBlock_other_project_headers_node, PreferencesMessages.IncludeCategoriesBlock_other_project_headers_node_description, OTHER),
        EXTERNAL(PreferencesMessages.IncludeCategoriesBlock_external_headers_node, PreferencesMessages.IncludeCategoriesBlock_external_headers_node_description, OTHER),
        MATCHING_PATTERN(PreferencesMessages.IncludeCategoriesBlock_user_defined_categories_node, PreferencesMessages.IncludeCategoriesBlock_user_defined_categories_node_description, null);

        public final String name;
        public final String description;
        public final IncludeKind parent;
        public final List<IncludeKind> children = new ArrayList<IncludeKind>();

        private IncludeKind(String name, String description, IncludeKind parent) {
            this.name = name;
            this.description = description;
            this.parent = parent;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        public boolean hasChildren() {
            return !this.children.isEmpty();
        }
    }
}

