/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTParameterDeclaration
extends ASTNode
implements IASTParameterDeclaration,
IASTAmbiguityParent {
    private IASTDeclSpecifier declSpec;
    private IASTDeclarator declarator;

    public CASTParameterDeclaration() {
    }

    public CASTParameterDeclaration(IASTDeclSpecifier declSpec, IASTDeclarator declarator) {
        this.setDeclSpecifier(declSpec);
        this.setDeclarator(declarator);
    }

    @Override
    public CASTParameterDeclaration copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTParameterDeclaration copy(IASTNode.CopyStyle style) {
        CASTParameterDeclaration copy = new CASTParameterDeclaration();
        copy.setDeclSpecifier(this.declSpec == null ? null : this.declSpec.copy(style));
        copy.setDeclarator(this.declarator == null ? null : this.declarator.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IASTDeclSpecifier getDeclSpecifier() {
        return this.declSpec;
    }

    @Override
    public IASTDeclarator getDeclarator() {
        return this.declarator;
    }

    @Override
    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.declSpec = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(DECL_SPECIFIER);
        }
    }

    @Override
    public void setDeclarator(IASTDeclarator declarator) {
        this.assertNotFrozen();
        this.declarator = declarator;
        if (declarator != null) {
            declarator.setParent(this);
            declarator.setPropertyInParent(DECLARATOR);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitParameterDeclarations) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declSpec != null && !this.declSpec.accept(action)) {
            return false;
        }
        if (this.declarator != null && !this.declarator.accept(action)) {
            return false;
        }
        if (action.shouldVisitParameterDeclarations) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.declarator) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.declarator = (IASTDeclarator)other;
        }
    }
}

