/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.services.ui.wizards;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.internal.services.ui.ServicesUIPlugin;
import org.eclipse.ptp.internal.services.ui.messages.Messages;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.IServiceProviderDescriptor;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.ptp.services.ui.IServiceProviderContributor;
import org.eclipse.ptp.services.ui.ServiceModelUIManager;
import org.eclipse.ptp.services.ui.dialogs.ServiceSelectionDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceConfigurationWidget
extends Wizard
implements INewWizard {
    protected static final String PROVIDER_KEY = "provider-id";
    protected static final String SERVICE_KEY = "service-id";
    protected Set<IServiceConfiguration> fServiceConfigurations;
    protected IServiceConfiguration fServiceConfiguration;
    protected Map<String, String> fServiceIDToSelectedProviderID;
    protected Map<String, IServiceProvider> fProviderIDToProviderMap;
    protected Table fTable;
    protected Button fConfigureButton;
    protected Button fAddButton;
    protected Button fRemoveButton;
    protected Listener fConfigChangeListener = null;
    protected IWorkbench fWorkbench = null;
    protected IStructuredSelection fSelection = null;

    public ServiceConfigurationWidget(Set<IServiceConfiguration> serviceConfigurations) {
        this.fServiceConfigurations = serviceConfigurations;
    }

    public Control createContents(Composite parent) {
        Composite canvas = new Composite(parent, 0);
        GridLayout canvasLayout = new GridLayout(2, false);
        canvas.setLayout((Layout)canvasLayout);
        Composite tableParent = new Composite(canvas, 0);
        tableParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable = new Table(tableParent, 67842);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        TableColumnLayout layout = new TableColumnLayout();
        String[] titles = new String[]{Messages.ServiceConfigurationWidget_0, Messages.ServiceConfigurationWidget_1, Messages.ServiceConfigurationWidget_2};
        int i = 0;
        while (i < titles.length) {
            TableColumn column = new TableColumn(this.fTable, 0);
            column.setText(titles[i]);
            int width = 20;
            switch (i) {
                case 0: {
                    width = 100;
                    break;
                }
                case 1: {
                    width = 100;
                    break;
                }
                case 2: {
                    width = 100;
                }
            }
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1, width, true));
            ++i;
        }
        tableParent.setLayout((Layout)layout);
        this.fTable.setLayout((Layout)new FillLayout());
        this.createTableContent();
        this.fTable.setVisible(true);
        Composite buttonParent = new Composite(canvas, 0);
        GridLayout buttonLayout = new GridLayout(1, true);
        buttonParent.setLayout((Layout)buttonLayout);
        buttonParent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fConfigureButton = new Button(buttonParent, 8);
        this.fConfigureButton.setEnabled(false);
        this.fConfigureButton.setText(Messages.ServiceModelWidget_2);
        this.fConfigureButton.setLayoutData((Object)new GridData(768));
        Listener configureListener = this.getConfigureListener();
        this.fConfigureButton.addListener(13, configureListener);
        this.fAddButton = new Button(buttonParent, 8);
        this.fAddButton.setEnabled(true);
        this.fAddButton.setText(Messages.ServiceModelWidget_6);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        Listener addListener = this.getAddListener();
        this.fAddButton.addListener(13, addListener);
        this.fRemoveButton = new Button(buttonParent, 8);
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.setText(Messages.ServiceModelWidget_7);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        Listener removeListener = this.getRemoveListener();
        this.fRemoveButton.addListener(13, removeListener);
        this.updateAddRemoveButtons();
        return canvas;
    }

    public Listener getConfigChangeListener() {
        return this.fConfigChangeListener;
    }

    public Map<String, IServiceProvider> getProviderIDToProviderMap() {
        return this.fProviderIDToProviderMap;
    }

    public IServiceConfiguration getServiceConfiguration() {
        return this.fServiceConfiguration;
    }

    public Map<String, String> getServiceIDToSelectedProviderID() {
        return this.fServiceIDToSelectedProviderID;
    }

    public Table getTable() {
        return this.fTable;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.fSelection = selection;
    }

    public boolean isConfigured() {
        return this.isConfigured(null, this.fServiceIDToSelectedProviderID, this.getProviderIDToProviderMap());
    }

    public boolean performFinish() {
        return true;
    }

    public void setConfigChangeListener(Listener configChangeListener) {
        this.fConfigChangeListener = configChangeListener;
    }

    public void setProviderIDToProviderMap(Map<String, IServiceProvider> providerIDToProviderMap) {
        this.fProviderIDToProviderMap = providerIDToProviderMap;
    }

    public void setServiceIDToSelectedProviderID(Map<String, String> serviceIDToSelectedProviderID) {
        this.fServiceIDToSelectedProviderID = serviceIDToSelectedProviderID;
    }

    public void setTable(Table table) {
        this.fTable = table;
    }

    private void addTableRow(IServiceConfiguration config) {
        TableItem item = new TableItem(this.fTable, 0);
        item.setText(0, config.getName());
        item.setText(1, Messages.ServiceConfigurationWidget_3);
        item.setData(SERVICE_KEY, (Object)config);
        if (this.fConfigChangeListener != null) {
            this.fConfigChangeListener.handleEvent(null);
        }
    }

    private SortedSet<IServiceProviderDescriptor> getProvidersByPriority(IService service) {
        TreeSet<IServiceProviderDescriptor> sortedProviders = new TreeSet<IServiceProviderDescriptor>(new Comparator<IServiceProviderDescriptor>(){

            @Override
            public int compare(IServiceProviderDescriptor o1, IServiceProviderDescriptor o2) {
                return o2.getPriority().compareTo(o1.getPriority());
            }
        });
        for (IServiceProviderDescriptor p : service.getProviders()) {
            sortedProviders.add(p);
        }
        return sortedProviders;
    }

    private IServiceProvider getServiceProvider(IServiceProviderDescriptor descriptor) {
        IServiceProvider serviceProvider = this.getProviderIDToProviderMap().get(descriptor.getId());
        if (serviceProvider == null) {
            serviceProvider = ServiceModelManager.getInstance().getServiceProvider(descriptor);
            this.getProviderIDToProviderMap().put(descriptor.getId(), serviceProvider);
        }
        return serviceProvider;
    }

    protected void createTableContent() {
        this.fTable.removeAll();
        for (IServiceConfiguration config : this.fServiceConfigurations) {
            this.addTableRow(config);
        }
    }

    protected Listener getAddListener() {
        return new AddListener();
    }

    protected Listener getConfigureListener() {
        return new ConfigureListener();
    }

    protected Set<IService> getContributedServices(IProject project) {
        ServiceModelManager modelManager = ServiceModelManager.getInstance();
        LinkedHashSet<IService> allApplicableServices = new LinkedHashSet<IService>();
        if (project != null) {
            String[] natureIds = new String[]{};
            try {
                natureIds = project.getDescription().getNatureIds();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < natureIds.length) {
                String natureId = natureIds[i];
                Set services = modelManager.getServices(natureId);
                if (services != null) {
                    allApplicableServices.addAll(services);
                }
                ++i;
            }
        }
        return allApplicableServices;
    }

    protected Listener getRemoveListener() {
        return new RemoveListener();
    }

    protected boolean isConfigured(IProject project, Map<String, String> serviceIDToSelectedProviderID, Map<String, IServiceProvider> providerIDToProviderMap) {
        Set<IService> allApplicableServices = this.getContributedServices(project);
        Iterator<IService> iterator = allApplicableServices.iterator();
        boolean configured = true;
        while (iterator.hasNext()) {
            String providerID = serviceIDToSelectedProviderID.get(iterator.next().getId());
            if (providerID == null) {
                return false;
            }
            IServiceProvider provider = providerIDToProviderMap.get(providerID);
            if (provider == null) {
                return false;
            }
            boolean bl = configured = configured && provider.isConfigured();
        }
        return configured;
    }

    protected void updateAddRemoveButtons() {
        Set services = ServiceModelManager.getInstance().getServices();
        this.fAddButton.setEnabled(services.size() > this.fTable.getItemCount());
        this.fRemoveButton.setEnabled(this.fTable.getItemCount() > 0);
    }

    protected void updateConfigureButton(IServiceProviderDescriptor descriptor) {
        IServiceProviderContributor contrib = ServiceModelUIManager.getInstance().getServiceProviderContributor(descriptor);
        this.fConfigureButton.setEnabled(contrib != null);
    }

    public class AddListener
    implements Listener {
        public void handleEvent(Event event) {
            HashSet<IService> displaySet = new HashSet<IService>();
            Set configServices = ServiceConfigurationWidget.this.getServiceConfiguration().getServices();
            for (IService service : ServiceModelManager.getInstance().getServices()) {
                if (configServices.contains(service)) continue;
                displaySet.add(service);
            }
            ServiceSelectionDialog dialog = new ServiceSelectionDialog(ServiceConfigurationWidget.this.getShell(), displaySet.toArray(new IService[0]));
            if (dialog.open() == 0) {
                IService[] selectedServices;
                IService[] iServiceArray = selectedServices = dialog.getSelectedServices();
                int n = selectedServices.length;
                int n2 = 0;
                while (n2 < n) {
                    IService service = iServiceArray[n2];
                    SortedSet providers = ServiceConfigurationWidget.this.getProvidersByPriority(service);
                    if (providers.size() > 0) {
                        IServiceProvider provider = ServiceModelManager.getInstance().getServiceProvider((IServiceProviderDescriptor)providers.iterator().next());
                        ServiceConfigurationWidget.this.getServiceConfiguration().setServiceProvider(service, provider);
                    } else {
                        ServicesUIPlugin.getDefault().log(NLS.bind((String)Messages.ServiceModelWidget_8, (Object)service.getId()));
                    }
                    ++n2;
                }
                ServiceConfigurationWidget.this.updateAddRemoveButtons();
            }
        }
    }

    public class ConfigureListener
    implements Listener {
        public void handleEvent(Event event) {
            TableItem[] selection = ServiceConfigurationWidget.this.fTable.getSelection();
            if (selection.length == 0) {
                return;
            }
            TableItem item = selection[0];
            IServiceProvider provider = (IServiceProvider)item.getData(ServiceConfigurationWidget.PROVIDER_KEY);
            IServiceProviderContributor contrib = ServiceModelUIManager.getInstance().getServiceProviderContributor((IServiceProviderDescriptor)provider);
            IWizard wizard = contrib.getWizard(provider, null);
            WizardDialog dialog = new WizardDialog(ServiceConfigurationWidget.this.getShell(), wizard);
            dialog.open();
            String configString = provider.getConfigurationString();
            if (configString == null) {
                configString = Messages.ServiceModelWidget_4;
            }
            item.setText(2, configString);
            if (ServiceConfigurationWidget.this.fConfigChangeListener != null) {
                ServiceConfigurationWidget.this.fConfigChangeListener.handleEvent(null);
            }
        }
    }

    public class RemoveListener
    implements Listener {
        public void handleEvent(Event event) {
            TableItem[] items = ServiceConfigurationWidget.this.fTable.getSelection();
            if (items.length == 0) {
                return;
            }
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                IService service = (IService)item.getData(ServiceConfigurationWidget.SERVICE_KEY);
                if (service != null) {
                    ServiceConfigurationWidget.this.getServiceConfiguration().disable(service);
                }
                ServiceConfigurationWidget.this.fTable.remove(ServiceConfigurationWidget.this.fTable.indexOf(item));
                ++n2;
            }
            ServiceConfigurationWidget.this.updateAddRemoveButtons();
        }
    }
}

