/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.internal.ui.actions.AbstractRemoveAllActionDelegate;
import org.eclipse.jface.action.IAction;

public class RemoveAllTerminatedAction
extends AbstractRemoveAllActionDelegate
implements ILaunchesListener2 {
    protected boolean isEnabled() {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches != null) {
            int i = 0;
            while (i < launches.length) {
                if (launches[i].isTerminated()) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void removeTerminatedLaunches(ILaunch[] elements) {
        ArrayList<ILaunch> removed = new ArrayList<ILaunch>();
        int i = 0;
        while (i < elements.length) {
            ILaunch launch = elements[i];
            if (launch.isTerminated()) {
                removed.add(launch);
            }
            ++i;
        }
        if (!removed.isEmpty()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            manager.removeLaunches(removed.toArray(new ILaunch[removed.size()]));
        }
    }

    protected void initialize() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        IAction action = this.getAction();
        if (action != null && action.isEnabled()) {
            this.update();
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.update();
    }

    public void run(IAction action) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        RemoveAllTerminatedAction.removeTerminatedLaunches(launches);
    }
}

