/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.internal.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.internal.remote.ui.RemoteUIServicesProxy;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteUIServices {
    private static final String EXTENSION_POINT_ID = "remoteUIServices";
    private static Map<String, RemoteUIServicesProxy> fRemoteUIServices = null;

    public static IRemoteServices getRemoteServices(final String id, IRunnableContext context) {
        final IRemoteServices[] remoteService = new IRemoteServices[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                remoteService[0] = RemoteServices.getRemoteServices((String)id, (IProgressMonitor)monitor);
            }
        };
        try {
            if (context != null) {
                context.run(true, false, runnable);
            } else {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return remoteService[0];
    }

    public static IRemoteUIServices getRemoteUIServices(IRemoteServices services) {
        RemoteUIServicesProxy proxy;
        if (fRemoteUIServices == null) {
            fRemoteUIServices = RemoteUIServices.retrieveRemoteUIServices();
        }
        if ((proxy = fRemoteUIServices.get(services.getId())) != null) {
            return proxy.getUIServices(services);
        }
        return null;
    }

    private static Map<String, RemoteUIServicesProxy> retrieveRemoteUIServices() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(PTPRemoteUIPlugin.getUniqueIdentifier(), EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        HashMap<String, RemoteUIServicesProxy> services = new HashMap<String, RemoteUIServicesProxy>(5);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                RemoteUIServicesProxy proxy = new RemoteUIServicesProxy(ce);
                services.put(proxy.getId(), proxy);
                ++n4;
            }
            ++n2;
        }
        return services;
    }
}

