/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.ui.handlers;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.lml.monitor.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ptp.remote.core.RemoteServicesUtils;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ActionUtils {
    private static final int UNDEFINED = -1;
    private static final int COPY_BUFFER_SIZE = 65536;

    public static void callDoControl(JobStatusData status, String operation, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            ILaunchController controller;
            String controlId = status.getString("controlId");
            if (controlId != null && (controller = LaunchControllerManager.getInstance().getLaunchController(controlId)) != null) {
                controller.start((IProgressMonitor)progress.newChild(10));
                controller.control(status.getJobId(), operation, (IProgressMonitor)progress.newChild(10));
                ActionUtils.maybeUpdateJobState(controller, status, (IProgressMonitor)progress.newChild(10));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static boolean isAuthorised(JobStatusData status) {
        IRemoteConnection connection;
        ILaunchController control;
        IRemoteServices services;
        String controlId = status.getString("controlId");
        return controlId != null && (services = RemoteServices.getRemoteServices((String)(control = LaunchControllerManager.getInstance().getLaunchController(controlId)).getRemoteServicesId())) != null && (connection = services.getConnectionManager().getConnection(control.getConnectionName())) != null && connection.getUsername().equals(status.getString("owner"));
    }

    public static void maybeUpdateJobState(JobStatusData status, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            ILaunchController controller;
            String controlId = status.getString("controlId");
            if (controlId != null && (controller = LaunchControllerManager.getInstance().getLaunchController(controlId)) != null) {
                controller.start((IProgressMonitor)progress.newChild(10));
                ActionUtils.maybeUpdateJobState(controller, status, (IProgressMonitor)progress.newChild(10));
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static void maybeUpdateJobState(ILaunchController controller, JobStatusData status, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        try {
            IJobStatus refreshed = controller.getJobStatus(status.getJobId(), true, (IProgressMonitor)progress.newChild(10));
            status.updateState(refreshed.getState(), refreshed.getStateDetail());
            ActionUtils.maybeCheckFiles(status);
            String controlId = status.getString("controlId");
            LMLManager.getInstance().updateUserJob(controlId, status.getJobId(), status.getState(), status.getStateDetail());
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void readRemoteFile(String remoteServicesId, String connName, String path) {
        FileReadConsoleAppender reader = new FileReadConsoleAppender(remoteServicesId, connName, path);
        reader.setUser(true);
        reader.schedule();
    }

    public static void removeFiles(final String controlId, final List<JobStatusData> selected) {
        Job j = new Job(Messages.ActionUtils_Remove_Files){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(50 * selected.size()));
                for (JobStatusData status : selected) {
                    IFileStore lres;
                    ILaunchController control = LaunchControllerManager.getInstance().getLaunchController(controlId);
                    if (control == null) continue;
                    String remotePath = status.getString("stdoutRemotePath");
                    if (remotePath != null) {
                        try {
                            lres = RemoteServicesUtils.getRemoteFileWithProgress((String)control.getRemoteServicesId(), (String)control.getConnectionName(), (String)remotePath, (IProgressMonitor)progress);
                            if (lres != null && lres.fetchInfo(0, (IProgressMonitor)progress.newChild(25)).exists()) {
                                lres.delete(0, (IProgressMonitor)progress.newChild(25));
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    if ((remotePath = status.getString("stderrRemotePath")) == null) continue;
                    try {
                        lres = RemoteServicesUtils.getRemoteFileWithProgress((String)control.getRemoteServicesId(), (String)control.getConnectionName(), (String)remotePath, (IProgressMonitor)progress);
                        if (lres == null || !lres.fetchInfo(0, (IProgressMonitor)progress.newChild(25)).exists()) continue;
                        lres.delete(0, (IProgressMonitor)progress.newChild(25));
                    }
                    catch (Throwable throwable) {}
                }
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private static void maybeCheckFiles(JobStatusData job) {
        if ("JOB_OUTERR_READY".equals(job.getStateDetail())) {
            if (job.getString("stdoutRemotePath") != null) {
                job.setOutReady(true);
            }
            if (job.getString("stderrRemotePath") != null) {
                job.setErrReady(true);
            }
        }
    }

    private ActionUtils() {
    }

    private static class FileReadConsoleAppender
    extends Job {
        private IOConsole console;
        private IOConsoleOutputStream stream;
        private int read;
        private final String fRemoteServicesId;
        private final String fConnName;

        public FileReadConsoleAppender(String remoteServices, String connName, String path) {
            super(path);
            this.fRemoteServicesId = remoteServices;
            this.fConnName = connName;
            this.read = 0;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block16: {
                try {
                    this.console = new IOConsole(this.getName(), null);
                    ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
                    this.console.activate();
                    this.stream = this.console.newOutputStream();
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
                    IFileStore lres = RemoteServicesUtils.getRemoteFileWithProgress((String)this.fRemoteServicesId, (String)this.fConnName, (String)this.getName(), (IProgressMonitor)progress);
                    if (lres == null) break block16;
                    BufferedInputStream is = new BufferedInputStream(lres.openInputStream(0, (IProgressMonitor)progress.newChild(25)));
                    byte[] buffer = new byte[65536];
                    try {
                        while (!progress.isCanceled()) {
                            try {
                                this.read = is.read(buffer, 0, 65536);
                            }
                            catch (EOFException eOFException) {
                                break;
                            }
                            if (this.read == -1) {
                                break;
                            }
                            if (progress.isCanceled()) {
                                this.read = -1;
                                break;
                            }
                            progress.worked(5);
                            this.stream.write(buffer, 0, this.read);
                        }
                    }
                    finally {
                        try {
                            if (this.stream != null) {
                                this.stream.flush();
                                this.stream.close();
                            }
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException t) {
                            t.printStackTrace();
                        }
                        monitor.done();
                    }
                }
                catch (Throwable t) {
                    if (monitor.isCanceled()) break block16;
                    return CoreExceptionUtils.getErrorStatus((String)t.getMessage(), (Throwable)t);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

