/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.ptp.internal.remote.terminal.IRemoteToolsSettings;
import org.eclipse.ptp.internal.remote.terminal.RemoteToolsConnection;
import org.eclipse.ptp.internal.remote.terminal.RemoteToolsSettings;
import org.eclipse.ptp.internal.remote.terminal.RemoteToolsSettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class RemoteToolsConnector
extends TerminalConnectorImpl {
    private OutputStream fOutputStream;
    private InputStream fInputStream;
    private RemoteToolsConnection fConnection;
    private final RemoteToolsSettings fSettings;

    public RemoteToolsConnector() {
        this(new RemoteToolsSettings());
    }

    public RemoteToolsConnector(RemoteToolsSettings settings) {
        this.fSettings = settings;
    }

    public void initialize() throws Exception {
    }

    public void connect(ITerminalControl control) {
        super.connect(control);
        this.fConnection = new RemoteToolsConnection(this, control);
        this.fConnection.start();
    }

    public synchronized void doDisconnect() {
        if (this.getInputStream() != null) {
            try {
                this.getInputStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
        if (this.getTerminalToRemoteStream() != null) {
            try {
                this.getTerminalToRemoteStream().close();
            }
            catch (Exception exception) {
                Logger.logException((Exception)exception);
            }
        }
    }

    public void setTerminalSize(int newWidth, int newHeight) {
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public OutputStream getTerminalToRemoteStream() {
        return this.fOutputStream;
    }

    void setInputStream(InputStream inputStream) {
        this.fInputStream = inputStream;
    }

    void setOutputStream(OutputStream outputStream) {
        this.fOutputStream = outputStream;
    }

    public IRemoteToolsSettings getSshSettings() {
        return this.fSettings;
    }

    public ISettingsPage makeSettingsPage() {
        return new RemoteToolsSettingsPage(this.fSettings);
    }

    public String getSettingsSummary() {
        return this.fSettings.getSummary();
    }

    public void load(ISettingsStore store) {
        this.fSettings.load(store);
    }

    public void save(ISettingsStore store) {
        this.fSettings.save(store);
    }
}

