/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui;

import java.util.BitSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.internal.debug.ui.PDebugUIUtils;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class PInstructionPointerAnnotation
extends MarkerAnnotation {
    private IAnnotationModel annotationModel = null;
    private TaskSet tasks = null;
    private Position position = null;
    private IMarker marker = null;

    public PInstructionPointerAnnotation(IMarker marker, Position position, IAnnotationModel annotationModel) {
        super(marker);
        this.marker = marker;
        this.position = position;
        this.annotationModel = annotationModel;
    }

    public void addTasks(TaskSet aTasks) {
        if (this.tasks == null) {
            this.tasks = aTasks.copy();
        }
        if (this.tasks.taskSize() < aTasks.taskSize()) {
            aTasks.or((BitSet)this.tasks);
            this.tasks = aTasks.copy();
        } else {
            this.tasks.or((BitSet)aTasks);
        }
    }

    public boolean contains(TaskSet aTasks) {
        return this.tasks.intersects((BitSet)aTasks);
    }

    public int[] containTasks(TaskSet aTasks) {
        aTasks.and((BitSet)this.tasks);
        return aTasks.toArray();
    }

    public boolean deleteMarker() {
        IMarker marker = this.getMarker();
        if (marker.exists()) {
            try {
                marker.delete();
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return true;
    }

    public IAnnotationModel getAnnotationModel() {
        return this.annotationModel;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public String getMessage() {
        return this.getText();
    }

    public Position getPosition() {
        return this.position;
    }

    public TaskSet getTasks() {
        return this.tasks;
    }

    public boolean isEmpty() {
        return this.tasks.isEmpty();
    }

    public void removeTasks(TaskSet aTasks) {
        this.tasks.andNot((BitSet)aTasks);
    }

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public void setMessage(boolean isRegister) {
        int[] tasks = this.getTasks().toArray();
        if (tasks.length == 0) {
            this.setMessage("");
            this.deleteMarker();
            return;
        }
        String msg = Messages.PInstructionPointerAnnotation2_0;
        if (!isRegister && tasks.length == 1) {
            msg = Messages.PInstructionPointerAnnotation2_1;
        } else if (isRegister && tasks.length > 1) {
            msg = Messages.PInstructionPointerAnnotation2_2;
        } else if (!isRegister && tasks.length > 1) {
            msg = Messages.PInstructionPointerAnnotation2_3;
        }
        msg = String.valueOf(msg) + PDebugUIUtils.arrayToString(tasks);
        this.setMessage(msg);
    }

    public void setMessage(String message) {
        try {
            this.getMarker().setAttribute("message", (Object)message);
        }
        catch (CoreException coreException) {}
        this.setText(message);
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void setTasks(TaskSet tasks) {
        this.tasks = tasks;
    }
}

