/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui;

import java.util.BitSet;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.ptp.core.Preferences;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.IPJobStatus;
import org.eclipse.ptp.debug.core.IPDebugConstants;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.internal.debug.core.PDebugModel;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.ui.PTPDebugUIPlugin;
import org.eclipse.ptp.internal.debug.ui.PVariableManager;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.managers.JobManager;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ptp.internal.ui.views.IToolTipProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class UIDebugManager
extends JobManager
implements IBreakpointListener {
    private final PVariableManager jobVarMgr = new PVariableManager();
    private PDebugModel debugModel = null;
    private IPSession currentSession = null;
    private boolean prefAutoUpdateVarOnSuspend = false;
    private boolean prefAutoUpdateVarOnChange = false;
    private boolean prefRegisterProc0 = true;
    private final IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String preferenceType = event.getKey();
            String value = (String)event.getNewValue();
            if (preferenceType.equals(IPDebugConstants.PREF_DEBUG_REGISTER_PROC_0)) {
                UIDebugManager.this.prefRegisterProc0 = new Boolean(value);
            } else if (preferenceType.equals(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND)) {
                UIDebugManager.this.prefAutoUpdateVarOnSuspend = new Boolean(value);
            } else if (preferenceType.equals(IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE)) {
                UIDebugManager.this.prefAutoUpdateVarOnChange = new Boolean(value);
            } else if (preferenceType.equals(IPDebugConstants.PREF_DEBUG_COMM_TIMEOUT)) {
                IJobStatus[] iJobStatusArray = UIDebugManager.this.getJobs();
                int n = iJobStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IJobStatus job = iJobStatusArray[n2];
                    IPSession session = UIDebugManager.this.getDebugSession(job.getJobId());
                    if (session != null) {
                        session.getPDISession().setRequestTimeout(new Integer(value).longValue());
                    }
                    ++n2;
                }
            }
        }
    };

    public UIDebugManager() {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        this.debugModel = PTPDebugCorePlugin.getDebugModel();
        this.initializePreferences();
    }

    public void breakpointAdded(final IBreakpoint breakpoint) {
        if (PTPDebugUIPlugin.isPTPDebugPerspective() && breakpoint instanceof ICLineBreakpoint) {
            WorkbenchJob uiJob = new WorkbenchJob(Messages.UIDebugManager_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint(breakpoint, true);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            uiJob.setSystem(true);
            uiJob.schedule();
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void fireJobChangedEvent(int type, String new_id, String old_id) {
        this.updateBreakpointMarker("Root");
        if (old_id != null) {
            this.removeAllRegisterElements(old_id);
        }
        super.fireJobChangedEvent(type, new_id, old_id);
    }

    public synchronized void fireSetEvent(int eventType, BitSet elements, IElementSet cur_set, IElementSet pre_set) {
        IPSession session;
        IJobStatus job = this.getJob();
        if (job != null && (session = this.getDebugSession(job.getJobId())) != null) {
            switch (eventType) {
                case 0: {
                    TaskSet cTasks = this.convertElementsToBitList(session, elements);
                    this.debugModel.createSet(session, cur_set.getName(), cTasks);
                    break;
                }
                case 1: {
                    this.debugModel.deleteSet(session, cur_set.getName());
                    break;
                }
                case 2: {
                    if (cur_set == null) break;
                    this.updateBreakpointMarker(cur_set.getName());
                    this.updateRegisterUnRegisterElements(cur_set, pre_set, this.getCurrentJobId());
                    break;
                }
                case 3: {
                    TaskSet aTasks = this.convertElementsToBitList(session, elements);
                    this.debugModel.addTasks(session, cur_set.getName(), aTasks);
                    break;
                }
                case 4: {
                    TaskSet rTasks = this.convertElementsToBitList(session, elements);
                    this.debugModel.removeTasks(session, cur_set.getName(), rTasks);
                }
            }
            super.fireSetEvent(eventType, elements, cur_set, pre_set);
        }
    }

    public String getCurrentJobId() {
        IJobStatus job = this.getJob();
        if (job != null) {
            return job.getJobId();
        }
        return "";
    }

    public IPSession getCurrentSession() {
        IJobStatus job;
        if (this.currentSession == null && (job = this.getJob()) != null) {
            this.currentSession = this.getDebugSession(job.getJobId());
        }
        return this.currentSession;
    }

    public IPSession getDebugSession(String jobId) {
        if (this.isNoJob(jobId)) {
            return null;
        }
        return this.debugModel.getSession(jobId);
    }

    public PVariableManager getJobVariableManager() {
        return this.jobVarMgr;
    }

    public TaskSet getSelectedRegisteredTasks(Object obj) {
        IDebugTarget target = null;
        if (obj instanceof IStackFrame) {
            target = ((IStackFrame)obj).getDebugTarget();
        } else if (obj instanceof IThread) {
            target = ((IThread)obj).getDebugTarget();
        } else if (obj instanceof IDebugTarget) {
            target = (IDebugTarget)obj;
        }
        if (target instanceof IPDebugTarget) {
            return ((IPDebugTarget)target).getTasks();
        }
        return null;
    }

    public TaskSet getTasks(IPSession session, String set_id) throws CoreException {
        return this.debugModel.getTasks(session, set_id);
    }

    public TaskSet getTasks(String set_id) throws CoreException {
        return this.getTasks(this.getCurrentJobId(), set_id);
    }

    public TaskSet getTasks(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_1, null));
        }
        return this.getTasks(session, set_id);
    }

    public String getValueText(int taskID, IToolTipProvider provider) {
        IPJobStatus pJob;
        IJobStatus job = this.getJob();
        if (job != null && job instanceof IAdaptable && (pJob = (IPJobStatus)job.getAdapter(IPJobStatus.class)) != null) {
            return this.getJobVariableManager().getValue(pJob, taskID, provider);
        }
        return Messages.UIDebugManager_2;
    }

    public boolean isAutoUpdateVarOnChange() {
        return this.prefAutoUpdateVarOnChange;
    }

    public boolean isAutoUpdateVarOnSuspend() {
        return this.prefAutoUpdateVarOnSuspend;
    }

    public boolean isDebugMode(IJobStatus job) {
        if (job == null) {
            return false;
        }
        return job.getLaunchMode().equals("debug");
    }

    public boolean isDebugMode(String job_id) {
        if (this.isNoJob(job_id)) {
            return false;
        }
        return this.isDebugMode(this.findJobById(job_id));
    }

    public boolean isEnabledDefaultRegister() {
        return this.prefRegisterProc0;
    }

    public boolean isRunning(IJobStatus job) {
        return job != null && job.getState() != "COMPLETED";
    }

    public boolean isRunning(String job_id) {
        if (this.isNoJob(job_id)) {
            return false;
        }
        return this.isRunning(this.findJobById(job_id));
    }

    public void registerElements(final BitSet elements) {
        new UIDebugWorkbenchJob(false, Messages.UIDebugManager_3, this.getJob(), new IDebugProgressMonitor(){

            public IStatus runDebugJob(IJobStatus job, IPSession session, IProgressMonitor monitor) {
                if (job == null || session == null) {
                    return Status.CANCEL_STATUS;
                }
                TaskSet tasks = session.getTasks(-1);
                tasks.or(elements);
                UIDebugManager.this.registerTasks(session, tasks);
                return Status.OK_STATUS;
            }
        });
    }

    public void registerTasks(IPSession session, TaskSet tasks) {
        session.createDebugTarget(tasks, true, true);
    }

    public void removeAllRegisterElements(String job_id) {
        new UIDebugWorkbenchJob(false, Messages.UIDebugManager_4, this.findJobById(job_id), new IDebugProgressMonitor(){

            public IStatus runDebugJob(IJobStatus job, IPSession session, IProgressMonitor monitor) {
                if (job == null || session == null) {
                    return Status.CANCEL_STATUS;
                }
                session.deleteDebugTargets(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        });
    }

    public void resume() throws CoreException {
        this.resume(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void resume(String jobId, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(jobId);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_5, null));
        }
        try {
            session.getPDISession().resume(this.getTasks(session, set_id), false);
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void setJob(IJobStatus job) {
        this.currentSession = job != null ? this.getDebugSession(job.getJobId()) : null;
        super.setJob(job);
    }

    public void shutdown() {
        Preferences.removePreferenceChangeListener((String)PTPDebugCorePlugin.getUniqueIdentifier(), (IEclipsePreferences.IPreferenceChangeListener)this.fPreferenceChangeListener);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.jobVarMgr.shutdown();
        super.shutdown();
    }

    public void stepInto() throws CoreException {
        this.stepInto(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepInto(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_6, null));
        }
        try {
            TaskSet tasks = this.getTasks(session, set_id);
            session.getPDISession().stepInto(tasks, 1);
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stepOver() throws CoreException {
        this.stepOver(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepOver(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_7, null));
        }
        try {
            TaskSet tasks = this.getTasks(session, set_id);
            session.getPDISession().stepOver(tasks, 1);
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void stepReturn() throws CoreException {
        this.stepReturn(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void stepReturn(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_8, null));
        }
        try {
            TaskSet tasks = this.getTasks(session, set_id);
            session.getPDISession().stepReturn(tasks, 0);
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void suspend() throws CoreException {
        this.suspend(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void suspend(String job_id, String set_id) throws CoreException {
        IPSession session = this.getDebugSession(job_id);
        if (session == null) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_9, null));
        }
        try {
            session.getPDISession().suspend(this.getTasks(session, set_id));
        }
        catch (PDIException e) {
            throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
        }
    }

    public void terminate() throws CoreException {
        this.terminate(this.getCurrentJobId(), this.getCurrentSetId());
    }

    public void terminate(String jobId, String set_id) throws CoreException {
        if (this.isDebugMode(jobId)) {
            IPSession session = this.getDebugSession(jobId);
            if (session == null) {
                throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, Messages.UIDebugManager_10, null));
            }
            try {
                session.getPDISession().terminate(this.getTasks(session, set_id));
            }
            catch (PDIException e) {
                throw new CoreException((IStatus)new Status(4, PTPDebugUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), null));
            }
        }
    }

    public void unregisterElements(final BitSet elements) {
        new UIDebugWorkbenchJob(false, Messages.UIDebugManager_11, this.getJob(), new IDebugProgressMonitor(){

            public IStatus runDebugJob(IJobStatus job, IPSession session, IProgressMonitor monitor) {
                if (job == null || session == null) {
                    return Status.CANCEL_STATUS;
                }
                TaskSet tasks = session.getTasks(-1);
                tasks.or(elements);
                UIDebugManager.this.unregisterTasks(session, tasks);
                return Status.OK_STATUS;
            }
        });
    }

    public void unregisterTasks(IPSession session, TaskSet tasks) {
        session.deleteDebugTarget(tasks, true, true);
    }

    public void updateBreakpointMarker(final String cur_sid) {
        WorkbenchJob uiJob = new WorkbenchJob(Messages.UIDebugManager_12){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    PDebugModel.updateBreakpoints((String)cur_sid, (IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        uiJob.setSystem(true);
        uiJob.schedule();
    }

    public void updateCurrentJobVariableValues() {
        IJobStatus job = this.getJob();
        if (job != null) {
            this.getJobVariableManager().updateValues(job.getJobId());
        }
    }

    public void updateRegisterUnRegisterElements(final IElementSet curSet, IElementSet preSet, String job_id) {
        new UIDebugWorkbenchJob(false, Messages.UIDebugManager_13, this.findJobById(job_id), new IDebugProgressMonitor(){

            public IStatus runDebugJob(IJobStatus job, IPSession session, IProgressMonitor monitor) {
                if (job == null || session == null) {
                    return Status.CANCEL_STATUS;
                }
                session.reloadDebugTargets(UIDebugManager.this.debugModel.getTasks(session, curSet.getID()), true, false);
                monitor.done();
                return Status.OK_STATUS;
            }
        });
    }

    private TaskSet convertElementsToBitList(IPSession session, BitSet elements) {
        TaskSet tasks = session.getTasks(-1);
        tasks.or(elements);
        return tasks;
    }

    private void initializePreferences() {
        Preferences.addPreferenceChangeListener((String)PTPDebugCorePlugin.getUniqueIdentifier(), (IEclipsePreferences.IPreferenceChangeListener)this.fPreferenceChangeListener);
        this.prefRegisterProc0 = Preferences.getBoolean((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_DEBUG_REGISTER_PROC_0);
        this.prefAutoUpdateVarOnSuspend = Preferences.getBoolean((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_UPDATE_VARIABLES_ON_SUSPEND);
        this.prefAutoUpdateVarOnChange = Preferences.getBoolean((String)PTPDebugCorePlugin.getUniqueIdentifier(), (String)IPDebugConstants.PREF_UPDATE_VARIABLES_ON_CHANGE);
    }

    private static interface IDebugProgressMonitor {
        public IStatus runDebugJob(IJobStatus var1, IPSession var2, IProgressMonitor var3);
    }

    private class UIDebugWorkbenchJob
    extends WorkbenchJob {
        private IJobStatus job;
        private IPSession session;
        private IDebugProgressMonitor debugMonitor;

        public UIDebugWorkbenchJob(boolean runInDialog, String name, IJobStatus job, IDebugProgressMonitor debugMonitor) {
            super(name);
            this.job = null;
            this.session = null;
            this.debugMonitor = null;
            this.job = job;
            this.debugMonitor = debugMonitor;
            if (runInDialog) {
                PlatformUI.getWorkbench().getProgressService().showInDialog(null, (Job)this);
            }
            this.schedule();
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            return this.debugMonitor.runDebugJob(this.job, this.session, monitor);
        }

        public boolean shouldRun() {
            this.session = UIDebugManager.this.getDebugSession(this.job.getJobId());
            if (this.session == null) {
                return false;
            }
            if (!this.session.isReady()) {
                return false;
            }
            return super.shouldRun();
        }
    }
}

