/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCallStmtNode;
import org.eclipse.photran.internal.core.parser.ASTDerivedTypeDefNode;
import org.eclipse.photran.internal.core.parser.ASTEntityDeclNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.ASTFunctionSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTModuleNode;
import org.eclipse.photran.internal.core.parser.ASTNameNode;
import org.eclipse.photran.internal.core.parser.ASTObjectNameNode;
import org.eclipse.photran.internal.core.parser.ASTSubroutineSubprogramNode;
import org.eclipse.photran.internal.core.parser.ASTTypeDeclarationStmtNode;
import org.eclipse.photran.internal.core.parser.ASTUseStmtNode;
import org.eclipse.photran.internal.core.parser.ASTVarOrFnRefNode;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IInternalSubprogram;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranEditorRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public class ExtractSubprogramToModuleRefactoring
extends FortranEditorRefactoring {
    IASTNode selectedFunctionOrSubroutine = null;
    List<ASTModuleNode> fileModules = new LinkedList<ASTModuleNode>();
    private String moduleName;
    ScopingNode originalScope = null;
    List<Definition> parameters = new LinkedList<Definition>();

    public String getName() {
        return "Extract Subroutine Or Function To Module";
    }

    public void setModuleName(String name) {
        this.moduleName = name;
    }

    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        IASTNode selectedNode = ExtractSubprogramToModuleRefactoring.findEnclosingNode(this.astOfFileInEditor, this.selectedRegionInEditor);
        if (selectedNode instanceof ASTSubroutineSubprogramNode || selectedNode instanceof ASTFunctionSubprogramNode) {
            this.selectedFunctionOrSubroutine = selectedNode;
        } else {
            this.fail("Please, select a Subroutine or a Function statement.");
        }
        for (ScopingNode scope : this.astOfFileInEditor.getRoot().getAllContainedScopes()) {
            if (!(scope instanceof ASTModuleNode)) continue;
            this.fileModules.add((ASTModuleNode)scope);
        }
        this.originalScope = ((ScopingNode)this.selectedFunctionOrSubroutine).getEnclosingScope();
    }

    ASTModuleNode moduleExists(String moduleName) {
        for (ASTModuleNode module : this.fileModules) {
            if (!module.getName().equalsIgnoreCase(moduleName)) continue;
            return module;
        }
        return null;
    }

    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        Character[] numeric_digits = new Character[]{Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9')};
        if (this.moduleName.length() < 1) {
            this.fail("Fill in the fields with valid values.");
        }
        int i = 0;
        while (i < this.moduleName.length()) {
            if (this.moduleName.charAt(i) == ' ' || this.moduleName.charAt(i) == '!' || this.moduleName.charAt(i) == '\t') {
                this.fail("The module name can not contain spaces and exclamation points.");
            }
            ++i;
        }
        i = 0;
        while (i < numeric_digits.length) {
            if (this.moduleName.charAt(0) == numeric_digits[i].charValue()) {
                this.fail("The module name can not start with numeric digits.");
            }
            ++i;
        }
        ASTModuleNode module = this.moduleExists(this.moduleName);
        if (module != null) {
            this.fail("The module " + this.moduleName.toUpperCase() + " already exists. Choose another name for the module to be created.");
        }
    }

    protected void doCreateChange(IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        LinkedList<ScopingNode> scopes = new LinkedList<ScopingNode>();
        Token insertModule = this.astOfFileInEditor.getRoot().findFirstToken();
        for (Definition def : this.originalScope.getAllDefinitions()) {
            if (!def.isParameter() || this.hasReference(def.getDeclaredName(), this.originalScope) || !this.hasReference(def.getDeclaredName(), this.selectedFunctionOrSubroutine)) continue;
            boolean moveParameter = true;
            for (IInternalSubprogram internal : this.originalScope.getInternalSubprograms()) {
                if (internal instanceof ASTSubroutineSubprogramNode) {
                    if (this.selectedFunctionOrSubroutine instanceof ASTSubroutineSubprogramNode) {
                        if ((ASTSubroutineSubprogramNode)internal != (ASTSubroutineSubprogramNode)this.selectedFunctionOrSubroutine && this.hasReference(def.getDeclaredName(), (ASTSubroutineSubprogramNode)internal)) {
                            moveParameter = false;
                        }
                    } else if (this.hasReference(def.getDeclaredName(), (ASTSubroutineSubprogramNode)internal)) {
                        moveParameter = false;
                    }
                }
                if (!(internal instanceof ASTFunctionSubprogramNode)) continue;
                if (this.selectedFunctionOrSubroutine instanceof ASTFunctionSubprogramNode) {
                    if ((ASTFunctionSubprogramNode)internal == (ASTFunctionSubprogramNode)this.selectedFunctionOrSubroutine || !this.hasReference(def.getDeclaredName(), (ASTFunctionSubprogramNode)internal)) continue;
                    moveParameter = false;
                    continue;
                }
                if (!this.hasReference(def.getDeclaredName(), (ASTFunctionSubprogramNode)internal)) continue;
                moveParameter = false;
            }
            if (!moveParameter) continue;
            this.parameters.add(def);
            try {
                this.removeVariableDeclFor(def);
            }
            catch (VPGRefactoring.PreconditionFailure e) {
                e.printStackTrace();
            }
        }
        String newModuleNode = "MODULE " + this.moduleName + "\n";
        for (Definition def : this.parameters) {
            ASTTypeDeclarationStmtNode declarationNode = this.getTypeDeclarationStmtNode(def.getTokenRef().findToken().getParent());
            newModuleNode = String.valueOf(newModuleNode) + "\t" + declarationNode.toString();
        }
        newModuleNode = String.valueOf(newModuleNode) + "CONTAINS\n";
        newModuleNode = String.valueOf(newModuleNode) + this.selectedFunctionOrSubroutine.toString();
        newModuleNode = String.valueOf(newModuleNode) + "END MODULE " + this.moduleName + "\n\n";
        insertModule.setText(String.valueOf(newModuleNode) + insertModule.getText());
        this.addUseInScope(scopes);
        this.selectedFunctionOrSubroutine.removeFromTree();
        if (this.originalScope.getInternalSubprograms().size() == 1) {
            this.originalScope.getContainsStmt().removeFromTree();
        }
        this.addChangeFromModifiedAST(this.fileInEditor, progressMonitor);
        ((PhotranVPG)this.vpg).releaseAST(this.fileInEditor);
    }

    private void removeVariableDeclFor(Definition def) throws VPGRefactoring.PreconditionFailure {
        ASTTypeDeclarationStmtNode declarationNode = this.getTypeDeclarationStmtNode(def.getTokenRef().findToken().getParent());
        IASTListNode<ASTEntityDeclNode> entityDeclList = declarationNode.getEntityDeclList();
        if (entityDeclList.size() == 1) {
            declarationNode.findFirstToken().setWhiteBefore("");
            declarationNode.replaceWith("");
        } else {
            this.removeVariableDeclFromList(def, entityDeclList);
        }
    }

    private void removeVariableDeclFromList(Definition def, IASTListNode<ASTEntityDeclNode> entityDeclList) throws VPGRefactoring.PreconditionFailure {
        for (ASTEntityDeclNode decl : entityDeclList) {
            ASTObjectNameNode objectName = decl.getObjectName();
            String declName = objectName.getObjectName().getText();
            if (!declName.equals(def.getDeclaredName())) continue;
            if (entityDeclList.remove(decl)) break;
            this.fail("The operation could not be completed.");
            break;
        }
        entityDeclList.findFirstToken().setWhiteBefore(" ");
    }

    private ASTTypeDeclarationStmtNode getTypeDeclarationStmtNode(IASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ASTTypeDeclarationStmtNode) {
            return (ASTTypeDeclarationStmtNode)node;
        }
        return this.getTypeDeclarationStmtNode(node.getParent());
    }

    private boolean hasReference(String name, IASTNode scope) {
        int i;
        boolean r = false;
        if (scope instanceof ASTSubroutineSubprogramNode) {
            i = 0;
            while (i < ((ASTSubroutineSubprogramNode)scope).getBody().size()) {
                r = this.isReferenced((IASTNode)((ASTSubroutineSubprogramNode)scope).getBody().get(i), name);
                if (r) break;
                ++i;
            }
        }
        if (scope instanceof ASTFunctionSubprogramNode) {
            i = 0;
            while (i < ((ASTFunctionSubprogramNode)scope).getBody().size()) {
                r = this.isReferenced((IASTNode)((ASTFunctionSubprogramNode)scope).getBody().get(i), name);
                if (r) break;
                ++i;
            }
        }
        return r;
    }

    private boolean hasReference(String name, ScopingNode scope) {
        boolean r = false;
        int i = 0;
        while (i < scope.getBody().size()) {
            r = this.isReferenced((IASTNode)scope.getBody().get(i), name);
            if (r) break;
            ++i;
        }
        return r;
    }

    private boolean isReferenced(IASTNode node, String name) {
        boolean r = false;
        if (node instanceof ASTVarOrFnRefNode) {
            r = this.existsReferenceForVariable(node, name);
        } else {
            for (IASTNode iASTNode : node.getChildren()) {
                if (r) break;
                r = this.isReferenced(iASTNode, name);
            }
        }
        return r;
    }

    private boolean existsReferenceForVariable(IASTNode node, String name) {
        boolean r = false;
        if (node instanceof ASTNameNode) {
            if (((ASTNameNode)node).getName().getText().equalsIgnoreCase(name)) {
                r = true;
            }
        } else {
            for (IASTNode iASTNode : node.getChildren()) {
                if (r) break;
                r = this.existsReferenceForVariable(iASTNode, name);
            }
        }
        return r;
    }

    private void addUseInScope(List<ScopingNode> scopes) {
        String name = null;
        for (ScopingNode scope : this.astOfFileInEditor.getRoot().getAllContainedScopes()) {
            if (scope instanceof ASTExecutableProgramNode || scope instanceof ASTDerivedTypeDefNode) continue;
            for (IASTNode iASTNode : scope.getBody()) {
                if (iASTNode instanceof ASTCallStmtNode) {
                    name = this.selectedFunctionOrSubroutine instanceof ASTSubroutineSubprogramNode ? ((ASTSubroutineSubprogramNode)this.selectedFunctionOrSubroutine).getName() : ((ASTFunctionSubprogramNode)this.selectedFunctionOrSubroutine).getName();
                    if (((ASTCallStmtNode)iASTNode).getSubroutineName().getText().equalsIgnoreCase(name) && !scopes.contains(scope)) {
                        scopes.add(scope);
                    }
                }
                if (!(iASTNode instanceof ASTAssignmentStmtNode) || !(this.selectedFunctionOrSubroutine instanceof ASTFunctionSubprogramNode)) continue;
                name = ((ASTFunctionSubprogramNode)this.selectedFunctionOrSubroutine).getName();
                String funcName = null;
                if (!(((ASTAssignmentStmtNode)iASTNode).getRhs() instanceof ASTVarOrFnRefNode) || !name.equalsIgnoreCase(funcName = ((ASTVarOrFnRefNode)((ASTAssignmentStmtNode)iASTNode).getRhs()).getName().getName().getText()) || scopes.contains(scope)) continue;
                scopes.add(scope);
            }
        }
        boolean hasUse = false;
        for (ScopingNode scope : scopes) {
            hasUse = false;
            for (IASTNode iASTNode : scope.getBody()) {
                if (!(iASTNode instanceof ASTUseStmtNode) || !((ASTUseStmtNode)iASTNode).getName().getText().equalsIgnoreCase(this.moduleName)) continue;
                hasUse = true;
                break;
            }
            if (hasUse) continue;
            String string = scope.getHeaderStmt().findLastToken().getText();
            scope.getHeaderStmt().findLastToken().setText(String.valueOf(string) + "\tUSE " + this.moduleName + "\n");
        }
    }
}

