/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ptp.debug.core.IPDebugConfiguration;
import org.eclipse.ptp.debug.core.IPDebugger;
import org.eclipse.ptp.internal.debug.core.PTPDebugCorePlugin;
import org.eclipse.ptp.internal.debug.core.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDebugConfiguration
implements IPDebugConfiguration {
    private String[] fCoreExt;
    private HashSet<String> fCPUs;
    private final IConfigurationElement fElement;
    private HashSet<String> fModes;

    public PDebugConfiguration(IConfigurationElement element) {
        this.fElement = element;
    }

    @Override
    public String[] getCoreFileExtensions() {
        if (this.fCoreExt == null) {
            ArrayList<String> exts = new ArrayList<String>();
            String cexts = this.getConfigurationElement().getAttribute("coreFileFilter");
            if (cexts != null) {
                StringTokenizer tokenizer = new StringTokenizer(cexts, ",");
                while (tokenizer.hasMoreTokens()) {
                    String ext = tokenizer.nextToken().trim();
                    exts.add(ext);
                }
            }
            exts.add("*.*");
            this.fCoreExt = exts.toArray(new String[exts.size()]);
        }
        return this.fCoreExt;
    }

    @Override
    public String[] getCPUList() {
        return this.getCPUs().toArray(new String[0]);
    }

    @Override
    public IPDebugger getDebugger() throws CoreException {
        Object debugger = this.getConfigurationElement().createExecutableExtension("class");
        if (!(debugger instanceof IPDebugger)) {
            throw new CoreException((IStatus)new Status(4, PTPDebugCorePlugin.getUniqueIdentifier(), -1, Messages.PDebugConfiguration_1, null));
        }
        return (IPDebugger)debugger;
    }

    @Override
    public String getID() {
        return this.getConfigurationElement().getAttribute("id");
    }

    @Override
    public String[] getModeList() {
        return this.getModes().toArray(new String[0]);
    }

    @Override
    public String getName() {
        String name = this.getConfigurationElement().getAttribute("name");
        return name != null ? name : "";
    }

    @Override
    public String getPlatform() {
        String platform = this.getConfigurationElement().getAttribute("platform");
        if (platform == null) {
            return "*";
        }
        return platform;
    }

    @Override
    public boolean supportsCPU(String cpu) {
        String nativeCPU = Platform.getOSArch();
        boolean ret = false;
        if (nativeCPU.startsWith(cpu)) {
            ret = this.getCPUs().contains("native");
        }
        return ret || this.getCPUs().contains(cpu) || this.getCPUs().contains("*");
    }

    @Override
    public boolean supportsMode(String mode) {
        return this.getModes().contains(mode);
    }

    private IConfigurationElement getConfigurationElement() {
        return this.fElement;
    }

    protected Set<String> getCPUs() {
        if (this.fCPUs == null) {
            String cpus = this.getConfigurationElement().getAttribute("cpu");
            if (cpus == null) {
                this.fCPUs = new HashSet(1);
                this.fCPUs.add("native");
            } else {
                String nativeCPU = Platform.getOSArch();
                StringTokenizer tokenizer = new StringTokenizer(cpus, ",");
                this.fCPUs = new HashSet(tokenizer.countTokens());
                while (tokenizer.hasMoreTokens()) {
                    String cpu = tokenizer.nextToken().trim();
                    this.fCPUs.add(cpu);
                    if (!nativeCPU.startsWith(cpu)) continue;
                    this.fCPUs.add("native");
                }
            }
        }
        return this.fCPUs;
    }

    protected Set<String> getModes() {
        if (this.fModes == null) {
            String modes = this.getConfigurationElement().getAttribute("modes");
            if (modes == null) {
                return new HashSet<String>(0);
            }
            StringTokenizer tokenizer = new StringTokenizer(modes, ",");
            this.fModes = new HashSet(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                this.fModes.add(tokenizer.nextToken().trim());
            }
        }
        return this.fModes;
    }
}

