/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.model.IPDebugElement;
import org.eclipse.ptp.debug.core.model.IPDebugElementStatus;
import org.eclipse.ptp.debug.core.model.IPDebugTarget;
import org.eclipse.ptp.debug.core.model.PDebugElementState;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.internal.debug.core.PDebugModel;
import org.eclipse.ptp.internal.debug.core.PDebugUtils;
import org.eclipse.ptp.internal.debug.core.messages.Messages;

public abstract class PDebugElement
extends PlatformObject
implements IPDebugElement,
IPDebugElementStatus {
    private int fSeverity = 0;
    private String fMessage = null;
    private PDebugElementState fState = PDebugElementState.UNDEFINED;
    private PDebugElementState fOldState = PDebugElementState.UNDEFINED;
    private Object fCurrentStateInfo = null;
    protected final IPSession fSession;
    protected final TaskSet tasks;

    public static void notSupported(String message) throws DebugException {
        PDebugElement.throwDebugException(message, 5011, null);
    }

    public static void requestFailed(String message, Exception e) throws DebugException {
        PDebugElement.requestFailed(message, e, 5012);
    }

    public static void requestFailed(String message, Throwable e, int code) throws DebugException {
        PDebugElement.throwDebugException(message, code, e);
    }

    public static void targetRequestFailed(String message, PDIException e) throws DebugException {
        PDebugElement.requestFailed(NLS.bind((String)Messages.PDebugElement_0, (Object[])new Object[]{message}), e, 5010);
    }

    public static void targetRequestFailed(String message, Throwable e) throws DebugException {
        PDebugElement.throwDebugException(NLS.bind((String)Messages.PDebugElement_0, (Object[])new Object[]{message}), 5010, e);
    }

    protected static void throwDebugException(String message, int code, Throwable exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, PDebugModel.getPluginIdentifier(), code, message, exception));
    }

    public PDebugElement(IPSession session, TaskSet tasks) {
        this.fSession = session;
        this.tasks = tasks;
    }

    public DebugEvent createChangeEvent(int detail) {
        return new DebugEvent((Object)this, 16, detail);
    }

    public DebugEvent createCreateEvent() {
        return new DebugEvent((Object)this, 4);
    }

    public DebugEvent createResumeEvent(int detail) {
        return new DebugEvent((Object)this, 1, detail);
    }

    public DebugEvent createSuspendEvent(int detail) {
        return new DebugEvent((Object)this, 2, detail);
    }

    public DebugEvent createTerminateEvent() {
        return new DebugEvent((Object)this, 8);
    }

    public void fireChangeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 16, detail));
    }

    public void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    public void fireResumeEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 1, detail));
    }

    public void fireSuspendEvent(int detail) {
        this.fireEvent(new DebugEvent((Object)this, 2, detail));
    }

    public void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IDebugElement.class)) {
            return this;
        }
        if (adapter.equals(IPDebugElement.class)) {
            return this;
        }
        if (adapter.equals(IPDebugElementStatus.class)) {
            return this;
        }
        if (adapter.equals(IPSession.class)) {
            return this.fSession;
        }
        if (adapter.equals(IPDebugTarget.class)) {
            return this.getDebugTarget();
        }
        if (adapter.equals(IDebugTarget.class)) {
            return this.getDebugTarget();
        }
        if (adapter.equals(ILaunch.class)) {
            return this.getLaunch();
        }
        return super.getAdapter(adapter);
    }

    public synchronized Object getCurrentStateInfo() {
        return this.fCurrentStateInfo;
    }

    public IDebugTarget getDebugTarget() {
        return this.fSession.getLaunch().getDebugTarget(this.getID());
    }

    public int getID() {
        return this.tasks.nextSetBit(0);
    }

    public ILaunch getLaunch() {
        return this.fSession.getLaunch();
    }

    public String getMessage() {
        return this.fMessage;
    }

    public String getModelIdentifier() {
        return PDebugModel.getPluginIdentifier();
    }

    public IPDISession getPDISession() {
        return this.fSession.getPDISession();
    }

    public IPDITarget getPDITarget() throws PDIException {
        IPDebugTarget debugTarget = this.fSession.findDebugTarget(this.getTasks());
        if (debugTarget == null) {
            throw new PDIException(this.getTasks(), Messages.PDebugElement_2);
        }
        return debugTarget.getPDITarget();
    }

    public IPSession getSession() {
        return this.fSession;
    }

    public synchronized int getSeverity() {
        return this.fSeverity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDebugElementState getState() {
        PDebugElementState pDebugElementState = this.fState;
        synchronized (pDebugElementState) {
            return this.fState;
        }
    }

    public TaskSet getTasks() {
        return this.tasks;
    }

    public synchronized boolean isOK() {
        return this.fSeverity == 0;
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
    }

    protected void fireEventSet(DebugEvent[] events) {
        DebugPlugin.getDefault().fireDebugEventSet(events);
    }

    protected void infoMessage(Throwable e) {
        Status newStatus = new Status(1, PDebugModel.getPluginIdentifier(), 10001, e.getMessage(), null);
        PDebugUtils.info((IStatus)newStatus, this.getDebugTarget());
    }

    protected void logError(Exception e) {
        DebugPlugin.log((Throwable)e);
    }

    protected void logError(String message) {
        DebugPlugin.logMessage((String)message, null);
    }

    protected synchronized void resetStatus() {
        this.fSeverity = 0;
        this.fMessage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreState() {
        PDebugElementState pDebugElementState = this.fState;
        synchronized (pDebugElementState) {
            this.fState = this.fOldState;
        }
    }

    protected synchronized void setCurrentStateInfo(Object currentStateInfo) {
        this.fCurrentStateInfo = currentStateInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(PDebugElementState state) throws IllegalArgumentException {
        PDebugElementState pDebugElementState = this.fState;
        synchronized (pDebugElementState) {
            this.fOldState = this.fState;
            this.fState = state;
        }
    }

    protected synchronized void setStatus(int severity, String message) {
        this.fSeverity = severity;
        this.fMessage = message;
        if (this.fMessage != null) {
            this.fMessage.trim();
        }
    }
}

