/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.pdi.IPDIAddressLocation;
import org.eclipse.ptp.debug.core.pdi.IPDIFileLocation;
import org.eclipse.ptp.debug.core.pdi.IPDIFunctionLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILineLocation;
import org.eclipse.ptp.debug.core.pdi.IPDILocation;

public class Location
implements IPDILocation {
    private BigInteger addr = null;
    private String file = null;
    private String function = null;
    private int line = 0;

    public Location(String file) {
        this(file, null, 0, null);
    }

    public Location(String file, String function) {
        this(file, function, 0, null);
    }

    public Location(String file, int line) {
        this(file, null, line, null);
    }

    public Location(BigInteger addr) {
        this(null, null, 0, addr);
    }

    public Location(String file, String function, int line, BigInteger addr) {
        this.file = file;
        this.function = function;
        this.line = line;
        this.addr = addr;
    }

    public BigInteger getAddress() {
        return this.addr;
    }

    public String getFile() {
        return this.file;
    }

    public String getFunction() {
        return this.function;
    }

    public int getLineNumber() {
        return this.line;
    }

    public boolean equals(IPDILocation location) {
        if (location == this) {
            return true;
        }
        if (location instanceof IPDILineLocation) {
            IPDILineLocation lineLocation = (IPDILineLocation)location;
            String oFile = lineLocation.getFile();
            if (oFile != null && oFile.length() > 0 && this.file != null && this.file.length() > 0 && oFile.equals(this.file) ? lineLocation.getLineNumber() == this.line : !(this.file != null && this.file.length() != 0 || oFile != null && oFile.length() != 0 || lineLocation.getLineNumber() != this.line)) {
                return true;
            }
        } else if (location instanceof IPDIFunctionLocation) {
            IPDIFunctionLocation funcLocation = (IPDIFunctionLocation)location;
            String oFile = funcLocation.getFile();
            String oFunction = funcLocation.getFunction();
            if (oFile != null && oFile.length() > 0 && this.file != null && this.file.length() > 0 && oFile.equals(this.file)) {
                if (oFunction != null && oFunction.length() > 0 && this.function != null && this.function.length() > 0 && oFunction.equals(this.function)) {
                    return true;
                }
                if (!(oFunction != null && oFunction.length() != 0 || this.function != null && this.function.length() != 0)) {
                    return true;
                }
            } else if (!(this.file != null && this.file.length() != 0 || oFile != null && oFile.length() != 0)) {
                if (oFunction != null && oFunction.length() > 0 && this.function != null && this.function.length() > 0 && oFunction.equals(this.function)) {
                    return true;
                }
                if (!(oFunction != null && oFunction.length() != 0 || this.function != null && this.function.length() != 0)) {
                    return true;
                }
            }
        } else if (location instanceof IPDIAddressLocation) {
            IPDIAddressLocation addrLocation = (IPDIAddressLocation)location;
            BigInteger oAddr = addrLocation.getAddress();
            if (oAddr != null && oAddr.equals(this.addr)) {
                return true;
            }
            if (oAddr == null && this.addr == null) {
                return true;
            }
        } else if (location instanceof IPDIFileLocation) {
            IPDIFileLocation fileLocation = (IPDIFileLocation)location;
            String oFile = fileLocation.getFile();
            if (oFile != null && oFile.length() > 0 && this.file != null && this.file.length() > 0 && oFile.equals(this.file)) {
                return true;
            }
            if (!(this.file != null && this.file.length() != 0 || oFile != null && oFile.length() != 0)) {
                return true;
            }
        }
        return false;
    }
}

