/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFType;
import org.eclipse.ptp.debug.core.pdi.model.aif.IAIFTypeAggregate;
import org.eclipse.ptp.internal.debug.core.pdi.aif.AIFType;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AIFTypeAggregate
extends AIFType
implements IAIFTypeAggregate {
    private final List<AIFField> fPrivateFields = new ArrayList<AIFField>();
    private final List<AIFField> fProtectedFields = new ArrayList<AIFField>();
    private final List<AIFField> fPackageFields = new ArrayList<AIFField>();
    private final List<AIFField> fPublicFields = new ArrayList<AIFField>();
    private String fName = "";
    private int fSize = 0;

    @Override
    public String[] getFieldNames(int access) {
        List<AIFField> fields = this.getFields(access);
        String[] names = new String[fields.size()];
        int i = 0;
        while (i < fields.size()) {
            names[i] = fields.get((int)i).name;
            ++i;
        }
        return names;
    }

    @Override
    public IAIFType[] getFieldTypes(int access) {
        List<AIFField> fields = this.getFields(access);
        IAIFType[] types = new IAIFType[fields.size()];
        int i = 0;
        while (i < fields.size()) {
            types[i] = fields.get((int)i).type;
            ++i;
        }
        return types;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int sizeof() {
        return this.fSize;
    }

    public String toString() {
        String content = String.valueOf('{');
        content = String.valueOf(content) + this.getName() + '|';
        content = String.valueOf(content) + this.getFieldsString(this.fPublicFields) + ';';
        content = String.valueOf(content) + this.getFieldsString(this.fProtectedFields) + ';';
        content = String.valueOf(content) + this.getFieldsString(this.fPrivateFields) + ';';
        content = String.valueOf(content) + this.getFieldsString(this.fPackageFields) + '}';
        return content;
    }

    private String getFieldsString(List<AIFField> fields) {
        String res = "";
        int i = 0;
        while (i < fields.size()) {
            if (i > 0) {
                res = String.valueOf(res) + ',';
            }
            AIFField field = fields.get(i);
            res = String.valueOf(res) + field.name + '=' + field.type.toString();
            ++i;
        }
        return res;
    }

    private List<AIFField> getFields(int access) {
        ArrayList<AIFField> fields = new ArrayList<AIFField>();
        if ((access & 1) == 1) {
            fields.addAll(this.fPublicFields);
        }
        if ((access & 2) == 2) {
            fields.addAll(this.fProtectedFields);
        }
        if ((access & 4) == 4) {
            fields.addAll(this.fPrivateFields);
        }
        if ((access & 8) == 8) {
            fields.addAll(this.fPackageFields);
        }
        return fields;
    }

    @Override
    public String parse(String fmt) throws AIFFormatException {
        fmt = this.parseName(fmt);
        fmt = this.parseFields(fmt, this.fPublicFields);
        fmt = this.parseFields(fmt, this.fProtectedFields);
        fmt = this.parseFields(fmt, this.fPrivateFields);
        if ((fmt = this.parseFields(fmt, this.fPackageFields)).charAt(0) != '}') {
            throw new AIFFormatException(Messages.AIFTypeAggregate_0);
        }
        return fmt.substring(1);
    }

    private String parseField(String fmt, List<AIFField> fields) throws AIFFormatException {
        AIFField field = new AIFField();
        int pos = fmt.indexOf(61);
        if (pos == -1) {
            throw new AIFFormatException(Messages.AIFTypeAggregate_1);
        }
        field.name = fmt.substring(0, pos);
        fmt = fmt.substring(pos + 1);
        fmt = AIFFactory.parseType(fmt);
        IAIFType aifType = AIFFactory.getType();
        this.fSize += aifType.sizeof();
        field.type = aifType;
        fields.add(field);
        return fmt;
    }

    private String parseFields(String fmt, List<AIFField> fields) throws AIFFormatException {
        while (fmt.length() > 0 && fmt.charAt(0) != ';' && fmt.charAt(0) != '}') {
            if ((fmt = this.parseField(fmt, fields)).charAt(0) != ',') continue;
            fmt = fmt.substring(1);
        }
        if (fmt.charAt(0) == ';') {
            return fmt.substring(1);
        }
        return fmt;
    }

    private String parseName(String fmt) throws AIFFormatException {
        int pos = fmt.indexOf(124);
        if (pos == -1) {
            throw new AIFFormatException(Messages.AIFTypeAggregate_2);
        }
        this.fName = fmt.substring(0, pos);
        return fmt.substring(pos + 1);
    }

    private class AIFField {
        public String name;
        public IAIFType type;

        private AIFField() {
        }
    }
}

