/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.manager;

import java.math.BigInteger;
import org.eclipse.ptp.debug.core.TaskSet;
import org.eclipse.ptp.debug.core.pdi.IPDISession;
import org.eclipse.ptp.debug.core.pdi.PDIException;
import org.eclipse.ptp.debug.core.pdi.manager.IPDISourceManager;
import org.eclipse.ptp.debug.core.pdi.model.IPDIInstruction;
import org.eclipse.ptp.debug.core.pdi.model.IPDIMixedInstruction;
import org.eclipse.ptp.debug.core.pdi.model.IPDIStackFrame;
import org.eclipse.ptp.debug.core.pdi.model.IPDITarget;
import org.eclipse.ptp.debug.core.pdi.model.IPDIThread;
import org.eclipse.ptp.internal.debug.core.pdi.manager.AbstractPDIManager;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;

public class SourceManager
extends AbstractPDIManager
implements IPDISourceManager {
    public SourceManager(IPDISession session) {
        super(session, false);
    }

    public String getDetailTypeName(IPDITarget target, String typename) throws PDIException {
        throw new PDIException(target.getTasks(), Messages.SourceManager_0);
    }

    public String getDetailTypeNameFromVariable(IPDIStackFrame frame, String variable) throws PDIException {
        IPDITarget target = frame.getTarget();
        IPDIThread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(frame.getThread(), false);
            frame.getThread().setCurrentStackFrame(frame, false);
            String string = this.getDetailTypeName(target, variable);
            return string;
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
        }
    }

    public IPDIInstruction[] getInstructions(TaskSet qTasks, BigInteger start, BigInteger end) throws PDIException {
        throw new PDIException(qTasks, Messages.SourceManager_1);
    }

    public IPDIInstruction[] getInstructions(TaskSet qTasks, String filename, int linenum) throws PDIException {
        return this.getInstructions(qTasks, filename, linenum, -1);
    }

    public IPDIInstruction[] getInstructions(TaskSet qTasks, String filename, int linenum, int lines) throws PDIException {
        throw new PDIException(qTasks, Messages.SourceManager_1);
    }

    public IPDIMixedInstruction[] getMixedInstructions(TaskSet qTasks, BigInteger start, BigInteger end) throws PDIException {
        throw new PDIException(qTasks, Messages.SourceManager_2);
    }

    public IPDIMixedInstruction[] getMixedInstructions(TaskSet qTasks, String filename, int linenum) throws PDIException {
        return this.getMixedInstructions(qTasks, filename, linenum, -1);
    }

    public IPDIMixedInstruction[] getMixedInstructions(TaskSet qTasks, String filename, int linenum, int lines) throws PDIException {
        throw new PDIException(qTasks, Messages.SourceManager_2);
    }

    public String[] getSourcePaths(TaskSet qTasks) throws PDIException {
        throw new PDIException(qTasks, Messages.SourceManager_3);
    }

    public String getTypeName(IPDITarget target, String variable) throws PDIException {
        throw new PDIException(target.getTasks(), Messages.SourceManager_4);
    }

    public String getTypeNameFromVariable(IPDIStackFrame frame, String variable) throws PDIException {
        IPDITarget target = frame.getTarget();
        IPDIThread currentThread = target.getCurrentThread();
        IPDIStackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            target.setCurrentThread(frame.getThread(), false);
            frame.getThread().setCurrentStackFrame(frame, false);
            String string = this.getTypeName(target, variable);
            return string;
        }
        finally {
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            target.releaseTarget();
        }
    }

    public void setSourcePaths(TaskSet qTasks, String[] dirs) throws PDIException {
        throw new PDIException(qTasks, Messages.SourceManager_5);
    }

    public void shutdown() {
    }

    public void update(TaskSet qTasks) throws PDIException {
    }
}

