/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ems.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.ems.core.EnvManagerRegistry;
import org.eclipse.ptp.ems.core.IEnvManager;
import org.eclipse.ptp.ems.ui.IErrorListener;
import org.eclipse.ptp.internal.ems.ui.AsyncRepopulationStrategy;
import org.eclipse.ptp.internal.ems.ui.EMSUIPlugin;
import org.eclipse.ptp.internal.ems.ui.NullErrorListener;
import org.eclipse.ptp.internal.ems.ui.SearchableSelectionList;
import org.eclipse.ptp.internal.ems.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.ui.RemoteUIServicesUtils;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class EnvManagerChecklist
extends Composite {
    private IRemoteConnection remoteConnection;
    private IEnvManager envManager = EnvManagerRegistry.getNullEnvManager();
    private IErrorListener errorListener;
    private URI lastSyncURI = null;
    private List<String> lastSelectedItems = Collections.emptyList();
    private Composite stack;
    private StackLayout stackLayout;
    private Composite messageComposite;
    private Label messageLabel;
    private Button connectButton;
    private SearchableSelectionList checklist;

    public EnvManagerChecklist(Composite parent, int style) {
        super(parent, style);
        this.errorListener = new NullErrorListener();
        GridLayout g = new GridLayout(1, false);
        g.marginHeight = 0;
        g.marginWidth = 0;
        this.setLayout((Layout)g);
        this.createStack(this);
        this.createMsgComposite();
        this.createChecklist();
        this.checklist.setEnabledAndVisible(this.isEnabled());
        this.stackLayout.topControl = this.messageComposite;
        this.stack.layout(true, true);
    }

    private void createStack(Composite composite) {
        this.stack = new Composite(composite, 0);
        this.stack.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.stack.setLayout((Layout)this.stackLayout);
    }

    private void createMsgComposite() {
        this.messageComposite = new Composite(this.stack, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.messageComposite.setLayout((Layout)layout);
        this.messageLabel = new Label(this.messageComposite, 64);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = 450;
        this.messageLabel.setLayoutData((Object)gridData);
        this.connectButton = new Button(this.messageComposite, 8);
        this.connectButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.connectButton.setText(Messages.EnvManagerChecklist_ConnectButtonLabel);
        this.connectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EnvManagerChecklist.this.connect()) {
                    EnvManagerChecklist.this.reset(null, EnvManagerChecklist.this.remoteConnection, EnvManagerChecklist.this.lastSelectedItems);
                }
            }
        });
        this.setNotConnectedMessage();
    }

    private void setNotConnectedMessage() {
        String connectionName = this.getConnectionName();
        if (connectionName != null) {
            this.messageLabel.setText(NLS.bind((String)Messages.EnvManagerChecklist_RemoteEnvironmentIsNotConnected, (Object)connectionName));
        } else {
            this.messageLabel.setText(Messages.EnvManagerChecklist_NotRemoteSync);
        }
        this.connectButton.setEnabled(connectionName != null);
        this.connectButton.setVisible(connectionName != null);
        this.messageComposite.pack();
        this.stackLayout.topControl = this.messageComposite;
        this.stack.layout(true, true);
    }

    public void setErrorListener(IErrorListener listener) {
        this.errorListener = listener == null ? new NullErrorListener() : listener;
    }

    public String getConnectionName() {
        return this.remoteConnection == null ? null : this.remoteConnection.getName();
    }

    private boolean connect() {
        if (this.remoteConnection == null) {
            return false;
        }
        if (!this.remoteConnection.isOpen()) {
            RemoteUIServicesUtils.openConnectionWithProgress((Shell)this.getShell(), null, (IRemoteConnection)this.remoteConnection);
        }
        return this.remoteConnection.isOpen();
    }

    public void setConnection(IRemoteConnection connection) {
        this.remoteConnection = connection;
    }

    private void createChecklist() {
        this.checklist = new SearchableSelectionList(this.stack);
        this.checklist.setLayoutData(new GridData(4, 4, true, true));
        this.checklist.setEnabledAndVisible(false);
        this.checklist.setColumnHeaders(Messages.EnvManagerChecklist_Available_Modules, Messages.EnvManagerChecklist_Selected_Modules);
        this.checklist.addDefaultButtonSelectonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final ArrayList<String> allModules = new ArrayList<String>(EnvManagerChecklist.this.checklist.getAllItems());
                EnvManagerChecklist.this.checklist.asyncRepopulate(new AsyncRepopulationStrategy(){

                    @Override
                    public String getMessage() {
                        return Messages.EnvManagerChecklist_PleaseWaitRetrievingModuleList;
                    }

                    @Override
                    public List<String> computeItems(IProgressMonitor monitor) {
                        return allModules;
                    }

                    @Override
                    public List<String> computeSelectedItems(IProgressMonitor monitor) throws Exception {
                        return EnvManagerChecklist.this.envManager.determineDefaultElements(monitor);
                    }

                    @Override
                    public void afterRepopulation() {
                        EnvManagerChecklist.this.checklist.setEnabledAndVisible(EnvManagerChecklist.this.isEnabled());
                    }
                });
            }
        });
        this.checklist.addReloadButtonSelectonListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvManagerChecklist.this.populateModuleList(EnvManagerChecklist.this.checklist.getSelectedItems());
            }
        });
    }

    public void reset(URI newURI, IRemoteConnection remoteConnection, List<String> selectedItems) {
        boolean selectedItemsHaveChanged;
        this.remoteConnection = remoteConnection;
        boolean syncURIHasChanged = newURI == null || !newURI.equals(this.lastSyncURI);
        boolean bl = selectedItemsHaveChanged = selectedItems == null || !selectedItems.equals(this.lastSelectedItems);
        if (newURI != null) {
            this.lastSyncURI = newURI;
        }
        if (selectedItems != null) {
            this.lastSelectedItems = selectedItems;
        }
        if (this.messageComposite != null && this.checklist != null && (syncURIHasChanged || selectedItemsHaveChanged)) {
            if (this.connectionIsOpen()) {
                this.inBackgroundThreadDetectEnvManager(remoteConnection, selectedItems);
            } else {
                this.setNotConnectedMessage();
            }
        }
    }

    private void inBackgroundThreadDetectEnvManager(final IRemoteConnection remoteConnection, final List<String> selectedItems) {
        this.setDetectingMessage();
        Job job = new Job(Messages.EnvManagerChecklist_DetectingRemoteEMS){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    EnvManagerChecklist.this.envManager = EnvManagerRegistry.getEnvManager((IProgressMonitor)monitor, (IRemoteConnection)remoteConnection);
                    String description = EnvManagerChecklist.this.envManager.getDescription(monitor);
                    EnvManagerChecklist.this.inUIThreadDisplayChecklist(selectedItems, description);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    EMSUIPlugin.log(e);
                    return new Status(4, "org.eclipse.ptp.ems.ui", e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    private void setDetectingMessage() {
        this.messageLabel.setText(NLS.bind((String)Messages.EnvManagerChecklist_DetectingEMSPleaseWait, (Object)this.getConnectionName()));
        this.connectButton.setEnabled(false);
        this.connectButton.setVisible(false);
        this.messageComposite.pack();
        this.stackLayout.topControl = this.messageComposite;
        this.stack.layout(true, true);
    }

    private void inUIThreadDisplayChecklist(final List<String> selectedItems, final String description) {
        Job job = new Job(Messages.EnvManagerChecklist_UpdatingChecklist){

            protected IStatus run(IProgressMonitor monitor) {
                if (!EnvManagerChecklist.this.isDisposed()) {
                    EnvManagerChecklist.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String instructions = EnvManagerChecklist.this.envManager.getInstructions();
                            if (instructions.length() > 0) {
                                instructions = String.valueOf(instructions) + Messages.EnvManagerChecklist_SettingsOnEnvironmentsPageAreAppliedBeforehand;
                            }
                            EnvManagerChecklist.this.checklist.setInstructions(instructions, 250);
                            EnvManagerChecklist.this.checklist.setComparator(EnvManagerChecklist.this.envManager.getComparator());
                            if (EnvManagerChecklist.this.envManager.equals(EnvManagerRegistry.getNullEnvManager())) {
                                EnvManagerChecklist.this.setIncompatibleInstallationMessage();
                            } else {
                                EnvManagerChecklist.this.checklist.setTitle(NLS.bind((String)Messages.EnvManagerChecklist_EnvManagerInfo, (Object)description, (Object)EnvManagerChecklist.this.getConnectionName()));
                                EnvManagerChecklist.this.checklist.setEnabledAndVisible(false);
                                ((EnvManagerChecklist)(this).EnvManagerChecklist.this).stackLayout.topControl = EnvManagerChecklist.this.checklist;
                                EnvManagerChecklist.this.stack.layout(true, true);
                                EnvManagerChecklist.this.errorListener.errorCleared();
                                EnvManagerChecklist.this.populateModuleList(selectedItems);
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    private boolean connectionIsOpen() {
        if (this.remoteConnection == null) {
            return false;
        }
        return this.remoteConnection.isOpen();
    }

    private void setIncompatibleInstallationMessage() {
        this.messageLabel.setText(NLS.bind((String)Messages.EnvManagerChecklist_NoSupportedEMSInstalled, (Object)this.getConnectionName()));
        this.connectButton.setEnabled(false);
        this.connectButton.setVisible(false);
        this.messageComposite.pack();
        this.stackLayout.topControl = this.messageComposite;
        this.stack.layout(true, true);
    }

    private void populateModuleList(final List<String> selectedItems) {
        this.checklist.asyncRepopulate(new AsyncRepopulationStrategy(){

            @Override
            public String getMessage() {
                return Messages.EnvManagerChecklist_PleaseWaitRetrievingModuleList;
            }

            @Override
            public List<String> computeItems(IProgressMonitor monitor) throws Exception {
                return EnvManagerChecklist.this.envManager.determineAvailableElements(monitor);
            }

            @Override
            public List<String> computeSelectedItems(IProgressMonitor monitor) throws Exception {
                if (selectedItems != null) {
                    return selectedItems;
                }
                return EnvManagerChecklist.this.envManager.determineDefaultElements((IProgressMonitor)new NullProgressMonitor());
            }

            @Override
            public void afterRepopulation() {
                EnvManagerChecklist.this.checklist.setEnabledAndVisible(EnvManagerChecklist.this.isEnabled());
            }
        });
    }

    public List<String> getSelectedElements() {
        return this.checklist.getSelectedItems();
    }

    public boolean isChecklistEnabled() {
        return this.checklist.isEnabled();
    }

    public IEnvManager getEnvManager() {
        return this.envManager;
    }
}

