/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ems.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.ptp.ems.core.EnvManagerConfigString;
import org.eclipse.ptp.ems.core.IEnvManagerConfig;
import org.eclipse.ptp.ems.ui.EnvManagerConfigWidget;
import org.eclipse.ptp.ems.ui.IErrorListener;
import org.eclipse.ptp.internal.ems.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.rm.jaxb.control.ui.AbstractWidget;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class EnvManagerConfigButton
extends AbstractWidget {
    private static IDialogSettings dialogSettings = new DialogSettings("EnvConfigurationDialog");
    private final IRemoteConnection remoteConnection;
    private EnvManagerConfigString configString;
    private Button button = null;
    private final List<ModifyListener> modifyListeners = new LinkedList<ModifyListener>();

    public EnvManagerConfigButton(Composite parent, IWidgetDescriptor wd) {
        super(parent, wd);
        String label = wd.getTitle();
        String tooltip = wd.getToolTipText();
        if (label != null) {
            Label buttonLabel = new Label(parent, 131072);
            buttonLabel.setText(label);
            GridData data = new GridData(-1, -1, false, false, 1, 1);
            buttonLabel.setLayoutData((Object)data);
            if (tooltip != null) {
                buttonLabel.setToolTipText(tooltip);
            }
        }
        this.remoteConnection = wd.getRemoteConnection();
        this.configString = new EnvManagerConfigString();
        this.setLayout((Layout)new FillLayout());
        this.button = new Button((Composite)this, 8);
        this.button.setText(Messages.EnvManagerConfigButton_ConfigureButtonText);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnvConfigurationDialog dialog = new EnvConfigurationDialog(EnvManagerConfigButton.this.getShell());
                if (dialog.open() == 0) {
                    EnvManagerConfigButton.this.notifyListeners();
                }
            }
        });
        if (label != null) {
            this.setText(label);
        }
        this.setConfiguration("");
    }

    private void notifyListeners() {
        for (ModifyListener listener : this.modifyListeners) {
            listener.modifyText(null);
        }
    }

    public void setText(String text) {
        this.button.setText(text);
        this.layout(true, true);
    }

    public void addModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.modifyListeners.remove(listener);
    }

    public void setConfiguration(String configuration) {
        this.configString = new EnvManagerConfigString(configuration);
    }

    public String getConfiguration() {
        return this.configString.toString();
    }

    public void setToolTipText(String string) {
        if (this.button != null) {
            this.button.setToolTipText(string);
        }
    }

    private class EnvConfigurationDialog
    extends Dialog {
        private EnvManagerConfigWidget envConfig;

        public EnvConfigurationDialog(Shell shell) {
            super(shell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.EnvManagerConfigButton_EnvConfigurationDialogTitle);
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return dialogSettings;
        }

        protected Point getInitialSize() {
            return new Point(750, 500);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Control createDialogArea(Composite parent) {
            final Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout());
            this.envConfig = new EnvManagerConfigWidget(composite, 0);
            this.envConfig.setLayoutData(new GridData(1808));
            final Label errorMessage = new Label(parent, 19456);
            errorMessage.setLayoutData((Object)new GridData(768));
            errorMessage.setText("");
            errorMessage.setForeground(JFaceColors.getErrorText((Display)EnvManagerConfigButton.this.getDisplay()));
            errorMessage.setBackground(JFaceColors.getErrorBackground((Display)EnvManagerConfigButton.this.getDisplay()));
            this.envConfig.setErrorListener(new IErrorListener(){

                @Override
                public void errorRaised(String message) {
                    errorMessage.setText(message);
                    composite.layout(true, true);
                }

                @Override
                public void errorCleared() {
                    errorMessage.setText("");
                    composite.layout(true, true);
                }
            });
            this.envConfig.setUseEMSCheckbox(EnvManagerConfigButton.this.configString.isEnvMgmtEnabled());
            this.envConfig.setManualConfigCheckbox(EnvManagerConfigButton.this.configString.isManualConfigEnabled());
            this.envConfig.setManualConfigText(EnvManagerConfigButton.this.configString.getManualConfigText());
            this.envConfig.configurationChanged(null, EnvManagerConfigButton.this.remoteConnection, EnvManagerConfigButton.this.configString.getConfigElements());
            return composite;
        }

        protected void okPressed() {
            this.envConfig.saveConfiguration((IEnvManagerConfig)EnvManagerConfigButton.this.configString);
            super.okPressed();
        }
    }
}

