/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui.extensions;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.utils.LaunchTabBuilder;
import org.eclipse.ptp.internal.rm.jaxb.control.ui.variables.LCVariableMap;
import org.eclipse.ptp.internal.rm.jaxb.ui.JAXBUIPlugin;
import org.eclipse.ptp.launch.ui.extensions.AbstractJAXBLaunchConfigurationTab;
import org.eclipse.ptp.launch.ui.extensions.AbstractRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationContentsChangedListener;
import org.eclipse.ptp.launch.ui.extensions.IRMLaunchConfigurationDynamicTab;
import org.eclipse.ptp.launch.ui.extensions.RMLaunchValidation;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensibleJAXBControllerTab
extends AbstractRMLaunchConfigurationDynamicTab
implements IRMLaunchConfigurationContentsChangedListener {
    protected boolean voidRMConfig = false;
    protected boolean initialized = false;
    protected TabFolder tabFolder;
    protected int lastIndex = 0;
    protected String controlId;
    private final LinkedList<AbstractJAXBLaunchConfigurationTab> tabControllers = new LinkedList();
    private final Map<String, AbstractJAXBLaunchConfigurationTab> controllerIndex = new HashMap<String, AbstractJAXBLaunchConfigurationTab>();
    protected Composite control;

    protected ExtensibleJAXBControllerTab() {
    }

    @Override
    public RMLaunchValidation canSave(Control control) {
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.canSave(control);
            if (validation.isSuccess()) continue;
            return validation;
        }
        return new RMLaunchValidation(true, null);
    }

    @Override
    public void createControl(Composite parent, String id) throws CoreException {
        this.control = new Composite(parent, 0);
        if (!this.voidRMConfig) {
            GridLayout layout = new GridLayout();
            this.control.setLayout((Layout)layout);
            this.tabFolder = new TabFolder(this.control, 0);
            this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            LaunchTabBuilder.initialize();
            for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
                TabItem simpleTabItem = new TabItem(this.tabFolder, 0);
                tabControl.createControl((Composite)this.tabFolder, id);
                simpleTabItem.setText(tabControl.getText());
                simpleTabItem.setImage(tabControl.getImage());
                simpleTabItem.setControl(tabControl.getControl());
            }
        }
        this.control.layout(true, true);
        this.controlId = id;
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    public int getSelectedController() {
        return this.tabFolder.getSelectionIndex();
    }

    @Override
    public void handleContentsChanged(IRMLaunchConfigurationDynamicTab factory) {
        this.fireContentsChanged();
    }

    @Override
    public RMLaunchValidation initializeFrom(ILaunchConfiguration configuration) {
        String lastTab = null;
        String key = null;
        try {
            key = String.valueOf(this.controlId) + "." + "initialized";
            this.initialized = configuration.getAttribute(key, false);
            key = String.valueOf(this.controlId) + "." + "current_controller";
            lastTab = configuration.getAttribute(key, "");
        }
        catch (CoreException t1) {
            JAXBUIPlugin.log((Throwable)t1);
        }
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        int i = 0;
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation;
            if (tabControl.getControllerTag().equals(lastTab)) {
                this.lastIndex = i;
            }
            if (!(validation = tabControl.initializeFrom(configuration)).isSuccess()) {
                resultValidation = validation;
            }
            ++i;
        }
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            try {
                tabControl.setUpSharedEnvironment(this.controllerIndex);
            }
            catch (CoreException t) {
                return new RMLaunchValidation(false, t.getLocalizedMessage());
            }
        }
        if (!this.initialized) {
            for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
                try {
                    tabControl.refreshLocal(configuration.getWorkingCopy());
                }
                catch (CoreException t) {
                    return new RMLaunchValidation(false, t.getLocalizedMessage());
                }
            }
            try {
                ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                wc.setAttribute(String.valueOf(this.controlId) + "." + "initialized", true);
                wc.doSave();
            }
            catch (CoreException t) {
                JAXBUIPlugin.log((Throwable)t);
            }
        }
        return resultValidation;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public RMLaunchValidation isValid(ILaunchConfiguration launchConfig) {
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.isValid(launchConfig);
            if (validation.isSuccess()) continue;
            return validation;
        }
        return new RMLaunchValidation(true, null);
    }

    @Override
    public RMLaunchValidation performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            LCVariableMap.normalizeStandardProperties((String)(String.valueOf(this.controlId) + "."), (ILaunchConfigurationWorkingCopy)configuration);
        }
        catch (CoreException ce) {
            return new RMLaunchValidation(false, ce.getLocalizedMessage());
        }
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.performApply(configuration);
            if (validation.isSuccess()) continue;
            resultValidation = validation;
        }
        return resultValidation;
    }

    @Override
    public RMLaunchValidation setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        RMLaunchValidation resultValidation = new RMLaunchValidation(true, null);
        for (AbstractJAXBLaunchConfigurationTab tabControl : this.tabControllers) {
            RMLaunchValidation validation = tabControl.setDefaults(configuration);
            if (validation.isSuccess()) continue;
            resultValidation = validation;
        }
        return resultValidation;
    }

    protected void addDynamicTab(AbstractJAXBLaunchConfigurationTab tabController) {
        this.tabControllers.add(tabController);
        this.controllerIndex.put(tabController.getText(), tabController);
        tabController.addContentsChangedListener(this);
    }

    protected List<AbstractJAXBLaunchConfigurationTab> getControllers() {
        return this.tabControllers;
    }
}

