/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.make.core.scannerconfig.offline;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ptp.internal.rdt.core.miners.StandaloneLogService;

public class OfflineTraceUtil {
    public static final String EOL = System.getProperty("line.separator");
    public static boolean SCANNER_CONFIG = false;

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public static boolean isTracing() {
        return SCANNER_CONFIG;
    }

    public static void outputTrace(String prefix, String[] tokens, String postfix) {
        if (OfflineTraceUtil.isTracing()) {
            System.out.print(String.valueOf(prefix) + ' ');
            int i = 0;
            while (i < tokens.length) {
                System.out.print(String.valueOf(tokens[i]) + ' ');
                ++i;
            }
            System.out.println(postfix);
        }
    }

    public static void outputTrace(String prefix, String msg, String postfix) {
        if (OfflineTraceUtil.isTracing()) {
            System.out.println(String.valueOf(prefix) + ' ' + msg + ' ' + postfix);
        }
    }

    public static void outputTrace(String title, String subtitle1, List<String> item1, List<String> item1new, String subtitle2, List<String> item2) {
        if (OfflineTraceUtil.isTracing()) {
            System.out.println(title);
            System.out.println("  " + subtitle1 + " (" + item1.size() + "):");
            int count = 0;
            Iterator<String> i = item1.iterator();
            Iterator<String> j = item1new.iterator();
            while (i.hasNext()) {
                System.out.println("    " + String.valueOf(++count) + "\t'" + i.next() + (j.hasNext() ? "' -> '" + j.next() : "") + '\'');
            }
            System.out.println("  " + subtitle2 + " (" + item2.size() + "):");
            count = 0;
            i = item2.iterator();
            while (i.hasNext()) {
                System.out.println("    " + String.valueOf(++count) + "\t'" + i.next() + '\'');
            }
        }
    }

    public static void outputError(String string, String line) {
        if (OfflineTraceUtil.isTracing()) {
            System.out.println();
            System.out.println("Error: " + string + line);
        }
    }

    public static void outputError(String string, String[] tokens) {
        if (OfflineTraceUtil.isTracing()) {
            System.out.println();
            System.out.print("Error: " + string);
            int i = 0;
            while (i < tokens.length) {
                System.out.print(String.valueOf(tokens[i]) + ' ');
                ++i;
            }
            System.out.println();
        }
    }

    public static void metricsTrace(String title, String subtitlePrefix, String subtitlePostfix, Map<String, List<Map<String, List<String>>>> directoryCommandListMap) {
        StandaloneLogService.getInstance().traceLog(" *** NEW METRICS TRACE ***");
        Set<String> dirs = directoryCommandListMap.keySet();
        for (String dir : dirs) {
            StandaloneLogService.getInstance().traceLog(String.valueOf(title) + dir + ":");
            List<Map<String, List<String>>> directoryCommandList = directoryCommandListMap.get(dir);
            if (directoryCommandList == null) {
                StandaloneLogService.getInstance().traceLog("  --- empty ---" + EOL);
                return;
            }
            for (Map<String, List<String>> command21FileListMap : directoryCommandList) {
                String[] commands = command21FileListMap.keySet().toArray(new String[1]);
                StandaloneLogService.getInstance().traceLog("  " + subtitlePrefix + commands[0] + subtitlePostfix);
                List<String> fileList = command21FileListMap.get(commands[0]);
                for (String fileName : fileList) {
                    StandaloneLogService.getInstance().traceLog("    " + fileName);
                }
            }
        }
    }

    public static void summaryTrace(String title, int workingDirsN, int commandsN, int filesN) {
        StandaloneLogService.getInstance().traceLog(" *** METRICS SUMMARY ***");
        StandaloneLogService.getInstance().traceLog(title);
        StandaloneLogService.getInstance().traceLog("  Number of directories visited: " + Integer.toString(workingDirsN));
        StandaloneLogService.getInstance().traceLog("  Number of generic commands:    " + Integer.toString(commandsN));
        StandaloneLogService.getInstance().traceLog("  Number of compiled files:      " + Integer.toString(filesN));
    }

    public static void metricsTrace(String trace) {
        StandaloneLogService.getInstance().traceLog(" *** NEW METRICS TRACE 2 ***");
        StandaloneLogService.getInstance().traceLog(trace);
    }
}

