/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ptp.internal.rdt.sync.core.RDTSyncCorePlugin;
import org.eclipse.ptp.internal.rdt.sync.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.exceptions.MissingConnectionException;
import org.eclipse.ptp.rdt.sync.core.listeners.ISyncConfigListener;
import org.eclipse.ptp.rdt.sync.core.services.ISynchronizeService;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.osgi.service.prefs.BackingStoreException;

public class SyncConfigManager {
    private static final String SYNC_CONFIG_KEY = "project-sync-config";
    private static final String CONFIGS_ELEMENT = "sync-configs";
    private static final String CONFIG_ELEMENT = "sync-config";
    private static final String CONFIG_NAME_ELEMENT = "config-name";
    private static final String SYNC_PROVIDER_ID_ELEMENT = "sync-provider-id";
    private static final String CONNECTION_NAME_ELEMENT = "connection-name";
    private static final String LOCATION_ELEMENT = "location";
    private static final String REMOTE_SERVICES_ID_ELEMENT = "remote-services-id";
    private static final String ACTIVE_ELEMENT = "active";
    private static final String SYNC_ON_PREBUILD_ELEMENT = "sync-on-prebuild";
    private static final String SYNC_ON_POSTBUILD_ELEMENT = "sync-on-postbuild";
    private static final String SYNC_ON_SAVE_ELEMENT = "sync-on-save";
    private static final String CONFIG_PROPERTIES_ELEMENT = "config-properties";
    private static final String LOCAL_SYNC_CONFIG_NAME = "Local";
    private static final String PROJECT_LOCAL_PATH = "${project_loc}";
    private static final Map<String, ListenerList> fSyncConfigListenerMap = Collections.synchronizedMap(new HashMap());
    private static final Map<IProject, SyncConfig> fActiveSyncConfigMap = Collections.synchronizedMap(new HashMap());
    private static final Map<IProject, Map<String, SyncConfig>> fSyncConfigMap = Collections.synchronizedMap(new HashMap());

    public static void addConfig(IProject project, SyncConfig config) {
        try {
            SyncConfigManager.loadConfigs(project);
            SyncConfigManager.doAddConfig(project, config);
            SyncConfigManager.saveConfigs(project);
            SyncConfigManager.fireSyncConfigAdded(project, config);
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(e);
        }
    }

    public static void addSyncConfigListener(String natureId, ISyncConfigListener listener) {
        ListenerList list = fSyncConfigListenerMap.get(natureId);
        if (list == null) {
            list = new ListenerList();
            fSyncConfigListenerMap.put(natureId, list);
        }
        list.add((Object)listener);
    }

    private static void doAddConfig(IProject project, SyncConfig config) {
        Map<String, SyncConfig> projConfigs = fSyncConfigMap.get(project);
        if (projConfigs == null) {
            projConfigs = new HashMap<String, SyncConfig>();
            fSyncConfigMap.put(project, projConfigs);
        }
        projConfigs.put(config.getName(), config);
        config.setProject(project);
    }

    private static boolean doRemoveConfig(IProject project, SyncConfig config) {
        Map<String, SyncConfig> projConfigs = fSyncConfigMap.get(project);
        if (projConfigs != null && projConfigs.size() > 1) {
            return projConfigs.remove(config.getName()) != null;
        }
        return false;
    }

    private static void fireSyncConfigAdded(IProject project, SyncConfig config) {
        Object[] objectArray = SyncConfigManager.getListenersFor(project).getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ISyncConfigListener listener = (ISyncConfigListener)obj;
            listener.configAdded(project, config);
            ++n2;
        }
    }

    private static void fireSyncConfigRemoved(IProject project, SyncConfig config) {
        Object[] objectArray = SyncConfigManager.getListenersFor(project).getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ISyncConfigListener listener = (ISyncConfigListener)obj;
            listener.configRemoved(project, config);
            ++n2;
        }
    }

    private static void fireSyncConfigSelected(IProject project, SyncConfig newConfig, SyncConfig oldConfig) {
        Object[] objectArray = SyncConfigManager.getListenersFor(project).getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ISyncConfigListener listener = (ISyncConfigListener)obj;
            listener.configSelected(project, newConfig, oldConfig);
            ++n2;
        }
    }

    public static SyncConfig getActive(IProject project) {
        try {
            if (project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
                try {
                    SyncConfigManager.loadConfigs(project);
                    return fActiveSyncConfigMap.get(project);
                }
                catch (CoreException e) {
                    RDTSyncCorePlugin.log(e);
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static URI getActiveSyncLocationURI(IResource resource) throws CoreException {
        SyncConfig config = SyncConfigManager.getActive(resource.getProject());
        if (config != null) {
            return SyncConfigManager.getSyncLocationURI(config, (IResource)resource.getProject());
        }
        return null;
    }

    public static SyncConfig getConfig(IProject project, String name) {
        try {
            SyncConfigManager.loadConfigs(project);
            Map<String, SyncConfig> map = fSyncConfigMap.get(project);
            if (map != null) {
                return map.get(name);
            }
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(e);
        }
        return null;
    }

    public static SyncConfig[] getConfigs(IProject project) {
        try {
            SyncConfigManager.loadConfigs(project);
            Map<String, SyncConfig> configs = fSyncConfigMap.get(project);
            if (configs != null) {
                return configs.values().toArray(new SyncConfig[0]);
            }
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(e);
        }
        return new SyncConfig[0];
    }

    private static ListenerList getListenersFor(IProject project) {
        ListenerList listeners = new ListenerList();
        for (String nature : fSyncConfigListenerMap.keySet()) {
            try {
                if (!project.hasNature(nature)) continue;
                Object[] objectArray = fSyncConfigListenerMap.get(nature).getListeners();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object listener = objectArray[n2];
                    listeners.add(listener);
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        return listeners;
    }

    public static SyncConfig getLocalConfig(ISynchronizeService syncService) throws CoreException {
        IRemoteServices localService = RemoteServices.getLocalServices();
        if (localService == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.core", Messages.SyncConfigManager_0));
        }
        IRemoteConnection localConnection = localService.getConnectionManager().getConnection(LOCAL_SYNC_CONFIG_NAME);
        if (localConnection == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.core", Messages.SyncConfigManager_1));
        }
        return SyncConfigManager.newConfig(LOCAL_SYNC_CONFIG_NAME, syncService.getId(), localConnection, PROJECT_LOCAL_PATH);
    }

    public static URI getSyncLocationURI(SyncConfig config, IResource resource) throws CoreException {
        if (config != null) {
            IRemoteConnection conn;
            IPath path = new Path(config.getLocation()).append(resource.getProjectRelativePath());
            try {
                conn = config.getRemoteConnection();
            }
            catch (MissingConnectionException missingConnectionException) {
                return null;
            }
            IRemoteFileManager fileMgr = conn.getRemoteServices().getFileManager(conn);
            return fileMgr.toURI(path);
        }
        return null;
    }

    public static boolean isActive(IProject project, SyncConfig config) {
        SyncConfig active = fActiveSyncConfigMap.get(project);
        return active != null && config != null && active.equals(config);
    }

    public static boolean isLocal(SyncConfig config) {
        return LOCAL_SYNC_CONFIG_NAME.equals(config.getName());
    }

    public static boolean isRemote(SyncConfig config) {
        return !SyncConfigManager.isLocal(config);
    }

    private static void loadConfigs(IProject project) throws CoreException {
        ProjectScope context;
        IEclipsePreferences node;
        String prefs;
        if (!fSyncConfigMap.containsKey(project) && (prefs = (node = (context = new ProjectScope(project)).getNode("org.eclipse.ptp.rdt.sync.core")).get(SYNC_CONFIG_KEY, null)) != null) {
            Map<String, SyncConfig> configMap;
            SyncConfig config;
            StringReader reader = new StringReader(prefs);
            XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)reader);
            IMemento[] iMementoArray = rootMemento.getChildren(CONFIG_ELEMENT);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento configPropertiesMemento;
                IMemento configMemento = iMementoArray[n2];
                String configName = configMemento.getString(CONFIG_NAME_ELEMENT);
                String location = configMemento.getString(LOCATION_ELEMENT);
                String connectionName = configMemento.getString(CONNECTION_NAME_ELEMENT);
                String remoteServicesId = configMemento.getString(REMOTE_SERVICES_ID_ELEMENT);
                String syncProviderId = configMemento.getString(SYNC_PROVIDER_ID_ELEMENT);
                Boolean syncOnPreBuild = configMemento.getBoolean(SYNC_ON_PREBUILD_ELEMENT);
                Boolean syncOnPostBuild = configMemento.getBoolean(SYNC_ON_POSTBUILD_ELEMENT);
                Boolean syncOnSave = configMemento.getBoolean(SYNC_ON_SAVE_ELEMENT);
                SyncConfig config2 = SyncConfigManager.newConfig(configName, syncProviderId, remoteServicesId, connectionName, location);
                if (syncOnPreBuild != null) {
                    config2.setSyncOnPreBuild(syncOnPreBuild);
                }
                if (syncOnPostBuild != null) {
                    config2.setSyncOnPostBuild(syncOnPostBuild);
                }
                if (syncOnSave != null) {
                    config2.setSyncOnSave(syncOnSave);
                }
                if ((configPropertiesMemento = configMemento.getChild(CONFIG_PROPERTIES_ELEMENT)) != null) {
                    String[] stringArray = configPropertiesMemento.getAttributeKeys();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String key = stringArray[n4];
                        String value = configPropertiesMemento.getString(key);
                        config2.setProperty(key, value);
                        ++n4;
                    }
                }
                SyncConfigManager.doAddConfig(project, config2);
                ++n2;
            }
            String activeName = rootMemento.getString(ACTIVE_ELEMENT);
            if (activeName != null && (config = (configMap = fSyncConfigMap.get(project)).get(activeName)) != null) {
                fActiveSyncConfigMap.put(project, config);
            }
        }
    }

    public static SyncConfig newConfig(String name, String providerId, IRemoteConnection conn, String location) {
        SyncConfig config = new SyncConfig(name);
        config.setSyncProviderId(providerId);
        config.setConnection(conn);
        config.setLocation(location);
        return config;
    }

    public static SyncConfig newConfig(String name, String providerId, String remoteServicesId, String connName, String location) {
        SyncConfig config = new SyncConfig(name);
        config.setSyncProviderId(providerId);
        config.setRemoteServicesId(remoteServicesId);
        config.setConnectionName(connName);
        config.setLocation(location);
        return config;
    }

    public static void removeConfig(IProject project, SyncConfig config) {
        try {
            SyncConfigManager.loadConfigs(project);
            boolean removed = SyncConfigManager.doRemoveConfig(project, config);
            if (removed) {
                SyncConfigManager.saveConfigs(project);
                SyncConfigManager.fireSyncConfigRemoved(project, config);
            }
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(e);
        }
    }

    public static void removeSyncConfigListener(String natureId, ISyncConfigListener listener) {
        ListenerList list = fSyncConfigListenerMap.get(natureId);
        if (list != null) {
            list.remove((Object)listener);
        }
    }

    public static void saveConfigs(IProject project) throws CoreException {
        Map<String, SyncConfig> projConfigs = fSyncConfigMap.get(project);
        if (projConfigs != null) {
            XMLMemento rootMemento = XMLMemento.createWriteRoot((String)CONFIGS_ELEMENT);
            for (SyncConfig config : projConfigs.values()) {
                IMemento configMemento = rootMemento.createChild(CONFIG_ELEMENT);
                configMemento.putString(CONFIG_NAME_ELEMENT, config.getName());
                configMemento.putString(LOCATION_ELEMENT, config.getLocation());
                configMemento.putString(CONNECTION_NAME_ELEMENT, config.getConnectionName());
                configMemento.putString(REMOTE_SERVICES_ID_ELEMENT, config.getRemoteServicesId());
                configMemento.putString(SYNC_PROVIDER_ID_ELEMENT, config.getSyncProviderId());
                configMemento.putBoolean(SYNC_ON_PREBUILD_ELEMENT, config.isSyncOnPreBuild());
                configMemento.putBoolean(SYNC_ON_POSTBUILD_ELEMENT, config.isSyncOnPostBuild());
                configMemento.putBoolean(SYNC_ON_SAVE_ELEMENT, config.isSyncOnSave());
                IMemento configPropertiesMemento = configMemento.createChild(CONFIG_PROPERTIES_ELEMENT);
                String[] stringArray = config.getKeys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    configPropertiesMemento.putString(key, config.getProperty(key));
                    ++n2;
                }
            }
            SyncConfig active = fActiveSyncConfigMap.get(project);
            if (active != null) {
                rootMemento.putString(ACTIVE_ELEMENT, active.getName());
            }
            StringWriter writer = new StringWriter();
            try {
                rootMemento.save((Writer)writer);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ptp.rdt.sync.core", Messages.SyncConfigManager_Unable_to_save, (Throwable)e));
            }
            ProjectScope context = new ProjectScope(project);
            IEclipsePreferences node = context.getNode("org.eclipse.ptp.rdt.sync.core");
            node.put(SYNC_CONFIG_KEY, writer.toString());
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                RDTSyncCorePlugin.log(e);
            }
        }
    }

    public static void setActive(IProject project, SyncConfig config) {
        try {
            SyncConfigManager.loadConfigs(project);
            SyncConfig oldConfig = fActiveSyncConfigMap.get(project);
            fActiveSyncConfigMap.put(project, config);
            SyncConfigManager.saveConfigs(project);
            SyncConfigManager.fireSyncConfigSelected(project, config, oldConfig);
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(e);
        }
    }

    public static void updateConfigs(IProject project, SyncConfig[] addedConfigs, SyncConfig[] removedConfigs) {
        SyncConfig config;
        SyncConfig[] syncConfigArray = addedConfigs;
        int n = addedConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            config = syncConfigArray[n2];
            SyncConfigManager.doAddConfig(project, config);
            ++n2;
        }
        syncConfigArray = removedConfigs;
        n = removedConfigs.length;
        n2 = 0;
        while (n2 < n) {
            config = syncConfigArray[n2];
            SyncConfigManager.doRemoveConfig(project, config);
            ++n2;
        }
        try {
            SyncConfigManager.saveConfigs(project);
        }
        catch (CoreException e) {
            RDTSyncCorePlugin.log(e);
        }
    }

    private SyncConfigManager() {
    }
}

