/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.git.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.ignore.IgnoreRule;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.IndexDiffFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.ptp.internal.rdt.sync.git.core.Activator;
import org.eclipse.ptp.internal.rdt.sync.git.core.GitRemoteSyncConnection;
import org.eclipse.ptp.internal.rdt.sync.git.core.RmCommandCached;
import org.eclipse.ptp.internal.rdt.sync.git.core.messages.Messages;
import org.eclipse.ptp.rdt.sync.core.AbstractSyncFileFilter;
import org.eclipse.ptp.rdt.sync.core.SyncConfig;
import org.eclipse.ptp.rdt.sync.core.SyncConfigManager;
import org.eclipse.ptp.rdt.sync.core.SyncManager;

public class GitSyncFileFilter
extends AbstractSyncFileFilter {
    public static final String REMOTE_FILTER_IS_DIRTY = "remote_filter_is_dirty";
    private static Map<IProject, GitSyncFileFilter> projectToFilterMap = new HashMap<IProject, GitSyncFileFilter>();
    private final Repository repository;
    private final IProject project;
    private static Set<Character> escapifyCharSet = new HashSet<Character>();

    static {
        StringCharacterIterator it = new StringCharacterIterator("#\\!*?[]");
        char c = it.first();
        while (c != '\uffff') {
            escapifyCharSet.add(Character.valueOf(c));
            c = it.next();
        }
    }

    public static GitSyncFileFilter getFilter(IProject project) {
        GitSyncFileFilter filter = projectToFilterMap.get(project);
        if (filter == null) {
            try {
                filter = new GitSyncFileFilter(GitRemoteSyncConnection.getLocalRepo(project.getLocation().toString()), project);
                filter.loadFilter();
                projectToFilterMap.put(project, filter);
            }
            catch (IOException e) {
                Activator.log(String.valueOf(Messages.GitSyncFileFilter_UnableToLoad) + project.getName(), e);
            }
        }
        return filter;
    }

    public static void setFilter(IProject project, AbstractSyncFileFilter filter, Repository repository) {
        GitSyncFileFilter newGitFilter = new GitSyncFileFilter(repository, project);
        newGitFilter.initialize(filter);
        try {
            newGitFilter.saveFilter();
        }
        catch (IOException e) {
            Activator.log(String.valueOf(Messages.GitSyncFileFilter_UnableToSave) + project.getName(), e);
        }
        projectToFilterMap.put(project, newGitFilter);
    }

    GitSyncFileFilter(Repository repository, IProject project) {
        this.repository = repository;
        this.project = project;
    }

    public GitSyncFileFilter(GitSyncFileFilter filter) {
        this.repository = filter.repository;
        this.project = filter.project;
        this.rules.addAll(filter.rules);
    }

    public void addPattern(String pattern, boolean exclude, int index) {
        GitIgnoreRule newRule = new GitIgnoreRule(pattern, exclude);
        int nextIndex = 0;
        int numRulesRemoved = 0;
        Iterator it = this.rules.iterator();
        while (it.hasNext() && nextIndex < index) {
            AbstractSyncFileFilter.AbstractIgnoreRule existingRule = (AbstractSyncFileFilter.AbstractIgnoreRule)it.next();
            if (pattern.equals(existingRule.getPattern())) {
                it.remove();
                ++numRulesRemoved;
            }
            ++nextIndex;
        }
        this.rules.add(index - numRulesRemoved, newRule);
    }

    public void addPattern(IResource resource, boolean exclude, int index) {
        GitIgnoreRule newRule = new GitIgnoreRule(resource, exclude);
        int nextIndex = 0;
        int numRulesRemoved = 0;
        Iterator it = this.rules.iterator();
        while (it.hasNext() && nextIndex < index) {
            AbstractSyncFileFilter.AbstractIgnoreRule existingRule = (AbstractSyncFileFilter.AbstractIgnoreRule)it.next();
            if (newRule.getPattern().equals(existingRule.getPattern())) {
                it.remove();
                ++numRulesRemoved;
            }
            ++nextIndex;
        }
        if (numRulesRemoved == 0) {
            this.rules.add(index - numRulesRemoved, newRule);
        } else {
            boolean resourceIgnored = this.shouldIgnore(resource);
            if (resourceIgnored != exclude) {
                this.rules.add(index - numRulesRemoved, newRule);
            }
        }
    }

    public void saveFilter() throws IOException {
        File exclude = this.repository.getFS().resolve(this.repository.getDirectory(), "info/exclude");
        exclude.getParentFile().mkdirs();
        FileOutputStream file = new FileOutputStream(exclude);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)file, Constants.CHARSET));
        try {
            for (AbstractSyncFileFilter.AbstractIgnoreRule rule : this.rules) {
                out.write(rule.toString());
                out.newLine();
            }
        }
        finally {
            out.close();
        }
        RmCommandCached rmCommand = new RmCommandCached(this.repository);
        for (String fileName : this.getIgnoredFiles(null)) {
            rmCommand.addFilepattern(fileName);
        }
        try {
            rmCommand.call();
        }
        catch (NoFilepatternException e) {
            new IOException(e);
        }
        catch (GitAPIException e) {
            new IOException(e);
        }
        SyncConfig[] syncConfigArray = SyncConfigManager.getConfigs((IProject)this.project);
        int n = syncConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            SyncConfig config = syncConfigArray[n2];
            config.setProperty(REMOTE_FILTER_IS_DIRTY, "TRUE");
            ++n2;
        }
    }

    public void loadFilter() throws IOException {
        File exclude = this.repository.getFS().resolve(this.repository.getDirectory(), "info/exclude");
        if (exclude.exists()) {
            FileInputStream in = new FileInputStream(exclude);
            try {
                IgnoreNode node = new IgnoreNode();
                node.parse((InputStream)in);
                for (IgnoreRule rule : node.getRules()) {
                    this.rules.add(new GitIgnoreRule(rule));
                }
            }
            finally {
                in.close();
            }
        } else {
            this.initialize((AbstractSyncFileFilter)SyncManager.getDefaultFileFilter());
        }
    }

    public void initialize(AbstractSyncFileFilter fileFilter) {
        if (fileFilter instanceof GitSyncFileFilter) {
            this.rules.addAll(fileFilter.getRules());
        } else {
            for (AbstractSyncFileFilter.AbstractIgnoreRule rule : fileFilter.getRules()) {
                this.rules.add(new GitIgnoreRule(rule.getPattern(), rule.getResult()));
            }
            this.rules.add(new GitIgnoreRule("/.ptp-sync/", true));
        }
    }

    public Set<String> getIgnoredFiles(RevTree ref) throws IOException {
        TreeWalk treeWalk = new TreeWalk(this.repository);
        if (ref == null) {
            DirCache dirCache = this.repository.readDirCache();
            treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(dirCache));
        } else {
            treeWalk.addTree((AnyObjectId)ref);
        }
        HashSet<String> ignoredFiles = new HashSet<String>();
        int ignoreDepth = Integer.MAX_VALUE;
        while (treeWalk.next()) {
            boolean isSubtree = treeWalk.isSubtree();
            int depth = treeWalk.getDepth();
            String path = treeWalk.getPathString();
            if (isSubtree) {
                treeWalk.enterSubtree();
            }
            if (depth > ignoreDepth) {
                if (isSubtree) continue;
                ignoredFiles.add(path);
                continue;
            }
            if (depth <= ignoreDepth) {
                ignoreDepth = Integer.MAX_VALUE;
            }
            if (!this.shouldIgnore(path, isSubtree)) continue;
            if (isSubtree) {
                ignoreDepth = depth;
                continue;
            }
            ignoredFiles.add(path);
        }
        return ignoredFiles;
    }

    public DiffFiles getDiffFiles() throws IOException {
        TreeWalk treeWalk = new TreeWalk(this.repository);
        treeWalk.addTree((AbstractTreeIterator)new DirCacheIterator(this.repository.readDirCache()));
        treeWalk.addTree((AbstractTreeIterator)new FileTreeIterator(this.repository));
        treeWalk.setFilter((TreeFilter)new IndexDiffFilter(0, 1, false));
        DiffFiles diffFiles = new DiffFiles();
        int ignoreDepth = Integer.MAX_VALUE;
        while (treeWalk.next()) {
            DirCacheIterator dirCacheIterator = (DirCacheIterator)treeWalk.getTree(0, DirCacheIterator.class);
            String path = treeWalk.getPathString();
            boolean isSubtree = treeWalk.isSubtree();
            int depth = treeWalk.getDepth();
            if (dirCacheIterator == null && this.shouldIgnore(path, isSubtree)) continue;
            if (depth <= ignoreDepth) {
                ignoreDepth = Integer.MAX_VALUE;
            }
            if (dirCacheIterator != null && isSubtree && ignoreDepth == Integer.MAX_VALUE && this.shouldIgnore(path, isSubtree)) {
                ignoreDepth = depth;
            }
            if (isSubtree) {
                treeWalk.enterSubtree();
                continue;
            }
            if (dirCacheIterator == null && ignoreDepth != Integer.MAX_VALUE) continue;
            WorkingTreeIterator workTreeIter = (WorkingTreeIterator)treeWalk.getTree(1, WorkingTreeIterator.class);
            if (workTreeIter != null) {
                diffFiles.added.add(path);
                continue;
            }
            diffFiles.removed.add(path);
        }
        return diffFiles;
    }

    public static void main(String[] args) throws IOException {
        File localDir = new File(args[0]);
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        File gitDirFile = new File(localDir + File.separator + args[1]);
        Repository repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)repoBuilder.setWorkTree(localDir)).setGitDir(gitDirFile)).build();
        GitSyncFileFilter filter = new GitSyncFileFilter(repository, null);
        filter.loadFilter();
        Set<String> files = filter.getDiffFiles().added;
        for (String path : files) {
            System.out.println(path);
        }
    }

    public AbstractSyncFileFilter clone() {
        return new GitSyncFileFilter(this);
    }

    public class DiffFiles {
        public Set<String> added = new HashSet<String>();
        public Set<String> removed = new HashSet<String>();
    }

    public class GitIgnoreRule
    extends AbstractSyncFileFilter.AbstractIgnoreRule {
        private final IgnoreRule rule;

        public GitIgnoreRule(String pattern, boolean exclude) {
            super((AbstractSyncFileFilter)GitSyncFileFilter.this);
            if (!exclude) {
                pattern = "!" + pattern;
            }
            this.rule = new IgnoreRule(pattern);
        }

        private String charEscapify(String inputString) {
            StringBuffer newString = new StringBuffer("");
            StringCharacterIterator it = new StringCharacterIterator(inputString);
            char c = it.first();
            while (c != '\uffff') {
                if (escapifyCharSet.contains(Character.valueOf(c))) {
                    newString.append("\\" + c);
                } else {
                    newString.append(c);
                }
                c = it.next();
            }
            inputString = newString.toString();
            return inputString;
        }

        public GitIgnoreRule(IResource resource, boolean exclude) {
            super((AbstractSyncFileFilter)GitSyncFileFilter.this);
            String pattern = this.charEscapify(resource.getProjectRelativePath().toString());
            if (pattern.charAt(0) != '/') {
                pattern = "/" + pattern;
            }
            if (resource.getType() == 2) {
                pattern = String.valueOf(pattern) + "/";
            }
            if (!exclude) {
                pattern = "!" + pattern;
            }
            this.rule = new IgnoreRule(pattern);
        }

        private GitIgnoreRule(IgnoreRule rule) {
            super((AbstractSyncFileFilter)GitSyncFileFilter.this);
            this.rule = rule;
        }

        public boolean isMatch(IResource target) {
            return this.isMatch(target.getProjectRelativePath().toString(), target.getType() == 2);
        }

        public synchronized boolean isMatch(String target, boolean isFolder) {
            return this.rule.isMatch(target, isFolder);
        }

        public boolean getResult() {
            return this.rule.getResult();
        }

        public String toString() {
            return String.valueOf(this.rule.getNegation() ? "!" : "") + this.rule.getPattern() + (this.rule.dirOnly() ? "/" : "");
        }

        public String getPattern() {
            return String.valueOf(this.rule.getPattern()) + (this.rule.dirOnly() ? "/" : "");
        }
    }
}

