/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search.actions;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.internal.rdt.core.model.Scope;
import org.eclipse.ptp.internal.rdt.ui.search.ISearchService;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchService;
import org.eclipse.ptp.internal.rdt.ui.search.actions.SelectionParseAction;
import org.eclipse.ptp.rdt.ui.serviceproviders.IIndexServiceProvider2;
import org.eclipse.ptp.services.core.IService;
import org.eclipse.ptp.services.core.IServiceConfiguration;
import org.eclipse.ptp.services.core.IServiceProvider;
import org.eclipse.ptp.services.core.ServiceModelManager;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindAction
extends SelectionParseAction {
    public FindAction(CEditor editor) {
        super(editor);
    }

    public FindAction(IWorkbenchSite site) {
        super(site);
    }

    public void run() {
        ISearchQuery searchJob = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (object instanceof ISourceReference) {
                searchJob = this.createQuery((ISourceReference)object);
            }
        } else if (selection instanceof ITextSelection) {
            ITextSelection selNode = (ITextSelection)selection;
            IWorkingCopy element = this.fEditor.getInputCElement();
            while (element != null && !(element instanceof ITranslationUnit)) {
                element = element.getParent();
            }
            if (element != null) {
                if (selNode.getLength() == 0) {
                    IDocument document = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                    IRegion reg = CWordFinder.findWord((IDocument)document, (int)selNode.getOffset());
                    selNode = new TextSelection(document, reg.getOffset(), reg.getLength());
                }
                searchJob = this.createQuery((ICElement)element, selNode);
            }
        }
        if (searchJob == null) {
            this.showStatusLineMessage(CSearchMessages.CSearchOperation_operationUnavailable_message);
            return;
        }
        this.clearStatusLine();
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground(searchJob);
    }

    protected ISearchQuery createQuery(ISourceReference object) {
        IProject project = object.getTranslationUnit().getCProject().getProject();
        ISearchService service = this.getSearchService(project);
        Scope scope = new Scope(project);
        return service.createSearchElementQuery(scope, this.getScope(), object, this.getLimitTo());
    }

    private ISearchService getSearchService(IProject project) {
        IService indexingService;
        ServiceModelManager smm = ServiceModelManager.getInstance();
        IServiceConfiguration serviceConfig = smm.getActiveConfiguration(project);
        IServiceProvider serviceProvider = serviceConfig.getServiceProvider(indexingService = smm.getService("org.eclipse.ptp.rdt.core.CIndexingService"));
        if (!(serviceProvider instanceof IIndexServiceProvider2)) {
            return null;
        }
        ISearchService service = ((IIndexServiceProvider2)serviceProvider).getSearchService();
        return service;
    }

    protected ISearchQuery createQuery(ICElement element, ITextSelection selNode) {
        IProject project = element.getCProject().getProject();
        ISearchService service = this.getSearchService(project);
        Scope scope = new Scope(project);
        if (service instanceof RemoteSearchService) {
            RemoteSearchService rss = (RemoteSearchService)service;
            return rss.createSearchTextSelectionQuery(scope, this.getScope(), (ITranslationUnit)element, selNode, this.getLimitTo(), project);
        }
        return service.createSearchTextSelectionQuery(scope, this.getScope(), (ITranslationUnit)element, selNode, this.getLimitTo());
    }

    protected abstract String getScopeDescription();

    protected abstract ICElement[] getScope();

    protected abstract int getLimitTo();
}

