/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ptp.internal.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.internal.remote.core.RemoteServicesProxy;

public class RemoteServicesImpl {
    public static final String REMOTE_SERVICES_EXTENSION_POINT_ID = "remoteServices";
    private static final Map<String, RemoteServicesProxy> fRemoteServicesById = Collections.synchronizedMap(new HashMap());
    private static final Map<String, RemoteServicesProxy> fRemoteServicesByScheme = Collections.synchronizedMap(new HashMap());

    private RemoteServicesImpl() {
    }

    public static RemoteServicesProxy getRemoteServiceProxyById(String id) {
        RemoteServicesImpl.retrieveRemoteServices();
        return fRemoteServicesById.get(id);
    }

    public static RemoteServicesProxy getRemoteServiceProxyByURI(URI uri) {
        String scheme = uri.getScheme();
        if (scheme != null) {
            RemoteServicesImpl.retrieveRemoteServices();
            return fRemoteServicesByScheme.get(scheme);
        }
        return null;
    }

    public static RemoteServicesProxy[] getRemoteServiceProxies() {
        RemoteServicesImpl.retrieveRemoteServices();
        ArrayList<RemoteServicesProxy> services = new ArrayList<RemoteServicesProxy>();
        for (RemoteServicesProxy proxy : fRemoteServicesById.values()) {
            services.add(proxy);
        }
        Collections.sort(services, new RemoteServicesSorter());
        return services.toArray(new RemoteServicesProxy[0]);
    }

    private static void retrieveRemoteServices() {
        if (fRemoteServicesById.isEmpty()) {
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PTPRemoteCorePlugin.getUniqueIdentifier(), REMOTE_SERVICES_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ce = iConfigurationElementArray[n4];
                    RemoteServicesProxy proxy = new RemoteServicesProxy(ce);
                    fRemoteServicesById.put(proxy.getId(), proxy);
                    fRemoteServicesByScheme.put(proxy.getScheme(), proxy);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static class RemoteServicesSorter
    implements Comparator<RemoteServicesProxy> {
        private RemoteServicesSorter() {
        }

        @Override
        public int compare(RemoteServicesProxy o1, RemoteServicesProxy o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

