/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.remotetools.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ptp.internal.remote.remotetools.core.RemoteToolsServices;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.AbstractRemoteUIConnectionManager;
import org.eclipse.ptp.remotetools.environment.core.ITargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetElement;
import org.eclipse.ptp.remotetools.environment.core.TargetTypeElement;
import org.eclipse.ptp.remotetools.environment.wizard.EnvironmentWizard;
import org.eclipse.swt.widgets.Shell;

public class RemoteToolsUIConnectionManager
extends AbstractRemoteUIConnectionManager {
    private final TargetTypeElement remoteHost;
    private final IRemoteConnectionManager connMgr;

    public RemoteToolsUIConnectionManager(IRemoteServices services) {
        this.connMgr = services.getConnectionManager();
        this.remoteHost = RemoteToolsServices.getTargetTypeElement();
    }

    public IRemoteConnection newConnection(Shell shell) {
        return this.newConnection(shell, null, null);
    }

    public IRemoteConnection newConnection(Shell shell, String[] attrHints, String[] attrHintValues) {
        if (this.remoteHost != null) {
            EnvironmentWizard wizard;
            IRemoteConnection[] oldConns = this.connMgr.getConnections();
            if (attrHints != null) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                int i = 0;
                while (i < attrHints.length) {
                    if (attrHints[i].equals("CONNECTION_ADDRESS_HINT")) {
                        attrs.put("org.eclipse.ptp.remotetools.environment.generichost.connection-address", attrHintValues[i]);
                    } else if (attrHints[i].equals("CONNECTION_PORT_HINT")) {
                        attrs.put("org.eclipse.ptp.remotetools.environment.generichost.connection-port", attrHintValues[i]);
                    } else if (attrHints[i].equals("CONNECTION_TIMEOUT_HINT")) {
                        attrs.put("org.eclipse.ptp.remotetools.environment.generichost.connection-timeout", attrHintValues[i]);
                    } else if (attrHints[i].equals("LOGIN_USERNAME_HINT")) {
                        attrs.put("org.eclipse.ptp.remotetools.environment.generichost.login-username", attrHintValues[i]);
                    }
                    ++i;
                }
                TargetElement target = new TargetElement(this.remoteHost, this.remoteHost.getName(), attrs, this.remoteHost.getName());
                this.remoteHost.addElement(target);
                wizard = new EnvironmentWizard((ITargetElement)target);
            } else {
                wizard = new EnvironmentWizard(this.remoteHost);
            }
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.create();
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                IRemoteConnection[] newConns = this.connMgr.getConnections();
                if (newConns.length <= oldConns.length) {
                    return null;
                }
                Arrays.sort(oldConns, new Comparator<IRemoteConnection>(){

                    @Override
                    public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                        return c1.getName().compareToIgnoreCase(c2.getName());
                    }
                });
                Arrays.sort(newConns, new Comparator<IRemoteConnection>(){

                    @Override
                    public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                        return c1.getName().compareToIgnoreCase(c2.getName());
                    }
                });
                int i = 0;
                while (i < oldConns.length) {
                    if (!oldConns[i].equals(newConns[i])) {
                        return newConns[i];
                    }
                    ++i;
                }
                return newConns[newConns.length - 1];
            }
        }
        return null;
    }

    public void updateConnection(Shell shell, IRemoteConnection connection) {
    }
}

