/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.ui;

import java.util.Vector;
import org.eclipse.ptp.internal.remote.rse.core.RSEConnection;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFolderDialog;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.widgets.Shell;

public class RSEUIFileManager
implements IRemoteUIFileManager {
    private final IRemoteConnectionManager connMgr;
    private IRemoteConnection connection = null;
    private IHost connHost = null;
    private boolean onlyConnection = true;

    public RSEUIFileManager(IRemoteServices services) {
        this.connMgr = services.getConnectionManager();
    }

    public String browseDirectory(Shell shell, String message, String filterPath, int flags) {
        SystemRemoteFolderDialog dlg = new SystemRemoteFolderDialog(shell, message, this.connHost);
        dlg.setDefaultSystemConnection(this.connHost, this.onlyConnection);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0) {
            this.connHost = dlg.getSelectedConnection();
            this.connection = this.connMgr.getConnection(this.connHost.getName());
            Object retObj = dlg.getSelectedObject();
            if (retObj instanceof IRemoteFile) {
                IRemoteFile selectedFile = (IRemoteFile)retObj;
                return selectedFile.getAbsolutePath();
            }
        }
        return null;
    }

    public String browseFile(Shell shell, String message, String filterPath, int flags) {
        SystemRemoteFileDialog dlg = new SystemRemoteFileDialog(shell, message, this.connHost);
        dlg.setDefaultSystemConnection(this.connHost, this.onlyConnection);
        dlg.setBlockOnOpen(true);
        if (dlg.open() == 0) {
            this.connHost = dlg.getSelectedConnection();
            this.connection = this.connMgr.getConnection(this.connHost.getName());
            Object retObj = dlg.getSelectedObject();
            if (retObj instanceof IRemoteFile) {
                IRemoteFile selectedFile = (IRemoteFile)retObj;
                return selectedFile.getAbsolutePath();
            }
        }
        return null;
    }

    public String[] browseFiles(Shell shell, String message, String filterPath, int flags) {
        SystemRemoteFileDialog dlg = new SystemRemoteFileDialog(shell, message, this.connHost);
        dlg.setDefaultSystemConnection(this.connHost, this.onlyConnection);
        dlg.setBlockOnOpen(true);
        dlg.setMultipleSelectionMode(true);
        if (dlg.open() == 0) {
            this.connHost = dlg.getSelectedConnection();
            this.connection = this.connMgr.getConnection(this.connHost.getName());
            Object[] retObj = dlg.getSelectedObjects();
            Vector<String> selections = new Vector<String>(retObj.length);
            int i = 0;
            while (i < retObj.length) {
                if (retObj[i] instanceof IRemoteFile) {
                    selections.add(((IRemoteFile)retObj[i]).getAbsolutePath());
                }
                ++i;
            }
            String[] remotePaths = new String[selections.size()];
            int i2 = 0;
            for (String s : selections) {
                remotePaths[i2++] = s;
            }
            return remotePaths;
        }
        return null;
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IRemoteConnection connection) {
        this.connection = connection;
        this.connHost = ((RSEConnection)connection).getHost();
    }

    public void showConnections(boolean enable) {
        this.onlyConnection = !enable;
    }
}

