/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.utils;

import java.util.List;
import java.util.Map;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlConstants;
import org.eclipse.ptp.internal.rm.jaxb.control.core.data.ArgImpl;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.EnvironmentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvironmentVariableUtils {
    public static void addVariable(String uuid, EnvironmentType var, Map<String, String> env, IVariableMap map) {
        String key = var.getValue();
        String value = null;
        if (key == null) {
            List args = var.getArg();
            if (args != null) {
                value = ArgImpl.toString(uuid, var.getArg(), map);
            }
        } else {
            value = map.getString(uuid, key);
        }
        if (value != null && !"".equals(value)) {
            env.put(var.getName(), value);
        }
    }

    public static void addVariable(String name, String value, String directive, StringBuffer buffer) {
        if (value != null && !"".equals(value)) {
            if ("setenv".equals(EnvironmentVariableUtils.getSyntax(directive))) {
                EnvironmentVariableUtils.setenv(name, value, buffer);
            } else if ("export".equals(EnvironmentVariableUtils.getSyntax(directive))) {
                EnvironmentVariableUtils.export(name, value, buffer);
            }
        }
    }

    public static String toString(IVariableMap map) {
        StringBuffer b = new StringBuffer();
        for (AttributeType a : map.getAttributes().values()) {
            b.append(a.getName()).append("=").append(a.getValue()).append(JAXBControlConstants.LINE_SEP);
        }
        return b.toString();
    }

    private static void export(String name, String value, StringBuffer buffer) {
        buffer.append("export").append(" ").append(name).append("=").append("\"").append(value).append("\"").append("\n");
    }

    private static String getSyntax(String directive) {
        if (directive.indexOf("csh") >= 0) {
            return "setenv";
        }
        return "export";
    }

    private static void setenv(String name, String value, StringBuffer buffer) {
        buffer.append("setenv").append(" ").append(name).append(" ").append("\"").append(value).append("\"").append("\n");
    }

    private EnvironmentVariableUtils() {
    }
}

