/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.monitor.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.core.jobs.IJobListener;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.JobManager;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.lml.monitor.core.LMLMonitorCorePlugin;
import org.eclipse.ptp.internal.rm.lml.monitor.core.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.server.core.RemoteServerManager;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorDriverType;
import org.eclipse.ptp.rm.jaxb.core.data.MonitorType;
import org.eclipse.ptp.rm.jaxb.core.data.SimpleCommandType;
import org.eclipse.ptp.rm.lml.core.JobStatusData;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.elements.CommandType;
import org.eclipse.ptp.rm.lml.core.elements.DriverType;
import org.eclipse.ptp.rm.lml.core.elements.RequestType;
import org.eclipse.ptp.rm.lml.da.server.core.LMLDAServer;
import org.eclipse.ptp.rm.lml.monitor.core.IMonitorControl;
import org.eclipse.ptp.rm.lml.monitor.core.MonitorControlManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class MonitorControl
implements IMonitorControl {
    private static final int JOB_SCHEDULE_FREQUENCY = 60000;
    private MonitorJob fMonitorJob;
    private final String fControlId;
    private final LMLManager fLMLManager = LMLManager.getInstance();
    private final JobListener fJobListener = new JobListener();
    private String fSavedLayout;
    private final List<JobStatusData> fSavedJobs = new ArrayList<JobStatusData>();
    private String fConfigurationName;
    private boolean fActive;
    private String fRemoteServicesId;
    private String fConnectionName;
    private static final String XML = "xml";
    private static final String JOBS_ATTR = "jobs";
    private static final String JOB_ATTR = "job";
    private static final String LAYOUT_ATTR = "layout";
    private static final String LAYOUT_STRING_ATTR = "layoutString";
    private static final String MONITOR_STATE = "monitorState";
    private static final String MONITOR_ATTR = "monitor";
    private static final String REMOTE_SERVICES_ID_ATTR = "remoteServicesId";
    private static final String CONNECTION_NAME_ATTR = "connectionName";
    private static final String CONFIGURATION_NAME_ATTR = "configurationName";

    public MonitorControl(String controlId) {
        this.fControlId = controlId;
    }

    private void addJob(IJobStatus status) {
        ILaunchController controller = LaunchControllerManager.getInstance().getLaunchController(status.getControlId());
        if (controller != null) {
            String[][] attrs = new String[][]{{"controlId", status.getControlId()}, {"queueName", status.getQueueName()}, {"owner", status.getOwner()}, {"stdoutRemotePath", status.getOutputPath()}, {"stderrRemotePath", status.getErrorPath()}, {"interactive", Boolean.toString(status.isInteractive())}};
            JobStatusData data = new JobStatusData(status.getJobId(), attrs);
            data.setState(status.getState());
            data.setStateDetail(status.getStateDetail());
            this.fLMLManager.addUserJob(this.getControlId(), status.getJobId(), data);
        }
    }

    @Override
    public void dispose() {
        try {
            this.getSaveLocation().delete();
        }
        catch (Exception e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    @Override
    public String getConnectionName() {
        return this.fConnectionName;
    }

    @Override
    public String getControlId() {
        return this.fControlId;
    }

    private RequestType getMonitorConfigurationRequestType(ILaunchController controller) {
        RequestType request = new RequestType();
        DriverType driver = new DriverType();
        driver.setName(this.getSystemType());
        MonitorType monitor = controller.getConfiguration().getMonitorData();
        if (monitor != null) {
            List driverCommands = driver.getCommand();
            for (MonitorDriverType monitorDriver : monitor.getDriver()) {
                for (SimpleCommandType monitorCmd : monitorDriver.getCmd()) {
                    CommandType cmd = new CommandType();
                    cmd.setName(monitorCmd.getName());
                    cmd.setExec(monitorCmd.getExec());
                    driverCommands.add(cmd);
                }
            }
        }
        request.getDriver().add(driver);
        return request;
    }

    @Override
    public String getConfigurationName() {
        return this.fConfigurationName;
    }

    private IRemoteConnection getRemoteConnection(IProgressMonitor monitor) throws CoreException {
        IRemoteServices services = RemoteServices.getRemoteServices((String)this.getRemoteServicesId(), (IProgressMonitor)monitor);
        if (services != null) {
            IRemoteConnectionManager connMgr = services.getConnectionManager();
            return connMgr.getConnection(this.getConnectionName());
        }
        throw CoreExceptionUtils.newException((String)Messages.MonitorControl_unableToOpenRemoteConnection, null);
    }

    @Override
    public String getRemoteServicesId() {
        return this.fRemoteServicesId;
    }

    private File getSaveLocation() {
        return LMLMonitorCorePlugin.getDefault().getStateLocation().append(this.getControlId()).addFileExtension(XML).toFile();
    }

    @Override
    public String getSystemType() {
        return MonitorControlManager.getSystemType(this.fConfigurationName);
    }

    @Override
    public boolean isActive() {
        return this.fActive;
    }

    @Override
    public boolean load() throws CoreException {
        FileReader reader;
        this.fSavedJobs.clear();
        try {
            reader = new FileReader(this.getSaveLocation());
        }
        catch (FileNotFoundException e) {
            throw CoreExceptionUtils.newException((String)e.getMessage(), (Throwable)e);
        }
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        boolean active = this.loadState((IMemento)memento);
        IMemento childLayout = memento.getChild(LAYOUT_ATTR);
        if (childLayout != null) {
            this.fSavedLayout = childLayout.getString(LAYOUT_STRING_ATTR);
        }
        childLayout = memento.getChild(JOBS_ATTR);
        this.loadJobs(childLayout, this.fSavedJobs);
        return active;
    }

    private void loadJobs(IMemento memento, List<JobStatusData> jobs) {
        if (memento != null) {
            IMemento[] children;
            IMemento[] iMementoArray = children = memento.getChildren(JOB_ATTR);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String[] keys = child.getAttributeKeys();
                String[][] attrs = new String[keys.length][2];
                int i = 0;
                while (i < keys.length) {
                    attrs[i][0] = keys[i];
                    attrs[i][1] = child.getString(keys[i]);
                    ++i;
                }
                JobStatusData jobData = new JobStatusData(child.getID(), attrs);
                jobs.add(jobData);
                ++n2;
            }
        }
    }

    private boolean loadState(IMemento memento) {
        this.setRemoteServicesId(memento.getString(REMOTE_SERVICES_ID_ATTR));
        this.setConnectionName(memento.getString(CONNECTION_NAME_ATTR));
        this.setConfigurationName(memento.getString(CONFIGURATION_NAME_ATTR));
        return memento.getBoolean(MONITOR_STATE);
    }

    @Override
    public void refresh() {
        this.fMonitorJob.refresh();
    }

    @Override
    public void save() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)MONITOR_ATTR);
        String layout = this.fLMLManager.getCurrentLayout(this.getControlId());
        JobStatusData[] jobs = this.fLMLManager.getUserJobs(this.getControlId());
        this.saveState((IMemento)memento);
        if (layout != null) {
            IMemento layoutMemento = memento.createChild(LAYOUT_ATTR);
            layoutMemento.putString(LAYOUT_STRING_ATTR, layout);
        }
        if (jobs != null && jobs.length > 0) {
            IMemento jobsMemento = memento.createChild(JOBS_ATTR);
            JobStatusData[] jobStatusDataArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                JobStatusData status = jobStatusDataArray[n2];
                if (!status.isRemoved()) {
                    this.saveJob(status, jobsMemento);
                }
                ++n2;
            }
        }
        try {
            FileWriter writer = new FileWriter(this.getSaveLocation());
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            LMLMonitorCorePlugin.log(e.getLocalizedMessage());
        }
    }

    private void saveJob(JobStatusData job, IMemento memento) {
        IMemento jobMemento = memento.createChild(JOB_ATTR, job.getJobId());
        for (String key : job.getKeys()) {
            jobMemento.putString(key, job.getString(key));
        }
    }

    private void saveState(IMemento memento) {
        memento.putString(REMOTE_SERVICES_ID_ATTR, this.getRemoteServicesId());
        memento.putString(CONNECTION_NAME_ATTR, this.getConnectionName());
        memento.putString(CONFIGURATION_NAME_ATTR, this.getConfigurationName());
        memento.putBoolean(MONITOR_STATE, this.isActive());
    }

    @Override
    public void setConnectionName(String connName) {
        this.fConnectionName = connName;
    }

    @Override
    public void setRemoteServicesId(String id) {
        this.fRemoteServicesId = id;
    }

    @Override
    public void setConfigurationName(String name) {
        this.fConfigurationName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(IProgressMonitor monitor) throws CoreException {
        if (!this.isActive()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
            try {
                ILaunchController controller = LaunchControllerManager.getInstance().getLaunchController(this.getRemoteServicesId(), this.getConnectionName(), this.getConfigurationName());
                if (controller == null) {
                    throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), Messages.MonitorControl_UnableToLocateLaunchController));
                }
                try {
                    this.load();
                }
                catch (CoreException e) {
                    LMLMonitorCorePlugin.log(e.getLocalizedMessage());
                }
                IRemoteConnection conn = this.getRemoteConnection((IProgressMonitor)progress.newChild(10));
                if (conn == null) {
                    throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), NLS.bind((String)Messages.MonitorControl_UnableToLocateConnection, (Object)this.getConnectionName())));
                }
                if (conn == null || progress.isCanceled()) {
                    return;
                }
                if (!conn.isOpen()) {
                    try {
                        conn.open((IProgressMonitor)progress.newChild(10));
                    }
                    catch (RemoteConnectionException e) {
                        throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), e.getMessage()));
                    }
                    if (!conn.isOpen()) {
                        throw new CoreException((IStatus)new Status(4, LMLMonitorCorePlugin.getUniqueIdentifier(), Messages.LMLResourceManagerMonitor_unableToOpenConnection));
                    }
                }
                this.fLMLManager.openLgui(this.getControlId(), conn.getUsername(), this.getMonitorConfigurationRequestType(controller), this.fSavedLayout, this.fSavedJobs.toArray(new JobStatusData[0]));
                this.fActive = true;
                MonitorControlManager.getInstance().fireMonitorUpdated(new IMonitorControl[]{this});
                MonitorControl monitorControl = this;
                synchronized (monitorControl) {
                    if (this.fMonitorJob == null) {
                        this.fMonitorJob = new MonitorJob(conn);
                    }
                    this.fMonitorJob.schedule();
                }
                JobManager.getInstance().addListener((IJobListener)this.fJobListener);
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws CoreException {
        if (this.isActive()) {
            JobManager.getInstance().removeListener((IJobListener)this.fJobListener);
            this.save();
            this.fLMLManager.closeLgui(this.getControlId());
            MonitorControl monitorControl = this;
            synchronized (monitorControl) {
                if (this.fMonitorJob != null) {
                    this.fMonitorJob.cancel();
                    this.fMonitorJob = null;
                }
            }
            this.fActive = false;
            MonitorControlManager.getInstance().fireMonitorUpdated(new IMonitorControl[]{this});
        }
    }

    private void updateJob(IJobStatus status) {
        if (status.getControlId().equals(this.getControlId())) {
            this.fLMLManager.updateUserJob(this.getControlId(), status.getJobId(), status.getState(), status.getStateDetail());
        }
    }

    private class JobListener
    implements IJobListener {
        private JobListener() {
        }

        public void jobAdded(IJobStatus status) {
            MonitorControl.this.addJob(status);
        }

        public void jobChanged(IJobStatus status) {
            MonitorControl.this.updateJob(status);
        }
    }

    private class MonitorJob
    extends Job {
        private final LMLDAServer fServer;

        public MonitorJob(IRemoteConnection conn) {
            super(Messages.LMLResourceManagerMonitor_LMLMonitorJob);
            this.setSystem(true);
            this.fServer = (LMLDAServer)RemoteServerManager.getServer((String)LMLDAServer.SERVER_ID, (IRemoteConnection)conn);
            this.fServer.setWorkDir(new Path(conn.getWorkingDirectory()).append(".eclipsesettings").toString());
        }

        public void refresh() {
            this.wakeUp();
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                try {
                    this.fServer.startServer((IProgressMonitor)subMon.newChild(20));
                    if (!subMon.isCanceled()) {
                        this.fServer.waitForServerStart((IProgressMonitor)subMon.newChild(20));
                        if (!subMon.isCanceled()) {
                            LMLManager.getInstance().update(MonitorControl.this.getControlId(), this.fServer.getInputStream(), this.fServer.getOutputStream());
                        }
                    }
                }
                catch (Exception e) {
                    MonitorControl.this.fActive = false;
                    MonitorControlManager.getInstance().fireMonitorUpdated(new IMonitorControl[]{MonitorControl.this});
                    Status status = new Status(4, "org.eclipse.ptp.rm.lml.monitor.core", e.getLocalizedMessage());
                    if (monitor != null) {
                        monitor.done();
                    }
                    return status;
                }
                IStatus status = this.fServer.waitForServerFinish((IProgressMonitor)subMon.newChild(40));
                if (status == Status.OK_STATUS) {
                    this.schedule(60000L);
                } else {
                    MonitorControl.this.fActive = false;
                    MonitorControlManager.getInstance().fireMonitorUpdated(new IMonitorControl[]{MonitorControl.this});
                }
                IStatus iStatus = status;
                return iStatus;
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }
}

