/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.model;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.eclipse.ptp.internal.ui.model.IElementSet;

public class ElementSet
implements IElementSet {
    private final String fId;
    private final String fName;
    private final BitSet fElements = new BitSet();
    private final BitSet fSelectedElements = new BitSet();
    private final List<String> matchSetList = new ArrayList<String>();

    public ElementSet(String id, String name) {
        this.fId = id;
        this.fName = name;
    }

    @Override
    public void addElements(BitSet elements) {
        this.fElements.or(elements);
    }

    @Override
    public void addMatchSet(String setID) {
        if (!this.containsMatchSet(setID)) {
            this.matchSetList.add(setID);
        }
    }

    @Override
    public BitSet contains(BitSet elements) {
        BitSet result = (BitSet)this.fElements.clone();
        result.and(elements);
        return result;
    }

    @Override
    public boolean contains(int element) {
        return this.fElements.get(element);
    }

    @Override
    public boolean containsMatchSet(String setID) {
        return this.matchSetList.contains(setID);
    }

    @Override
    public String getID() {
        return this.fId;
    }

    @Override
    public String[] getMatchSetIDs() {
        return this.matchSetList.toArray(new String[0]);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public BitSet getSelected() {
        return (BitSet)this.fSelectedElements.clone();
    }

    @Override
    public boolean isRootSet() {
        return this.fId.equals("Root");
    }

    @Override
    public boolean isSelected(int index) {
        return this.fSelectedElements.get(index);
    }

    @Override
    public void removeElement(int index) {
        this.fElements.clear(index);
        this.fSelectedElements.clear(index);
    }

    @Override
    public void removeElements(BitSet elements) {
        this.fElements.andNot(elements);
        this.fSelectedElements.andNot(elements);
    }

    @Override
    public void removeMatchSet(String setID) {
        this.matchSetList.remove(setID);
    }

    @Override
    public void setSelected(int index, boolean selected) {
        if (this.fElements.get(index)) {
            if (selected) {
                this.fSelectedElements.set(index);
            } else {
                this.fSelectedElements.clear(index);
            }
        }
    }

    @Override
    public int size() {
        return this.fElements.cardinality();
    }
}

