/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.core.vpg.refactoring;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rephraserengine.core.refactorings.IResourceRefactoring;
import org.eclipse.rephraserengine.core.vpg.IVPGNode;
import org.eclipse.rephraserengine.core.vpg.eclipse.EclipseVPG;
import org.eclipse.rephraserengine.core.vpg.refactoring.VPGRefactoring;

public abstract class VPGResourceRefactoring<A, T, V extends EclipseVPG<A, T, ? extends IVPGNode<T>>>
extends VPGRefactoring<A, T, V>
implements IResourceRefactoring {
    protected List<IFile> selectedFiles = null;

    @Override
    public void initialize(List<IFile> files) {
        if (files == null) {
            throw new IllegalArgumentException("files argument cannot be null");
        }
        if (files.isEmpty()) {
            throw new IllegalArgumentException("files argument cannot be empty");
        }
        this.selectedFiles = new LinkedList<IFile>();
        this.selectedFiles.addAll(files);
    }

    @Override
    protected void checkFiles(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        assert (this.selectedFiles != null);
        for (IFile file : this.selectedFiles) {
            this.checkIfFileIsAccessibleAndWritable(file);
        }
    }
}

