/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.jaxb;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.ptp.internal.etfw.jaxb.data.ControlDataType;
import org.eclipse.ptp.internal.etfw.jaxb.data.EtfwToolProcessType;
import org.eclipse.ptp.internal.etfw.jaxb.osgi.Activator;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.xml.sax.SAXException;

public class JAXBInitializationUtil {
    private static Unmarshaller unmarshaller;
    private static Validator validator;

    public static String getETFWConfigurationXML(URL url) throws IOException {
        StringBuffer buffer = new StringBuffer();
        if (url != null) {
            InputStreamReader reader = new InputStreamReader(url.openStream());
            char[] chars = new char[4096];
            int read = 0;
            while (true) {
                try {
                    read = reader.read(chars, 0, chars.length);
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (read <= 0) break;
                buffer.append(chars, 0, read);
            }
            return buffer.toString();
        }
        return null;
    }

    public static EtfwToolProcessType initializeEtfwToolProcessType(String xml) throws IOException, SAXException, URISyntaxException, JAXBException {
        return JAXBInitializationUtil.unmarshallEtfwToolProcessType(xml);
    }

    private static EtfwToolProcessType unmarshallEtfwToolProcessType(String xml) throws JAXBException, IOException, SAXException, URISyntaxException {
        StreamSource source = new StreamSource(new StringReader(xml));
        JAXBInitializationUtil.validate(source);
        source = new StreamSource(new StringReader(xml));
        JAXBElement o = (JAXBElement)JAXBInitializationUtil.getUnmarshaller().unmarshal((Source)source);
        EtfwToolProcessType toolData = (EtfwToolProcessType)o.getValue();
        return toolData;
    }

    private static void validate(Source source) throws SAXException, IOException, URISyntaxException {
        JAXBInitializationUtil.getValidator().validate(source);
    }

    private static synchronized Validator getValidator() throws IOException, SAXException {
        if (validator == null) {
            URL xsd = Activator.getResource("schema/etfw_tool_type.xsd");
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource[]{new StreamSource(xsd.openStream())});
            validator = schema.newValidator();
        }
        return validator;
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        if (unmarshaller == null) {
            JAXBContext jc = JAXBContext.newInstance((String)"org.eclipse.ptp.internal.etfw.jaxb.data", (ClassLoader)JAXBInitializationUtil.class.getClassLoader());
            unmarshaller = jc.createUnmarshaller();
        }
        return unmarshaller;
    }

    public static void initializeMap(EtfwToolProcessType etfwTool, IVariableMap instance) {
        ControlDataType control = etfwTool.getControlData();
        Map env = instance.getAttributes();
        JAXBInitializationUtil.addAttributes(env, control);
    }

    public static void addAttributes(Map<String, AttributeType> env, ControlDataType control) {
        if (control == null) {
            return;
        }
        List<AttributeType> attributes = control.getAttribute();
        for (AttributeType attribute : attributes) {
            env.put(attribute.getName(), attribute);
            if (attribute.getValue() != null) continue;
            attribute.setValue((Object)attribute.getDefault());
        }
    }
}

