/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;

public class RemoteFoldingRegionsHandler {
    public StatementVisitor createStatementVisitor(Stack<StatementRegion> iral) {
        return new StatementVisitor(iral);
    }

    void computePreprocessorFoldingStructure(IASTTranslationUnit ast, int docSize, List<Branch> branches) {
        IASTPreprocessorStatement[] preprocStmts;
        Stack<Branch> branchStack = new Stack<Branch>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = ast.getAllPreprocessorStatements();
        int n = preprocStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTFileLocation stmtLocation;
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            if (statement.isPartOfTranslationUnitFile() && (stmtLocation = statement.getFileLocation()) != null) {
                Branch branch;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    branchStack.push(new Branch(stmtLocation.getNodeOffset(), ifStmt.taken(), "#if " + new String(ifStmt.getCondition())));
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    branchStack.push(new Branch(stmtLocation.getNodeOffset(), ifdefStmt.taken(), "#ifdef " + new String(ifdefStmt.getCondition())));
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    branchStack.push(new Branch(stmtLocation.getNodeOffset(), ifndefStmt.taken(), "#ifndef " + new String(ifndefStmt.getCondition())));
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    if (!branchStack.isEmpty()) {
                        branch = (Branch)branchStack.pop();
                        IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                        branchStack.push(new Branch(stmtLocation.getNodeOffset(), elseStmt.taken(), branch.fCondition));
                        branch.setEndOffset(stmtLocation.getNodeOffset());
                        branches.add(branch);
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    if (!branchStack.isEmpty()) {
                        branch = (Branch)branchStack.pop();
                        IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                        branchStack.push(new Branch(stmtLocation.getNodeOffset(), elifStmt.taken(), branch.fCondition));
                        branch.setEndOffset(stmtLocation.getNodeOffset());
                        branches.add(branch);
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement && !branchStack.isEmpty()) {
                    branch = (Branch)branchStack.pop();
                    branch.setEndOffset(stmtLocation.getNodeOffset() + stmtLocation.getNodeLength());
                    branch.setInclusive(true);
                    branches.add(branch);
                }
            }
            ++n2;
        }
        if (!branchStack.isEmpty()) {
            Branch branch = (Branch)branchStack.pop();
            branch.setEndOffset(docSize);
            branch.setInclusive(true);
            branches.add(branch);
        }
    }

    public static class Branch
    extends ModifiableRegion
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean fTaken;
        public final String fCondition;
        public boolean fInclusive;

        Branch(int offset, boolean taken, String key) {
            this(offset, 0, taken, key);
        }

        Branch(int offset, int length, boolean taken, String key) {
            super(offset, length);
            this.fTaken = taken;
            this.fCondition = key;
        }

        public void setEndOffset(int endOffset) {
            this.setLength(endOffset - this.getOffset());
        }

        public boolean taken() {
            return this.fTaken;
        }

        public void setInclusive(boolean inclusive) {
            this.fInclusive = inclusive;
        }
    }

    private static class ModifiableRegion
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int length;
        private int offset;

        ModifiableRegion() {
        }

        ModifiableRegion(int offset, int length) {
            this.setLength(length);
            this.setOffset(offset);
        }

        public void setLength(int length) {
            this.length = length;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }
    }

    public static class StatementRegion
    extends ModifiableRegion {
        public final String function;
        public int level;
        public boolean inclusive;

        public StatementRegion(String function, int level) {
            this.function = function;
            this.level = level;
        }
    }

    public final class StatementVisitor
    extends ASTVisitor {
        private final Stack<StatementRegion> fStatements;
        int fLevel;
        String fFunction;

        StatementVisitor(Stack<StatementRegion> statements) {
            this.shouldVisitStatements = true;
            this.shouldVisitDeclarations = true;
            this.fLevel = 0;
            this.fFunction = "";
            this.fStatements = statements;
            this.includeInactiveNodes = true;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public int visit(IASTStatement statement) {
            ++this.fLevel;
            if (!statement.isPartOfTranslationUnitFile()) {
                return 1;
            }
            try {
                IASTStatement switchstmt;
                if (statement instanceof IASTIfStatement) {
                    IASTIfStatement ifstmt = (IASTIfStatement)statement;
                    IASTFileLocation fl = ifstmt.getFileLocation();
                    if (fl == null) {
                        return 3;
                    }
                    int ifOffset = fl.getNodeOffset();
                    StatementRegion mr = this.createRegion();
                    IASTStatement thenStmt = ifstmt.getThenClause();
                    if (thenStmt == null) {
                        return 3;
                    }
                    fl = thenStmt.getFileLocation();
                    mr.setLength(fl.getNodeOffset() + fl.getNodeLength() - ifOffset);
                    mr.setOffset(ifOffset);
                    mr.inclusive = !(thenStmt instanceof IASTCompoundStatement);
                    IASTStatement elseStmt = ifstmt.getElseClause();
                    if (elseStmt == null) {
                        mr.inclusive = true;
                        this.fStatements.push(mr);
                        return 3;
                    }
                    IASTFileLocation elseStmtLocation = elseStmt.getFileLocation();
                    boolean bl = mr.inclusive = mr.inclusive || fl.getEndingLineNumber() < elseStmtLocation.getStartingLineNumber();
                    if (elseStmt instanceof IASTIfStatement) {
                        this.fStatements.push(mr);
                        return 3;
                    }
                    this.fStatements.push(mr);
                    mr = this.createRegion();
                    mr.setLength(elseStmtLocation.getNodeLength());
                    mr.setOffset(elseStmtLocation.getNodeOffset());
                    mr.inclusive = true;
                    this.fStatements.push(mr);
                    return 3;
                }
                StatementRegion mr = this.createRegion();
                mr.inclusive = true;
                if (statement instanceof IASTDoStatement) {
                    mr.inclusive = false;
                }
                if (statement instanceof IASTSwitchStatement && (switchstmt = ((IASTSwitchStatement)statement).getBody()) instanceof IASTCompoundStatement) {
                    IASTStatement[] stmts = ((IASTCompoundStatement)switchstmt).getStatements();
                    ArrayList<IASTStatement> list = new ArrayList<IASTStatement>();
                    IASTStatement[] iASTStatementArray = stmts;
                    int n = stmts.length;
                    int elseStmtLocation = 0;
                    while (elseStmtLocation < n) {
                        IASTStatement s = iASTStatementArray[elseStmtLocation];
                        if (s instanceof IASTCompoundStatement) {
                            IASTStatement[] ss;
                            IASTStatement[] iASTStatementArray2 = ss = ((IASTCompoundStatement)s).getStatements();
                            int n2 = ss.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                IASTStatement t = iASTStatementArray2[n3];
                                list.add(t);
                                ++n3;
                            }
                        } else {
                            list.add(s);
                        }
                        ++elseStmtLocation;
                    }
                    boolean pushedMR = false;
                    for (IASTStatement tmpstmt : list) {
                        StatementRegion tmpmr;
                        IASTFileLocation tmpfl;
                        if (!(tmpstmt instanceof IASTCaseStatement) && !(tmpstmt instanceof IASTDefaultStatement)) {
                            if (!pushedMR) {
                                return 1;
                            }
                            tmpfl = tmpstmt.getFileLocation();
                            tmpmr = this.fStatements.peek();
                            tmpmr.setLength(tmpfl.getNodeLength() + tmpfl.getNodeOffset() - tmpmr.getOffset());
                            if (!(tmpstmt instanceof IASTBreakStatement)) continue;
                            pushedMR = false;
                            continue;
                        }
                        tmpmr = this.createRegion();
                        tmpmr.level = this.fLevel + 1;
                        tmpmr.inclusive = true;
                        if (tmpstmt instanceof IASTCaseStatement) {
                            IASTCaseStatement casestmt = (IASTCaseStatement)tmpstmt;
                            tmpfl = casestmt.getExpression().getFileLocation();
                            tmpmr.setOffset(tmpfl.getNodeOffset());
                            tmpmr.setLength(tmpfl.getNodeLength());
                        } else if (tmpstmt instanceof IASTDefaultStatement) {
                            IASTDefaultStatement defstmt = (IASTDefaultStatement)tmpstmt;
                            tmpfl = defstmt.getFileLocation();
                            tmpmr.setOffset(tmpfl.getNodeOffset() + tmpfl.getNodeLength());
                            tmpmr.setLength(0);
                        }
                        this.fStatements.push(tmpmr);
                        pushedMR = true;
                    }
                }
                if (statement instanceof IASTForStatement || statement instanceof IASTWhileStatement || statement instanceof IASTDoStatement || statement instanceof IASTSwitchStatement) {
                    IASTFileLocation fl = statement.getFileLocation();
                    mr.setLength(fl.getNodeLength());
                    mr.setOffset(fl.getNodeOffset());
                    this.fStatements.push(mr);
                }
                return 3;
            }
            catch (Exception exception) {
                return 2;
            }
        }

        public int leave(IASTStatement statement) {
            --this.fLevel;
            return 3;
        }

        public int visit(IASTDeclaration declaration) {
            IASTFunctionDeclarator declarator;
            if (!declaration.isPartOfTranslationUnitFile()) {
                return 1;
            }
            if (declaration instanceof IASTFunctionDefinition && (declarator = ((IASTFunctionDefinition)declaration).getDeclarator()) != null) {
                this.fFunction = new String(ASTQueries.findInnermostDeclarator((IASTDeclarator)declarator).getName().toCharArray());
                this.fLevel = 0;
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            if (declaration instanceof IASTFunctionDefinition) {
                this.fFunction = "";
            }
            return 3;
        }

        private StatementRegion createRegion() {
            return new StatementRegion(this.fFunction, this.fLevel);
        }
    }
}

