/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.managers;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.core.jobs.IJobStatus;
import org.eclipse.ptp.core.jobs.IPJobStatus;
import org.eclipse.ptp.internal.ui.IJobManager;
import org.eclipse.ptp.internal.ui.ParallelImages;
import org.eclipse.ptp.internal.ui.listeners.IJobChangedListener;
import org.eclipse.ptp.internal.ui.managers.AbstractElementManager;
import org.eclipse.ptp.internal.ui.messages.Messages;
import org.eclipse.ptp.internal.ui.model.ElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.swt.graphics.Image;

public class JobManager
extends AbstractElementManager
implements IJobManager {
    protected Map<String, IJobStatus> jobList = new HashMap<String, IJobStatus>();
    protected IJobStatus cur_job = null;
    protected final String DEFAULT_TITLE = Messages.JobManager_0;
    private final ListenerList jobListeners = new ListenerList();

    private void addJob(IJobStatus job) {
        IPJobStatus pJob;
        if (job != null && (pJob = (IPJobStatus)job.getAdapter(IPJobStatus.class)) != null) {
            IElementSet set = this.createElementHandler(job).getSet("Root");
            int nprocs = pJob.getNumberOfProcesses();
            BitSet elements = new BitSet(nprocs);
            elements.set(0, nprocs);
            set.addElements(elements);
        }
    }

    @Override
    public void addJobChangedListener(IJobChangedListener jobListener) {
        this.jobListeners.add((Object)jobListener);
    }

    @Override
    public void clear() {
        this.jobList.clear();
        super.clear();
    }

    @Override
    public IElementHandler createElementHandler(IJobStatus job) {
        IElementHandler handler = this.getElementHandler(job.getJobId());
        if (handler == null) {
            handler = new ElementHandler();
            this.jobList.put(job.getJobId(), job);
            this.setElementHandler(job.getJobId(), handler);
        }
        return handler;
    }

    @Override
    public IJobStatus findJobById(String job_id) {
        return this.jobList.get(job_id);
    }

    @Override
    public void fireJobChangedEvent(final int type, final String cur_job_id, final String pre_job_id) {
        Object[] array;
        Object[] objectArray = array = this.jobListeners.getListeners();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final IJobChangedListener listener = (IJobChangedListener)element;
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    listener.jobChangedEvent(type, cur_job_id, pre_job_id);
                }
            });
            ++n2;
        }
    }

    @Override
    public String getFullyQualifiedName(String id) {
        if (id.equals("")) {
            return this.DEFAULT_TITLE;
        }
        IJobStatus job = this.getJob();
        if (job != null) {
            return job.getJobId();
        }
        return "";
    }

    @Override
    public Image getImage(int index, boolean isSelected) {
        IPJobStatus pJob;
        IJobStatus job = this.getJob();
        if (job != null && (pJob = (IPJobStatus)job.getAdapter(IPJobStatus.class)) != null) {
            String state = pJob.getProcessState(index);
            if (state == "RUNNING") {
                return ParallelImages.procImages[1][isSelected ? 1 : 0];
            }
            if (state == "SUSPENDED") {
                return ParallelImages.procImages[2][isSelected ? 1 : 0];
            }
            if (state == "COMPLETED") {
                return ParallelImages.procImages[3][isSelected ? 1 : 0];
            }
        }
        return null;
    }

    @Override
    public IJobStatus getJob() {
        return this.cur_job;
    }

    @Override
    public IJobStatus[] getJobs() {
        return this.jobList.values().toArray(new IJobStatus[0]);
    }

    @Override
    public String getName(String id) {
        IJobStatus job = this.findJobById(id);
        if (job == null) {
            return "";
        }
        return job.getJobId();
    }

    @Override
    public boolean hasStoppedJob() {
        IJobStatus[] iJobStatusArray = this.getJobs();
        int n = iJobStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJobStatus job = iJobStatusArray[n2];
            if (job.getState().equals("COMPLETED")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void initialize() {
        IJobStatus[] iJobStatusArray = org.eclipse.ptp.core.jobs.JobManager.getInstance().getJobs();
        int n = iJobStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJobStatus job = iJobStatusArray[n2];
            this.addJob(job);
            ++n2;
        }
        this.setCurrentSetId("Root");
    }

    public boolean isNoJob(String jid) {
        return jid == null || jid.length() == 0;
    }

    @Override
    public void removeAllCompletedJobs() {
        IJobStatus[] iJobStatusArray = this.getJobs();
        int n = iJobStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJobStatus job = iJobStatusArray[n2];
            if (job.getState().equals("COMPLETED")) {
                this.jobList.remove(job.getJobId());
            }
            ++n2;
        }
        this.fireJobChangedEvent(0, null, null);
    }

    @Override
    public void removeJobChangedListener(IJobChangedListener jobListener) {
        this.jobListeners.remove((Object)jobListener);
    }

    @Override
    public void setCurrentSetId(String set_id) {
        this.cur_set_id = set_id;
    }

    @Override
    public void setJob(IJobStatus job) {
        String old_id = null;
        if (this.cur_job != null) {
            old_id = this.cur_job.getJobId();
        }
        String new_id = null;
        if (job != null) {
            new_id = job.getJobId();
            this.addJob(job);
        }
        this.cur_job = job;
        this.fireJobChangedEvent(0, new_id, old_id);
    }

    @Override
    public void shutdown() {
        this.clear();
        super.shutdown();
    }

    @Override
    public int size() {
        return this.jobList.size();
    }
}

