/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    long targetList;
    boolean moveData = false;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static Callback DragGetData = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragGetData", 5);
    static Callback DragEnd;
    static Callback DragDataDelete;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DragSource;

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (DragGetData == null || DragEnd == null || DragDataDelete == null) {
            DND.error(2000);
        }
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        OS.g_signal_connect(control.handle, OS.drag_data_get, DragGetData.getAddress(), 0L);
        OS.g_signal_connect(control.handle, OS.drag_end, DragEnd.getAddress(), 0L);
        OS.g_signal_connect(control.handle, OS.drag_data_delete, DragDataDelete.getAddress(), 0L);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        Object effect = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (effect instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)effect;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    static long DragDataDelete(long widget, long context) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0L;
        }
        source.dragDataDelete(widget, context);
        return 0L;
    }

    static long DragEnd(long widget, long context) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0L;
        }
        source.dragEnd(widget, context);
        return 0L;
    }

    static long DragGetData(long widget, long context, long selection_data, long info, long time) {
        DragSource source = DragSource.FindDragSource(widget);
        if (source == null) {
            return 0L;
        }
        source.dragGetData(widget, context, selection_data, (int)info, (int)time);
        return 0L;
    }

    static DragSource FindDragSource(long handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData("DragSource");
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = (class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource).getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    void drag(Event dragEvent) {
        this.moveData = false;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.x = dragEvent.x;
        event.y = dragEvent.y;
        event.time = dragEvent.time;
        event.doit = true;
        this.notifyListeners(2008, event);
        if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        if (this.targetList == 0L) {
            return;
        }
        int actions = this.opToOsOp(this.getStyle());
        Image image = event.image;
        long context = OS.gtk_drag_begin(this.control.handle, this.targetList, actions, 1, 0L);
        if (context != 0L && image != null) {
            if (OS.GTK3) {
                OS.gtk_drag_set_icon_surface(context, image.surface);
            } else {
                long pixbuf = ImageList.createPixbuf(image);
                OS.gtk_drag_set_icon_pixbuf(context, pixbuf, 0, 0);
                OS.g_object_unref(pixbuf);
            }
        }
    }

    void dragEnd(long widget, long context) {
        if (OS.GTK3) {
            long display = OS.gdk_window_get_display(OS.gtk_widget_get_window(widget));
            long device_manager = OS.gdk_display_get_device_manager(display);
            long pointer = OS.gdk_device_manager_get_client_pointer(device_manager);
            long keyboard = OS.gdk_device_get_associated_device(pointer);
            OS.gdk_device_ungrab(pointer, 0);
            OS.gdk_device_ungrab(keyboard, 0);
        } else {
            OS.gdk_pointer_ungrab(0);
            OS.gdk_keyboard_ungrab(0);
        }
        int operation = 0;
        if (context != 0L) {
            long dest_window = 0L;
            int action = 0;
            if (OS.GTK3) {
                dest_window = OS.gdk_drag_context_get_dest_window(context);
                action = OS.gdk_drag_context_get_selected_action(context);
            } else {
                GdkDragContext gdkDragContext = new GdkDragContext();
                OS.memmove(gdkDragContext, context, (long)GdkDragContext.sizeof);
                dest_window = gdkDragContext.dest_window;
                action = gdkDragContext.action;
            }
            if (dest_window != 0L) {
                if (this.moveData) {
                    operation = 2;
                } else {
                    operation = this.osOpToOp(action);
                    if (operation == 2) {
                        operation = 0;
                    }
                }
            }
        }
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.doit = operation != 0;
        event.detail = operation;
        this.notifyListeners(2000, event);
        this.moveData = false;
    }

    void dragGetData(long widget, long context, long selection_data, int info, int time) {
        long target;
        long data;
        int format;
        int length;
        if (selection_data == 0L) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            length = OS.gtk_selection_data_get_length(selection_data);
            format = OS.gtk_selection_data_get_format(selection_data);
            data = OS.gtk_selection_data_get_data(selection_data);
            target = OS.gtk_selection_data_get_target(selection_data);
        } else {
            GtkSelectionData gtkSelectionData = new GtkSelectionData();
            OS.memmove(gtkSelectionData, selection_data, (long)GtkSelectionData.sizeof);
            length = gtkSelectionData.length;
            format = gtkSelectionData.format;
            data = gtkSelectionData.data;
            target = gtkSelectionData.target;
        }
        if (target == 0L) {
            return;
        }
        TransferData transferData = new TransferData();
        transferData.type = target;
        transferData.pValue = data;
        transferData.length = length;
        transferData.format = format;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = time;
        event.dataType = transferData;
        this.notifyListeners(2001, event);
        if (!event.doit) {
            return;
        }
        Transfer transfer = null;
        for (int i = 0; i < this.transferAgents.length; ++i) {
            Transfer transferAgent = this.transferAgents[i];
            if (transferAgent == null || !transferAgent.isSupportedType(transferData)) continue;
            transfer = transferAgent;
            break;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(event.data, transferData);
        if (transferData.result != 1) {
            return;
        }
        OS.gtk_selection_data_set(selection_data, transferData.type, transferData.format, transferData.pValue, transferData.length);
        OS.g_free(transferData.pValue);
    }

    void dragDataDelete(long widget, long context) {
        this.moveData = true;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listeners = this.getListeners(2008);
        int length = listeners.length;
        DragSourceListener[] dragListeners = new DragSourceListener[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            Listener listener = listeners[i];
            if (!(listener instanceof DNDListener)) continue;
            dragListeners[count] = (DragSourceListener)((DNDListener)listener).getEventListener();
            ++count;
        }
        if (count == length) {
            return dragListeners;
        }
        DragSourceListener[] result = new DragSourceListener[count];
        System.arraycopy(dragListeners, 0, result, 0, count);
        return result;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.targetList != 0L) {
            OS.gtk_target_list_unref(this.targetList);
        }
        this.targetList = 0L;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation |= 2;
        }
        if ((operation & 2) == 2) {
            osOperation |= 4;
        }
        if ((operation & 4) == 4) {
            osOperation |= 8;
        }
        return osOperation;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 4) == 4) {
            operation |= 2;
        }
        if ((osOperation & 8) == 8) {
            operation |= 4;
        }
        return operation;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setDragSourceEffect(DragSourceEffect effect) {
        this.dragEffect = effect;
    }

    public void setTransfer(Transfer[] transferAgents) {
        int i;
        if (this.targetList != 0L) {
            OS.gtk_target_list_unref(this.targetList);
            this.targetList = 0L;
        }
        this.transferAgents = transferAgents;
        if (transferAgents == null || transferAgents.length == 0) {
            return;
        }
        GtkTargetEntry[] targets = new GtkTargetEntry[]{};
        for (int i2 = 0; i2 < transferAgents.length; ++i2) {
            Transfer transfer = transferAgents[i2];
            if (transfer == null) continue;
            int[] typeIds = transfer.getTypeIds();
            String[] typeNames = transfer.getTypeNames();
            for (int j = 0; j < typeIds.length; ++j) {
                GtkTargetEntry entry = new GtkTargetEntry();
                byte[] buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                entry.target = OS.g_malloc(buffer.length);
                OS.memmove(entry.target, buffer, (long)buffer.length);
                entry.info = typeIds[j];
                GtkTargetEntry[] newTargets = new GtkTargetEntry[targets.length + 1];
                System.arraycopy(targets, 0, newTargets, 0, targets.length);
                newTargets[targets.length] = entry;
                targets = newTargets;
            }
        }
        long pTargets = OS.g_malloc(targets.length * GtkTargetEntry.sizeof);
        for (i = 0; i < targets.length; ++i) {
            OS.memmove(pTargets + (long)(i * GtkTargetEntry.sizeof), targets[i], (long)GtkTargetEntry.sizeof);
        }
        this.targetList = OS.gtk_target_list_new(pTargets, targets.length);
        for (i = 0; i < targets.length; ++i) {
            OS.g_free(targets[i].target);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (DragGetData.getAddress() == 0L) {
            SWT.error(3);
        }
        if ((DragEnd = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragEnd", 2)).getAddress() == 0L) {
            SWT.error(3);
        }
        if ((DragDataDelete = new Callback(class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource, "DragDataDelete", 2)).getAddress() == 0L) {
            SWT.error(3);
        }
    }
}

