/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.ui.views;

import java.io.File;
import java.net.URL;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ptp.internal.ui.hover.IIconInformationControl;
import org.eclipse.ptp.internal.ui.hover.IconHover;
import org.eclipse.ptp.internal.ui.views.IContentProvider;
import org.eclipse.ptp.internal.ui.views.IIconCanvasActionListener;
import org.eclipse.ptp.internal.ui.views.IImageProvider;
import org.eclipse.ptp.internal.ui.views.IToolTipProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class IconCanvas
extends Canvas {
    public static final int SE = 1;
    public static final int SW = 2;
    public static final int NW = 3;
    public static final int NE = 4;
    protected ListenerList actionListeners = new ListenerList();
    protected IToolTipProvider toolTipProvider = null;
    protected IImageProvider imageProvider = null;
    protected IContentProvider contentProvider = null;
    protected int e_offset_x = 5;
    protected int e_offset_y = 5;
    protected int e_spacing_x = 4;
    protected int e_spacing_y = 4;
    protected int e_width = 16;
    protected int e_height = 16;
    protected int max_e_row = -1;
    protected int max_e_col = -1;
    protected Hashtable<Integer, Integer> keyActionMap = new Hashtable();
    protected Listener listener = null;
    protected boolean mouseDown = false;
    protected boolean mouseDoubleClick = false;
    protected int firstSelectedIndex = -1;
    protected int secondSelectedIndex = -1;
    protected BitSet selectedElements = new BitSet();
    protected BitSet tempSelectedElements = new BitSet();
    protected int sel_size = 1;
    protected final int sel_length = 2;
    protected final int sel_gap = 2;
    protected Color sel_color = null;
    protected Point selection = null;
    protected Point movingSelectionStart = null;
    protected Point movingSelectionEnd = null;
    protected int current_top_row = -1;
    protected int actualScrollStart_y = 0;
    protected int autoScrollDirection = 0;
    protected int verticalScrollOffset = 0;
    protected Cursor defaultCursor = null;
    protected Color background = null;
    protected Color foreground = null;
    protected final int DEFAULT_FONT_SIZE = 9;
    protected int font_size = 9;
    protected final int margin_text = 2;
    protected Color margin_color = null;
    protected boolean displayRuler = true;
    private final int DEFAULT_OFFSET = 5;
    private final IconHover iconHover = new IconHover();
    protected IIconInformationControl fInformationControl = null;
    protected long tooltip_timeout = 10000L;
    protected boolean show_tooltip_allthetime = false;
    private Timer hoverTimer = null;
    protected boolean tooltip_wrap = true;
    protected boolean show_tooltip = true;
    protected int total_elements = 0;
    static final boolean IS_CARBON;
    static final boolean IS_GTK;
    static final boolean IS_MOTIF;
    static final boolean DOUBLE_BUFFER;

    static {
        String platform = SWT.getPlatform();
        IS_CARBON = "carbon".equals(platform);
        IS_GTK = "gtk".equals(platform);
        IS_MOTIF = "motif".equals(platform);
        DOUBLE_BUFFER = !IS_CARBON;
    }

    public IconCanvas(Composite parent, int style) {
        super(parent, 0x242 | style);
        Display display = this.getDisplay();
        this.calculateVerticalScrollBar();
        this.createKeyBindings();
        this.defaultCursor = new Cursor((Device)display, 0);
        this.setCursor(this.defaultCursor);
        this.installListeners();
        this.initializeAccessible();
        this.sel_color = display.getSystemColor(3);
        this.margin_color = display.getSystemColor(22);
        this.changeFontSize(display);
        super.setBackground(this.getBackground());
        super.setForeground(this.getForeground());
    }

    public void dispose() {
        if (this.fInformationControl != null) {
            this.fInformationControl.dispose();
        }
        super.dispose();
    }

    private void changeFontSize(Display display) {
        FontData[] data;
        FontData[] fontDataArray = data = this.getFont().getFontData();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setHeight(this.font_size);
            ++n2;
        }
        this.setFont(new Font((Device)display, data));
    }

    public void addActionListener(IIconCanvasActionListener actionListener) {
        this.actionListeners.add((Object)actionListener);
    }

    public void removeActionListener(IIconCanvasActionListener actionListener) {
        this.actionListeners.remove((Object)actionListener);
    }

    protected void fireAction(final int type) {
        Object[] array;
        Object[] objectArray = array = this.actionListeners.getListeners();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            final IIconCanvasActionListener l = (IIconCanvasActionListener)element;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.handleAction(type, IconCanvas.this.getSelectedElements());
                }
            });
            ++n2;
        }
    }

    protected void fireAction(final int type, final int index) {
        if (index > -1) {
            Object[] array;
            Object[] objectArray = array = this.actionListeners.getListeners();
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                final IIconCanvasActionListener l = (IIconCanvasActionListener)element;
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        l.handleAction(type, index);
                    }
                });
                ++n2;
            }
        }
    }

    public void resetCanvas() {
        this.checkWidget();
        this.current_top_row = -1;
        this.actualScrollStart_y = 0;
        this.autoScrollDirection = 0;
        this.verticalScrollOffset = 0;
        this.unselectAllElements();
        this.firstSelectedIndex = -1;
        this.secondSelectedIndex = -1;
        this.selection = null;
        this.resetMargin();
        this.resetInfo();
        this.getVerticalBar().setSelection(0);
        this.calculateVerticalScrollBar();
        this.redraw();
    }

    public IToolTipProvider getToolTipProvider() {
        return this.toolTipProvider;
    }

    public void setToolTipProvider(IToolTipProvider toolTipProvider) {
        this.toolTipProvider = toolTipProvider;
    }

    public void setShowTooltip(boolean show) {
        this.show_tooltip = show;
    }

    public IImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public void setImageProvider(IImageProvider imageProvider) {
        this.imageProvider = imageProvider;
    }

    public IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setTotal(int total) {
        if (total < 0) {
            SWT.error((int)4);
        }
        this.total_elements = total;
        this.resetCanvas();
    }

    private void resetMargin() {
        this.e_offset_x = 5;
        if (this.isDisplayRuler()) {
            GC newGC = this.getGC();
            newGC.setFont(this.getFont());
            if (this.total_elements > 0 && this.contentProvider.hasElement(this.total_elements - 1)) {
                String text = String.valueOf(this.total_elements - 1);
                this.e_offset_x = newGC.stringExtent((String)text).x + this.e_spacing_x + 2;
            }
            newGC.dispose();
        }
    }

    public void setFontSizeSmaller() {
        this.setFontSize(this.font_size - 1);
    }

    public void setFontSizeBigger() {
        this.setFontSize(this.font_size + 1);
    }

    public void setFontSize(int fontSize) {
        if (fontSize < 5) {
            SWT.error((int)4);
        }
        this.font_size = fontSize;
        this.changeFontSize(this.getDisplay());
    }

    public void setIconSpace(int e_spacing_x, int e_spacing_y) {
        if (e_spacing_x < 0 || e_spacing_y < 0) {
            SWT.error((int)4);
        }
        this.e_spacing_x = e_spacing_x;
        this.e_spacing_y = e_spacing_y;
    }

    public void setIconSize(int e_width, int e_height) {
        if (e_width <= 0 || e_height <= 0) {
            SWT.error((int)4);
        }
        this.e_height = e_height;
        this.e_width = e_width;
    }

    public void setTooltip(boolean showAllTime, long timeout, boolean isWrap) {
        this.showTooltipAllthetime(showAllTime);
        this.setTooltipTimeout(timeout);
        this.setTooltipWrap(isWrap);
    }

    public void setTooltipTimeout(long timeout) {
        if (timeout <= 0L) {
            SWT.error((int)4);
        }
        this.tooltip_timeout = timeout;
    }

    public void showTooltipAllthetime(boolean isAll) {
        this.show_tooltip_allthetime = isAll;
    }

    public void setTooltipWrap(boolean isWrap) {
        this.tooltip_wrap = isWrap;
    }

    public int getTotalElements() {
        return this.total_elements;
    }

    public void setSelectionSize(int size) {
        this.sel_size = size;
    }

    public void setSelectionColor(int colorIndex) {
        this.checkWidget();
        this.sel_color = this.getDisplay().getSystemColor(colorIndex);
    }

    public void setDisplayRuler(boolean displayRuler) {
        this.displayRuler = displayRuler;
        this.resetCanvas();
    }

    public boolean isDisplayRuler() {
        return this.displayRuler;
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.background == null) {
            return this.getDisplay().getSystemColor(25);
        }
        return this.background;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        this.background = color;
        super.setBackground(this.getBackground());
        this.redraw();
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            return this.getDisplay().getSystemColor(24);
        }
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        this.foreground = color;
        super.setForeground(this.getForeground());
        this.redraw();
    }

    protected int getElementHeight() {
        return this.e_spacing_y + this.e_height;
    }

    protected int getElementWidth() {
        return this.e_spacing_x + this.e_width;
    }

    protected int getMaxCol() {
        if (this.max_e_col == -1) {
            int width = this.getClientArea().width - this.getVerticalBar().getSize().x;
            this.max_e_col = Math.max(0, (width - this.e_offset_x) / this.getElementWidth() + 1);
        }
        return this.max_e_col;
    }

    protected int getMaxClientRow() {
        return (this.getClientArea().height - this.e_offset_y) / this.getElementHeight();
    }

    protected int getMaxRow() {
        if (this.max_e_row == -1) {
            int total = this.getTotalElements();
            if (total == 0) {
                return 0;
            }
            int max_col = this.getMaxCol();
            if (max_col == 0) {
                return 0;
            }
            int max_row = total / max_col;
            this.max_e_row = total % max_col == 0 ? max_row : max_row + 1;
        }
        return this.max_e_row;
    }

    protected int getMaxHeight() {
        return this.getMaxRow() * this.getElementHeight();
    }

    protected int getVerticalIncrement() {
        return this.e_spacing_y + this.e_height;
    }

    protected void calculateVerticalScrollBar() {
        this.setVerticalScrollBar(this.getVerticalBar());
    }

    protected void setVerticalScrollBar(ScrollBar verticalBar) {
        if (verticalBar != null) {
            Rectangle clientArea = this.getClientArea();
            int max_height = this.getMaxHeight() + this.e_offset_y + this.sel_size;
            if (clientArea.height < max_height) {
                verticalBar.setValues(verticalBar.getSelection(), verticalBar.getMinimum(), max_height, clientArea.height, this.getVerticalIncrement(), clientArea.height);
            } else if (verticalBar.getThumb() != 1 || verticalBar.getMaximum() != 1) {
                verticalBar.setValues(verticalBar.getSelection(), verticalBar.getMinimum(), 1, 1, this.getVerticalIncrement(), 1);
            }
        }
    }

    protected boolean claimBottomFreeSpace() {
        int newVerticalOffset = Math.max(0, this.getMaxHeight() - this.getClientArea().height);
        if (newVerticalOffset < this.verticalScrollOffset) {
            return this.setVerticalScrollOffset(newVerticalOffset, true);
        }
        return false;
    }

    protected int getCurrentTopRow() {
        return this.current_top_row;
    }

    public int getKeyBinding(int key) {
        this.checkWidget();
        Integer action = this.keyActionMap.get(new Integer(key));
        int intAction = action == null ? 0 : action;
        return intAction;
    }

    public void setKeyBinding(int key, int action) {
        this.checkWidget();
        int keyValue = key & 0x100FFFF;
        int modifierValue = key & SWT.MODIFIER_MASK;
        char keyChar = (char)keyValue;
        if (Character.isLetter(keyChar)) {
            char ch = Character.toUpperCase(keyChar);
            int newKey = ch | modifierValue;
            if (action == 0) {
                this.keyActionMap.remove(new Integer(newKey));
            } else {
                this.keyActionMap.put(new Integer(newKey), new Integer(action));
            }
            ch = Character.toLowerCase(keyChar);
            newKey = ch | modifierValue;
            if (action == 0) {
                this.keyActionMap.remove(new Integer(newKey));
            } else {
                this.keyActionMap.put(new Integer(newKey), new Integer(action));
            }
        } else if (action == 0) {
            this.keyActionMap.remove(new Integer(key));
        } else {
            this.keyActionMap.put(new Integer(key), new Integer(action));
        }
    }

    protected void createKeyBindings() {
        this.setKeyBinding(0x1000001, 0x1000001);
        this.setKeyBinding(0x1000002, 0x1000002);
        this.setKeyBinding(0x1000003, 0x1000003);
        this.setKeyBinding(0x1000004, 0x1000004);
        this.setKeyBinding(0x1000007, 0x1000007);
        this.setKeyBinding(0x1000008, 0x1000008);
        this.setKeyBinding(0x1000005, 0x1000005);
        this.setKeyBinding(0x1000006, 0x1000006);
        this.setKeyBinding(0x41 | SWT.MOD1, 262209);
        this.setKeyBinding(0x1000001 | SWT.MOD2, 0x1020001);
        this.setKeyBinding(0x1000002 | SWT.MOD2, 0x1020002);
        this.setKeyBinding(0x1000003 | SWT.MOD2, 16908291);
        this.setKeyBinding(0x1000004 | SWT.MOD2, 16908292);
        this.setKeyBinding(0x1000007 | SWT.MOD2, 16908295);
        this.setKeyBinding(0x1000008 | SWT.MOD2, 16908296);
        this.setKeyBinding(0x1000005 | SWT.MOD2, 16908293);
        this.setKeyBinding(0x1000006 | SWT.MOD2, 16908294);
        this.setKeyBinding(0x58 | SWT.MOD1, 131199);
        this.setKeyBinding(0x43 | SWT.MOD1, 17039369);
        this.setKeyBinding(0x56 | SWT.MOD1, 16908297);
        this.setKeyBinding(8, 8);
        this.setKeyBinding(127, 127);
    }

    public void invokeAction(int action) {
        this.checkWidget();
        switch (action) {
            case 0x1000001: {
                this.doUp(false);
                break;
            }
            case 0x1000002: {
                this.doDown(false);
                break;
            }
            case 0x1000003: {
                this.doPrevious(false);
                break;
            }
            case 0x1000004: {
                this.doNext(false);
                break;
            }
            case 0x1000007: {
                this.doLineStart(false);
                break;
            }
            case 0x1000008: {
                this.doLineEnd(false);
                break;
            }
            case 0x1000005: {
                this.doPageUp(this.getMaxClientRow());
                break;
            }
            case 0x1000006: {
                this.doPageDown(this.getMaxClientRow());
                break;
            }
            case 262209: {
                this.doSelectionAll();
                break;
            }
            case 0x1020001: {
                this.doUp(true);
                break;
            }
            case 0x1020002: {
                this.doDown(true);
                break;
            }
            case 16908291: {
                this.doPrevious(true);
                break;
            }
            case 16908292: {
                this.doNext(true);
                break;
            }
            case 16908295: {
                this.doLineStart(true);
                break;
            }
            case 16908296: {
                this.doLineEnd(true);
                break;
            }
            case 16908293: {
                this.doSelectionPageUp(this.getMaxClientRow());
                break;
            }
            case 16908294: {
                this.doSelectionPageDown(this.getMaxClientRow());
                break;
            }
            case 131199: {
                this.doCut();
                break;
            }
            case 17039369: {
                this.doCopy();
                break;
            }
            case 16908297: {
                this.doPaste();
                break;
            }
            case 8: {
                this.doDelete();
                break;
            }
            case 127: {
                this.doDelete();
                break;
            }
        }
    }

    protected void initializeAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getHelp(AccessibleEvent e) {
                e.result = IconCanvas.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 42;
            }

            public void getState(AccessibleControlEvent e) {
                int state = 0;
                if (IconCanvas.this.isEnabled()) {
                    state |= 0x100000;
                }
                if (IconCanvas.this.isFocusControl()) {
                    state |= 4;
                }
                if (!IconCanvas.this.isVisible()) {
                    state |= 0x8000;
                }
                e.detail = state;
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    protected void installListeners() {
        ScrollBar verticalBar = this.getVerticalBar();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        IconCanvas.this.handleDispose(event);
                        break;
                    }
                    case 1: {
                        IconCanvas.this.handleKeyDown(event);
                        break;
                    }
                    case 2: {
                        IconCanvas.this.handleKeyUp(event);
                        break;
                    }
                    case 3: {
                        IconCanvas.this.handleMouseDown(event);
                        break;
                    }
                    case 4: {
                        IconCanvas.this.handleMouseUp(event);
                        break;
                    }
                    case 8: {
                        IconCanvas.this.handleMouseDoubleClick(event);
                        break;
                    }
                    case 5: {
                        IconCanvas.this.handleMouseMove(event);
                        break;
                    }
                    case 32: {
                        IconCanvas.this.handleMouseHover(event);
                        break;
                    }
                    case 9: {
                        IconCanvas.this.handlePaint(event);
                        break;
                    }
                    case 11: {
                        IconCanvas.this.handleResize(event);
                        break;
                    }
                    case 16: {
                        IconCanvas.this.handleFocusOut(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.addListener(1, this.listener);
        this.addListener(2, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(8, this.listener);
        this.addListener(5, this.listener);
        this.addListener(32, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(16, this.listener);
        if (verticalBar != null) {
            verticalBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    IconCanvas.this.setVerticalScrollOffset(IconCanvas.this.getVerticalBar().getSelection(), true);
                }
            });
        }
    }

    protected void handleKey(Event event) {
        int action;
        if (event.keyCode != 0) {
            action = this.getKeyBinding(event.keyCode | event.stateMask);
        } else {
            action = this.getKeyBinding(event.character | event.stateMask);
            if (action == 0 && (event.stateMask & 0x40000) != 0 && event.character >= '\u0000' && event.character <= '\u001f') {
                int c = event.character + 64;
                action = this.getKeyBinding(c | event.stateMask);
            }
        }
        if (action != 0) {
            this.invokeAction(action);
        }
    }

    protected boolean isReachTop() {
        return this.verticalScrollOffset <= 0;
    }

    protected boolean isReachBottom() {
        return this.getMaxRow() - this.current_top_row <= this.getMaxClientRow();
    }

    protected void doAutoScroll(int x_loc, int y_loc) {
        if (y_loc > this.getClientArea().height && !this.isReachBottom()) {
            this.hideToolTip();
            this.doAutoScroll(1024, this.getVerticalIncrement(), x_loc, y_loc);
        } else if (y_loc < 0 && !this.isReachTop()) {
            this.hideToolTip();
            this.doAutoScroll(128, -this.getVerticalIncrement(), x_loc, y_loc);
        } else {
            if (this.movingSelectionStart == null) {
                this.movingSelectionStart = new Point(this.selection.x, this.selection.y);
            } else {
                this.doMouseSelection(this.movingSelectionStart.x, this.movingSelectionStart.y, x_loc, y_loc, false);
            }
            this.endAutoScroll();
        }
    }

    protected void doAutoScroll(int direction, final int distance, final int x_loc, final int y_loc) {
        if (this.autoScrollDirection == direction) {
            return;
        }
        Runnable timer = null;
        final Display display = this.getDisplay();
        if (direction == 128) {
            timer = new Runnable(){

                @Override
                public void run() {
                    if (IconCanvas.this.autoScrollDirection == 128 && !IconCanvas.this.isReachTop()) {
                        IconCanvas.this.doSelectionPageUp(distance, x_loc, y_loc, true);
                        display.timerExec(50, (Runnable)this);
                    }
                }
            };
        } else if (direction == 1024) {
            timer = new Runnable(){

                @Override
                public void run() {
                    if (IconCanvas.this.autoScrollDirection == 1024 && !IconCanvas.this.isReachBottom()) {
                        IconCanvas.this.doSelectionPageDown(distance, x_loc, y_loc, true);
                        display.timerExec(50, (Runnable)this);
                    }
                }
            };
        }
        if (timer != null) {
            this.autoScrollDirection = direction;
            display.timerExec(50, timer);
        }
    }

    protected void doSelectionPageUp(int distance) {
        int index;
        int n = index = this.selection == null ? -1 : this.findSelectedIndexByLocation(this.selection.x, this.actualScrollStart_y - this.verticalScrollOffset, false);
        if (index > 0) {
            int max_col = this.getMaxCol();
            int max_row = this.getMaxClientRow() - 1;
            int total_in_page = max_col * max_row;
            int start_index = Math.max(0, index - total_in_page);
            this.actualScrollStart_y -= max_row * this.getElementHeight();
            if (this.actualScrollStart_y - this.verticalScrollOffset < 0) {
                this.doPageUp(max_row);
            }
            this.selection.y = Math.max(0, this.actualScrollStart_y - this.verticalScrollOffset);
            this.selectElements(start_index, index);
            this.redraw(start_index, index);
        }
    }

    protected void doSelectionPageDown(int distance) {
        int index;
        int n = index = this.selection == null ? -1 : this.findSelectedIndexByLocation(this.selection.x, this.actualScrollStart_y - this.verticalScrollOffset, false);
        if (index > -1) {
            int max_col = this.getMaxCol();
            int max_row = this.getMaxClientRow() - 1;
            int total_in_page = max_col * max_row;
            int end_index = Math.min(this.getTotalElements(), index + total_in_page);
            this.actualScrollStart_y += max_row * this.getElementHeight();
            if (this.actualScrollStart_y - this.verticalScrollOffset > (max_row + 1) * this.getElementHeight()) {
                this.doPageDown(max_row);
            }
            this.selection.y = Math.max(0, this.actualScrollStart_y - this.verticalScrollOffset);
            this.selectElements(index, end_index);
            this.redraw(index, end_index);
        }
    }

    protected void doSelectionPageUp(int distance, int x_loc, int y_loc, boolean isSelect) {
        this.doPageUp(distance / this.getElementHeight());
        if (this.movingSelectionStart != null && isSelect) {
            this.movingSelectionStart.y += this.getVerticalIncrement();
            this.doMouseSelection(this.movingSelectionStart.x, this.movingSelectionStart.y, x_loc, y_loc, true);
        }
    }

    protected void doSelectionPageDown(int distance, int x_loc, int y_loc, boolean isSelect) {
        this.doPageDown(distance / this.getElementHeight());
        if (this.movingSelectionStart != null && isSelect) {
            this.movingSelectionStart.y -= this.getVerticalIncrement();
            this.doMouseSelection(this.movingSelectionStart.x, this.movingSelectionStart.y, x_loc, y_loc, true);
        }
    }

    protected void doDelete() {
        this.fireAction(4);
    }

    protected void doCopy() {
        this.fireAction(1);
    }

    protected void doCut() {
        this.fireAction(2);
    }

    protected void doPaste() {
        this.fireAction(3);
    }

    protected void doPageUp(int rows) {
        if (this.current_top_row >= 0 && this.verticalScrollOffset > 0) {
            int scrollOffset;
            int scrollRows = Math.max(1, Math.min(this.current_top_row, rows));
            this.current_top_row -= scrollRows;
            if (this.current_top_row < 0) {
                this.current_top_row = 0;
            }
            if ((scrollOffset = Math.max(0, this.verticalScrollOffset - scrollRows * this.getVerticalIncrement())) < this.verticalScrollOffset) {
                this.setVerticalScrollOffset(scrollOffset, true);
            }
        }
    }

    protected void doPageDown(int rows) {
        int max_client_row;
        int max_row = this.getMaxRow();
        if (this.current_top_row < max_row - (max_client_row = this.getMaxClientRow())) {
            int scrollRows = Math.max(1, Math.min(max_row - this.current_top_row - max_client_row, rows));
            this.current_top_row += scrollRows;
            int scrollOffset = Math.min(this.verticalScrollOffset + scrollRows * this.getVerticalIncrement(), (max_row - max_client_row) * this.getElementHeight());
            if (scrollOffset > this.verticalScrollOffset) {
                this.setVerticalScrollOffset(scrollOffset, true);
            }
        }
    }

    protected void doUp(boolean isSelect) {
        int max_col;
        int index;
        int n = index = this.selection == null ? -1 : this.findSelectedIndexByLocation(this.selection.x, this.actualScrollStart_y - this.verticalScrollOffset, false);
        if (index > 0 && index - (max_col = this.getMaxCol()) > -1) {
            boolean redrawAll;
            this.actualScrollStart_y -= this.getElementHeight();
            if (this.selection.y < this.getVerticalIncrement()) {
                this.doPageUp(1);
            }
            this.selection.y = this.actualScrollStart_y - this.verticalScrollOffset;
            boolean bl = redrawAll = !this.selectedElements.isEmpty();
            if (!isSelect) {
                this.unselectAllElements();
                this.selectedElements.set(index - max_col);
            } else if (!this.isSelected(index - max_col)) {
                this.selectElements(index - max_col, index);
            } else {
                this.unselectElements(index - max_col + 1, index);
            }
            if (redrawAll) {
                this.redraw();
            } else {
                this.redraw(index - max_col, index);
            }
        }
    }

    protected void doDown(boolean isSelect) {
        int max_col;
        int index;
        int n = index = this.selection == null ? -1 : this.findSelectedIndexByLocation(this.selection.x, this.actualScrollStart_y - this.verticalScrollOffset, false);
        if (index > -1 && index + (max_col = this.getMaxCol()) < this.getTotalElements()) {
            boolean redrawAll;
            this.actualScrollStart_y += this.getElementHeight();
            if (this.selection.y + this.getVerticalIncrement() > this.getMaxClientRow() * this.getElementHeight()) {
                this.doPageDown(1);
            }
            this.selection.y = this.actualScrollStart_y - this.verticalScrollOffset;
            boolean bl = redrawAll = !this.selectedElements.isEmpty();
            if (!isSelect) {
                this.unselectAllElements();
                this.selectedElements.set(index + max_col);
            } else if (!this.isSelected(index + max_col)) {
                this.selectElements(index, index + max_col);
            } else {
                this.unselectElements(index, index + max_col - 1);
            }
            if (redrawAll) {
                this.redraw();
            } else {
                this.redraw(index, index + max_col);
            }
        }
    }

    protected void doPrevious(boolean isSelect) {
        int index;
        int n = index = this.selection == null ? -1 : this.findSelectedIndexByLocation(this.selection.x, this.actualScrollStart_y - this.verticalScrollOffset, false);
        if (index > 0) {
            boolean redrawAll;
            this.selection.x -= this.getElementWidth();
            if (this.selection.x < this.e_offset_x) {
                this.actualScrollStart_y -= this.getElementHeight();
                if (this.actualScrollStart_y - this.verticalScrollOffset < this.getVerticalIncrement()) {
                    this.doPageUp(1);
                }
                this.selection.x = this.e_offset_x + this.getMaxCol() * this.getElementWidth() - this.e_width;
                this.selection.y = this.actualScrollStart_y - this.verticalScrollOffset;
            }
            boolean bl = redrawAll = !this.selectedElements.isEmpty();
            if (!isSelect) {
                this.unselectAllElements();
            }
            if (!this.isSelected(index - 1)) {
                this.autoSelectUnselectElement(index - 1);
            } else {
                this.selectedElements.clear(index);
            }
            if (redrawAll) {
                this.redraw();
            } else {
                this.redraw(index - 1, index);
            }
        }
    }

    protected void doNext(boolean isSelect) {
        int index;
        int n = index = this.selection == null ? -1 : this.findSelectedIndexByLocation(this.selection.x, this.actualScrollStart_y - this.verticalScrollOffset, false);
        if (index > -1 && index < this.getTotalElements() - 1) {
            boolean redrawAll;
            this.selection.x += this.getElementWidth();
            if (this.selection.x > this.getMaxCol() * this.getElementWidth() + this.e_offset_x) {
                this.actualScrollStart_y += this.getElementHeight();
                if (this.selection.y + this.getVerticalIncrement() > this.getMaxClientRow() * this.getElementHeight()) {
                    this.doPageDown(1);
                }
                this.selection.x = this.e_offset_x + this.e_spacing_x;
                this.selection.y = this.actualScrollStart_y - this.verticalScrollOffset;
            }
            boolean bl = redrawAll = !this.selectedElements.isEmpty();
            if (!isSelect) {
                this.unselectAllElements();
            }
            if (!this.isSelected(index + 1)) {
                this.autoSelectUnselectElement(index + 1);
            } else {
                this.selectedElements.clear(index);
            }
            if (redrawAll) {
                this.redraw();
            } else {
                this.redraw(index, index + 1);
            }
        }
    }

    protected void doLineStart(boolean isSelect) {
        int start_pos_x;
        int start_index;
        int index;
        int n = index = this.selection == null ? -1 : this.findSelectedIndexByLocation(this.selection.x, this.actualScrollStart_y - this.verticalScrollOffset, false);
        if (index > -1 && (start_index = this.findSelectedIndexByLocation(start_pos_x = this.e_offset_x + this.e_spacing_x, this.actualScrollStart_y - this.verticalScrollOffset, false)) > -1) {
            this.selection.x = start_pos_x;
            if (!isSelect) {
                this.selectedElements.clear(index);
                this.autoSelectUnselectElement(start_index);
            } else {
                this.selectElements(start_index, index);
            }
            this.redraw(start_index, index);
        }
    }

    protected void doLineEnd(boolean isSelect) {
        int index;
        int n = index = this.selection == null ? -1 : this.findSelectedIndexByLocation(this.selection.x, this.actualScrollStart_y - this.verticalScrollOffset, false);
        if (index > -1) {
            int total;
            if (!isSelect) {
                this.selectedElements.clear(index);
            }
            if (index > (total = this.getTotalElements() - 1) - this.getMaxCol()) {
                int end_counter = total - index;
                this.selection.x = (end_counter + 1) * this.getElementWidth() + this.e_offset_x;
                if (!isSelect) {
                    this.autoSelectUnselectElement(index + end_counter);
                } else {
                    this.selectElements(index, index + end_counter);
                }
                this.redraw(index, index + end_counter);
            } else {
                int end_pos_x = this.e_offset_x + this.getMaxCol() * this.getElementWidth() - this.e_width;
                int end_index = this.findSelectedIndexByLocation(end_pos_x, this.actualScrollStart_y - this.verticalScrollOffset, false);
                if (end_index > -1) {
                    this.selection.x = end_pos_x;
                    if (!isSelect) {
                        this.autoSelectUnselectElement(end_index);
                    } else {
                        this.selectElements(index, end_index);
                    }
                    this.redraw(index, end_index);
                } else {
                    this.redraw(index, index);
                }
            }
        }
    }

    protected void doSelectionAll() {
        this.selectedElements.set(0, this.getTotalElements());
        this.redraw();
    }

    protected boolean setVerticalScrollOffset(int pixelOffset, boolean adjustScrollBar) {
        if (pixelOffset == this.verticalScrollOffset) {
            return false;
        }
        ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null && adjustScrollBar) {
            verticalBar.setSelection(pixelOffset);
        }
        Rectangle clientArea = this.getClientArea();
        this.scroll(0, 0, 0, pixelOffset - this.verticalScrollOffset, clientArea.width, clientArea.height, adjustScrollBar);
        this.verticalScrollOffset = pixelOffset;
        this.calculateTopIndex();
        return true;
    }

    protected void endAutoScroll() {
        this.autoScrollDirection = 0;
    }

    protected void calculateTopIndex() {
        int verticalIncrement = this.getVerticalIncrement();
        if (verticalIncrement == 0) {
            return;
        }
        this.current_top_row = this.verticalScrollOffset / verticalIncrement;
        if (this.current_top_row > 0) {
            int max_row = this.getMaxRow();
            int clientAreaHeight = this.getClientArea().height;
            if (clientAreaHeight > 0) {
                int fullRowTopPixel = this.current_top_row * verticalIncrement;
                if (this.verticalScrollOffset < fullRowTopPixel) {
                    --this.current_top_row;
                }
            } else if (this.current_top_row >= max_row) {
                this.current_top_row = max_row - 1;
            }
        }
    }

    protected int getSelectedCol(int x_loc, boolean isApproximate) {
        int col = Math.min(x_loc / this.getElementWidth(), this.getMaxCol() - 1);
        if (isApproximate) {
            return col;
        }
        int test_loc_x = this.getElementWidth() * col;
        if (x_loc > test_loc_x && x_loc < test_loc_x + this.e_width) {
            return col;
        }
        return -1;
    }

    protected int getSelectedRow(int y_loc, boolean isApproximate) {
        int row = Math.max(0, (this.verticalScrollOffset + y_loc) / this.getElementHeight());
        if (isApproximate) {
            return row;
        }
        int test_loc_y = this.getElementHeight() * row - this.verticalScrollOffset;
        if (y_loc > test_loc_y && y_loc < test_loc_y + this.e_height) {
            return row;
        }
        return -1;
    }

    protected int findSelectedIndex(int row, int col) {
        return row * this.getMaxCol() + col;
    }

    protected int findSelectedIndexByLocation(int loc_x, int loc_y, boolean isApproximate) {
        int index;
        int row;
        int col = this.getSelectedCol(loc_x - this.e_offset_x, isApproximate);
        if (col > -1 && (row = this.getSelectedRow(loc_y - this.e_offset_y, isApproximate)) > -1 && (index = this.findSelectedIndex(row, col)) < this.getTotalElements()) {
            return index;
        }
        return -1;
    }

    protected Point findSection(int index) {
        int max_col = this.getMaxCol();
        int col = (int)Math.floor(index % max_col);
        int row = (int)Math.floor(index / max_col);
        return new Point(col, row);
    }

    protected Point findLocation(int index) {
        Point section = this.findSection(index);
        int x_loc = section.x * this.getElementWidth() + this.e_offset_x + 1;
        int y_loc = section.y * this.getElementHeight() + this.e_offset_y + 1 - this.verticalScrollOffset;
        return new Point(x_loc, y_loc);
    }

    protected int getDirection(int s_x, int s_y, int e_x, int e_y) {
        int direction = 1;
        if (s_x > e_x) {
            direction = 2;
        }
        if (s_y > e_y) {
            direction = direction == 2 ? 3 : 4;
        }
        return direction;
    }

    protected BitSet selectElements(int col_start, int col_end, int row_start, int row_end) {
        BitSet newElements = new BitSet();
        int total = this.getTotalElements();
        int row_count = row_start;
        while (row_count < row_end) {
            int col_count = col_start;
            while (col_count < col_end) {
                int index = this.findSelectedIndex(row_count, col_count);
                if (index > -1 && index < total) {
                    newElements.set(index);
                }
                if (this.firstSelectedIndex == -1 || this.firstSelectedIndex > index) {
                    this.firstSelectedIndex = index;
                }
                ++col_count;
            }
            ++row_count;
        }
        return newElements;
    }

    private Point getStartedPoint(int x, int y) {
        return new Point(Math.max(this.e_offset_x - this.e_spacing_x, x), Math.max(0, Math.min((this.getMaxRow() - this.current_top_row) * this.getElementHeight() + this.sel_size, y)));
    }

    private Point getFinishedPoint(int x, int y) {
        return new Point(Math.min(this.getMaxCol() * this.getElementWidth() + this.e_offset_x - this.e_spacing_x, Math.max(this.e_offset_x - this.e_spacing_x, x)), Math.min((this.getMaxRow() - this.current_top_row) * this.getElementHeight() + this.sel_size, Math.max(0 + this.sel_size, y)));
    }

    protected void doMouseSelection(int mouse_start_x, int mouse_start_y, int mouse_end_x, int mouse_end_y, boolean isScrolling) {
        if (mouse_start_x < this.e_offset_x - this.getElementWidth() || mouse_start_y > (this.getMaxRow() - this.current_top_row + 1) * this.getElementHeight()) {
            return;
        }
        boolean isInitialPage = mouse_start_y - this.verticalScrollOffset == this.actualScrollStart_y;
        Point start_pt = this.getStartedPoint(mouse_start_x, mouse_start_y);
        Point end_pt = this.getFinishedPoint(mouse_end_x, mouse_end_y);
        int direction = this.getDirection(this.movingSelectionStart.x, this.movingSelectionStart.y, end_pt.x, end_pt.y);
        int s_x = start_pt.x;
        int e_x = end_pt.x;
        int s_y = isInitialPage ? start_pt.y : this.actualScrollStart_y - this.verticalScrollOffset;
        int e_y = end_pt.y;
        switch (direction) {
            case 2: {
                s_x = end_pt.x;
                e_x = start_pt.x;
                break;
            }
            case 3: {
                s_x = end_pt.x;
                e_x = start_pt.x;
                s_y = end_pt.y;
                e_y = start_pt.y;
                break;
            }
            case 4: {
                s_y = end_pt.y;
                e_y = start_pt.y;
            }
        }
        int d_sx = s_x - this.e_offset_x + this.e_spacing_x;
        int d_ex = e_x - this.e_offset_x;
        int d_sy = s_y - this.e_offset_y + this.e_spacing_y;
        int d_ey = e_y - this.e_offset_y;
        int col_start = Math.max(0, this.getSelectedCol(d_sx, true));
        int col_end = Math.min(this.getSelectedCol(d_ex, true) + 1, this.getMaxCol());
        int row_start = Math.max(0, this.getSelectedRow(d_sy, true));
        int row_end = Math.min(this.getSelectedRow(d_ey, true) + 1, this.getMaxRow());
        this.tempSelectedElements.clear();
        this.tempSelectedElements.or(this.selectElements(col_start, col_end, row_start, row_end));
        if (this.movingSelectionEnd != null) {
            int last_end_x = this.movingSelectionEnd.x;
            int last_end_y = this.movingSelectionEnd.y;
            if (this.getDirection(this.movingSelectionStart.x, this.movingSelectionStart.y, last_end_x, last_end_y) != direction || isScrolling && (this.isReachTop() || this.isReachBottom())) {
                this.movingSelectionEnd.x = end_pt.x;
                this.movingSelectionEnd.y = end_pt.y;
                this.redraw();
                return;
            }
            switch (direction) {
                case 1: {
                    if (e_x < last_end_x) {
                        d_ex = last_end_x - this.e_offset_x - this.e_spacing_x;
                        col_end = Math.min(this.getSelectedCol(d_ex, true) + 1, this.getMaxCol());
                    }
                    if (e_y >= last_end_y) break;
                    d_ey = last_end_y - this.e_offset_y - this.e_spacing_y;
                    row_end = Math.min(this.getSelectedRow(d_ey, true) + 1, this.getMaxRow());
                    break;
                }
                case 2: {
                    if (e_x > last_end_x) {
                        d_sx = last_end_x - this.e_offset_x + this.e_spacing_x;
                        col_start = Math.max(0, this.getSelectedCol(d_sx, true));
                    }
                    if (e_y >= last_end_y) break;
                    d_ey = last_end_y - this.e_offset_y - this.e_spacing_y;
                    row_end = Math.min(this.getSelectedRow(d_ey, true) + 1, this.getMaxRow());
                    break;
                }
                case 3: {
                    if (e_x > last_end_x) {
                        d_sx = last_end_x - this.e_offset_x + this.e_spacing_x;
                        col_start = Math.max(0, this.getSelectedCol(d_sx, true));
                    }
                    if (e_y <= last_end_y) break;
                    d_sy = last_end_y - this.e_offset_y + this.e_spacing_y;
                    row_start = Math.max(0, this.getSelectedRow(d_sy, true));
                    break;
                }
                case 4: {
                    if (e_x < last_end_x) {
                        d_ex = last_end_x - this.e_offset_x - this.e_spacing_x;
                        col_end = Math.min(this.getSelectedCol(d_ex, true) + 1, this.getMaxCol());
                    }
                    if (e_y <= last_end_y) break;
                    d_sy = last_end_y - this.e_offset_y + this.e_spacing_y;
                    row_start = Math.max(0, this.getSelectedRow(d_sy, true));
                }
            }
        }
        this.movingSelectionEnd = new Point(end_pt.x, end_pt.y);
        this.redrawByIndex(col_start, col_end, row_start, row_end, direction, isScrolling);
    }

    protected void redrawByLocation(int d_sx, int d_ex, int d_sy, int d_ey, int direction, boolean isScrolling) {
        int d_x = d_sx;
        int d_y = d_sy + (direction == 3 || direction == 4 ? (isScrolling ? this.getVerticalIncrement() : 0) : 0);
        int d_w = this.e_offset_x + Math.abs(d_ex - d_sx);
        int d_h = this.e_offset_y + Math.abs(d_ey - d_sy) + (direction == 1 || direction == 2 ? (isScrolling ? this.getVerticalIncrement() : 0) : 0);
        this.redraw(d_x, d_y, d_w, d_h, false);
    }

    protected void redrawByIndex(int col_start, int col_end, int row_start, int row_end, int direction, boolean isScrolling) {
        int redrawStart_x = this.e_offset_x + col_start * this.getElementWidth() - this.e_spacing_x;
        int redrawEnd_x = this.e_offset_x + col_end * this.getElementWidth() + this.e_spacing_x;
        int redrawStart_y = this.e_offset_y + row_start * this.getElementHeight() - this.verticalScrollOffset;
        int redrawEnd_y = this.e_offset_y + row_end * this.getElementHeight() + this.verticalScrollOffset;
        int margin_x = this.getElementWidth() + this.sel_size;
        int margin_y = this.getElementHeight() + this.sel_size;
        int d_x = Math.max(0, redrawStart_x - margin_x);
        int d_y = Math.max(0, redrawStart_y - margin_y) + (direction == 3 || direction == 4 ? (isScrolling ? this.getVerticalIncrement() : 0) : 0);
        int d_w = Math.abs(redrawEnd_x - redrawStart_x) + margin_x * 2;
        int d_h = Math.abs(redrawEnd_y - redrawStart_y) + margin_y * 2 + (direction == 1 || direction == 2 ? (isScrolling ? this.getVerticalIncrement() : 0) : 0);
        if (d_x < this.e_offset_x) {
            d_x = 0;
            d_w += this.e_offset_x;
        }
        this.redraw(d_x, d_y, d_w, d_h, false);
    }

    protected void redraw(int start_index, int end_index) {
        int max_col = this.getMaxCol();
        int start_row = (int)Math.floor(start_index / max_col);
        int start_y_loc = start_row * this.getElementHeight() + this.e_offset_y - this.verticalScrollOffset;
        int end_row = (int)Math.floor(end_index / max_col);
        int end_y_loc = end_row * this.getElementHeight() + this.e_offset_y - this.verticalScrollOffset;
        int diff = Math.abs(end_row - start_row) + 1;
        this.redraw(0, Math.min(start_y_loc, end_y_loc), max_col * this.getElementWidth() + this.e_offset_x, diff * this.getElementHeight(), false);
    }

    protected boolean canSelectElements(int start_index, int end_index, boolean checkStatus) {
        if (start_index == -1 || end_index == -1) {
            return false;
        }
        this.selectElements(start_index, end_index, checkStatus);
        return true;
    }

    public void unselectAllElements() {
        this.selectedElements.clear();
        this.tempSelectedElements.clear();
    }

    public void autoSelectUnselectElement(int index) {
        if (this.isSelected(index)) {
            this.selectedElements.clear(index);
        } else {
            this.selectedElements.set(index);
        }
    }

    public boolean isSelected(int index) {
        return this.selectedElements.get(index);
    }

    public void unselectElement(int index) {
        this.selectedElements.clear(index);
    }

    public void selectElement(int index) {
        this.selectedElements.set(index);
        this.firstSelectedIndex = index;
    }

    public void selectElements(int from_index, int to_index) {
        this.selectElements(from_index, to_index, false);
    }

    public void selectElements(int from_index, int to_index, boolean checkStatus) {
        int index = from_index;
        while (index < to_index + 1) {
            if (checkStatus) {
                this.autoSelectUnselectElement(index);
            } else {
                this.selectedElements.set(index);
            }
            ++index;
        }
    }

    public void unselectElements(int from_index, int to_index) {
        int index = from_index;
        while (index < to_index + 1) {
            this.selectedElements.clear(index);
            ++index;
        }
    }

    protected void performPaint(GC gc, int col_start, int col_end, int row_start, int row_end, int render_x, int render_y, int renderWidth, int renderHeight) {
        Image imageBuffer = null;
        GC newGC = null;
        if (DOUBLE_BUFFER) {
            imageBuffer = new Image((Device)this.getDisplay(), renderWidth, renderHeight);
            newGC = new GC((Drawable)imageBuffer, 0x2000000);
        } else {
            newGC = gc;
        }
        newGC.setFont(this.getFont());
        if (this.isDisplayRuler()) {
            newGC.setBackground(this.margin_color);
            newGC.fillRectangle(0, 0, this.e_offset_x - this.e_spacing_x, this.getClientArea().height);
        }
        int total = this.getTotalElements();
        int row_count = row_start;
        while (row_count < row_end) {
            int col_count = col_start;
            while (col_count < col_end) {
                int index = this.findSelectedIndex(row_count, col_count);
                if (index > -1 && index < total) {
                    int x_loc = this.e_offset_x + col_count * this.getElementWidth();
                    int y_loc = this.e_offset_y + row_count * this.getElementHeight() - this.verticalScrollOffset;
                    if (col_count == 0 && this.isDisplayRuler()) {
                        this.drawIndex(newGC, index, y_loc);
                    }
                    this.drawImage(newGC, index, x_loc, y_loc, this.selectedElements.get(index) || this.tempSelectedElements.get(index));
                }
                ++col_count;
            }
            ++row_count;
        }
        if (this.movingSelectionStart != null && this.movingSelectionEnd != null) {
            this.drawSelection(newGC);
        }
        if (DOUBLE_BUFFER) {
            gc.drawImage(imageBuffer, render_x, render_y);
            newGC.dispose();
            imageBuffer.dispose();
        }
        this.clearMargin(gc, this.getBackground());
    }

    protected void drawIndex(GC gc, int index, int y_loc) {
        String text = String.valueOf(index);
        Point text_size = gc.stringExtent(text);
        int align = this.e_offset_x - this.e_spacing_x - text_size.x;
        int valign = y_loc + this.e_height / 2 - text_size.y / 2;
        gc.drawText(text, align, valign);
    }

    protected void drawImage(GC gc, int index, int x_loc, int y_loc, boolean isSelected) {
        Image statusImage = this.getStatusIcon(index, isSelected);
        if (statusImage != null) {
            gc.drawImage(statusImage, x_loc, y_loc);
            this.drawSpecial(index, gc, x_loc, y_loc, this.e_width, this.e_height);
        }
    }

    private void drawSelection(GC gc) {
        gc.setForeground(this.sel_color);
        gc.setLineWidth(this.sel_size);
        Point stationary_pt = this.getStartedPoint(this.movingSelectionStart.x, this.movingSelectionStart.y);
        int start_x = stationary_pt.x;
        int start_y = stationary_pt.y;
        int end_x = 0;
        int end_y = 0;
        switch (this.getDirection(this.movingSelectionStart.x, this.movingSelectionStart.y, this.movingSelectionEnd.x, this.movingSelectionEnd.y)) {
            case 1: {
                while (start_x < this.movingSelectionEnd.x) {
                    gc.drawLine(start_x, stationary_pt.y, start_x + 2, stationary_pt.y);
                    start_x += 4;
                }
                while (start_y < this.movingSelectionEnd.y) {
                    gc.drawLine(stationary_pt.x, start_y, stationary_pt.x, start_y + 2);
                    start_y += 4;
                }
                end_x = start_x -= 2;
                end_y = start_y -= 2;
                if (this.isReachBottom() || this.movingSelectionEnd.y < this.getClientArea().height) {
                    while (end_x > stationary_pt.x) {
                        gc.drawLine(end_x - 2, start_y, end_x, start_y);
                        end_x -= 4;
                    }
                }
                while (end_y > stationary_pt.y) {
                    gc.drawLine(start_x, end_y - 2, start_x, end_y);
                    end_y -= 4;
                }
                break;
            }
            case 2: {
                while (start_x > this.movingSelectionEnd.x) {
                    gc.drawLine(start_x - 2, stationary_pt.y, start_x, stationary_pt.y);
                    start_x -= 4;
                }
                while (start_y < this.movingSelectionEnd.y) {
                    gc.drawLine(stationary_pt.x, start_y, stationary_pt.x, start_y + 2);
                    start_y += 4;
                }
                end_x = start_x += 2;
                end_y = start_y -= 2;
                if (this.isReachBottom() || this.movingSelectionEnd.y < this.getClientArea().height) {
                    while (end_x < stationary_pt.x) {
                        gc.drawLine(end_x, start_y, end_x + 2, start_y);
                        end_x += 4;
                    }
                }
                while (end_y > stationary_pt.y) {
                    gc.drawLine(start_x, end_y - 2, start_x, end_y);
                    end_y -= 4;
                }
                break;
            }
            case 3: {
                while (start_x > this.movingSelectionEnd.x) {
                    gc.drawLine(start_x - 2, stationary_pt.y, start_x, stationary_pt.y);
                    start_x -= 4;
                }
                while (start_y > this.movingSelectionEnd.y) {
                    gc.drawLine(stationary_pt.x, start_y - 2, stationary_pt.x, start_y);
                    start_y -= 4;
                }
                end_x = start_x += 2;
                end_y = start_y += 2;
                if (this.isReachTop() || this.movingSelectionEnd.y > 1) {
                    while (end_x < stationary_pt.x) {
                        gc.drawLine(end_x, start_y, end_x + 2, start_y);
                        end_x += 4;
                    }
                }
                while (end_y < stationary_pt.y) {
                    gc.drawLine(start_x, end_y, start_x, end_y + 2);
                    end_y += 4;
                }
                break;
            }
            case 4: {
                while (start_x < this.movingSelectionEnd.x) {
                    gc.drawLine(start_x, stationary_pt.y, start_x + 2, stationary_pt.y);
                    start_x += 4;
                }
                while (start_y > this.movingSelectionEnd.y) {
                    gc.drawLine(stationary_pt.x, start_y - 2, stationary_pt.x, start_y);
                    start_y -= 4;
                }
                end_x = start_x -= 2;
                end_y = start_y += 2;
                if (this.isReachTop() || this.movingSelectionEnd.y > 1) {
                    while (end_x > stationary_pt.x) {
                        gc.drawLine(end_x - 2, start_y, end_x, start_y);
                        end_x -= 4;
                    }
                }
                while (end_y < stationary_pt.y) {
                    gc.drawLine(start_x, end_y, start_x, end_y + 2);
                    end_y += 4;
                }
                break;
            }
        }
    }

    protected void clearMargin(GC gc, Color background) {
        gc.setBackground(background);
    }

    public GC getGC() {
        return this.getGC(0);
    }

    protected GC getGC(int style) {
        return new GC((Drawable)this, style);
    }

    public void setCursor(Cursor cursor) {
        if (cursor == null) {
            super.setCursor(this.defaultCursor);
        } else {
            super.setCursor(cursor);
        }
    }

    protected void doMouseMoving(Event event) {
        int index = this.findSelectedIndexByLocation(event.x, event.y, false);
        if (index > -1) {
            this.setCursor(new Cursor((Device)this.getDisplay(), 21));
        } else {
            this.setCursor(null);
        }
        this.hideToolTip();
    }

    protected void hideToolTip() {
        if (this.fInformationControl != null) {
            this.fInformationControl.setVisible(false);
            if (this.fInformationControl != null) {
                this.fInformationControl.dispose();
            }
        }
        this.disableTooltipTimer();
    }

    protected void disableTooltipTimer() {
        if (this.hoverTimer != null) {
            this.hoverTimer.cancel();
            this.hoverTimer = null;
        }
    }

    protected void enableTooltipTimer() {
        if (!this.show_tooltip_allthetime && this.fInformationControl != null) {
            this.getHoverTimer().schedule(new TimerTask(){

                @Override
                public void run() {
                    IconCanvas.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IconCanvas.this.hideToolTip();
                        }
                    });
                }
            }, this.tooltip_timeout);
        }
    }

    private Timer getHoverTimer() {
        if (this.hoverTimer == null) {
            this.hoverTimer = new Timer();
        }
        return this.hoverTimer;
    }

    protected void resetInfo() {
        this.hideToolTip();
        this.mouseDown = false;
        this.mouseDoubleClick = false;
        this.movingSelectionStart = null;
        this.movingSelectionEnd = null;
        this.max_e_row = -1;
        this.max_e_col = -1;
        this.setCursor(null);
    }

    protected void handleDispose(Event event) {
        this.removeListener(12, this.listener);
        event.type = 0;
        this.resetInfo();
        this.keyActionMap = null;
        this.defaultCursor.dispose();
        this.defaultCursor = null;
        this.actionListeners.clear();
        this.total_elements = 0;
    }

    protected void handleKeyDown(Event event) {
        if (event.doit) {
            this.handleKey(event);
        }
    }

    protected void handleKeyUp(Event event) {
        this.resetInfo();
    }

    protected void handleMouseDown(Event event) {
        int start;
        this.mouseDown = true;
        this.mouseDoubleClick = false;
        if (this.getTotalElements() == 0 || event.button != 1 || IS_CARBON && (event.stateMask & SWT.MOD4) != 0) {
            return;
        }
        boolean isCtrl = (event.stateMask & SWT.MOD1) != 0;
        boolean isShift = (event.stateMask & SWT.MOD2) != 0;
        int end = this.findSelectedIndexByLocation(event.x, event.y, false);
        int n = start = isShift ? this.firstSelectedIndex : end;
        if (start == -1) {
            start = end;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (IS_CARBON) {
            if (start > -1 && end > -1 && !isCtrl) {
                this.firstSelectedIndex = start;
                this.secondSelectedIndex = end;
            }
            if (isShift && this.firstSelectedIndex > -1 && this.secondSelectedIndex > -1 && this.firstSelectedIndex < this.secondSelectedIndex) {
                end = this.secondSelectedIndex;
            }
        } else if (IS_GTK || IS_MOTIF) {
            if (isShift && isCtrl) {
                isShift = false;
                if (start < this.secondSelectedIndex) {
                    end = start;
                } else {
                    start = end;
                }
            }
            if (!(start <= -1 || end <= -1 || isShift && start != end)) {
                this.firstSelectedIndex = start;
                this.secondSelectedIndex = end;
            }
        } else if (!(start <= -1 || end <= -1 || isShift && start != end)) {
            this.firstSelectedIndex = start;
        }
        if (!isShift && !isCtrl) {
            this.unselectAllElements();
        }
        if (start > -1 && end > -1 && isShift && !isCtrl) {
            this.unselectAllElements();
        }
        if (!(start != -1 && end != -1 || isShift || isCtrl)) {
            this.unselectAllElements();
            this.firstSelectedIndex = -1;
            this.secondSelectedIndex = -1;
        }
        this.selection = new Point(event.x, event.y);
        this.actualScrollStart_y = this.selection.y + this.verticalScrollOffset;
        this.canSelectElements(start, end, isCtrl && !isShift);
        this.redraw();
    }

    protected void handleMouseUp(Event event) {
        this.selectedElements.or(this.tempSelectedElements);
        if (this.movingSelectionStart != null) {
            this.redraw();
        }
        this.resetInfo();
        this.endAutoScroll();
    }

    protected void handleMouseDoubleClick(Event event) {
        if (event.button != 1) {
            return;
        }
        this.resetInfo();
        this.mouseDoubleClick = true;
        int index = this.findSelectedIndexByLocation(event.x, event.y, false);
        if (index > -1) {
            this.fireAction(5, index);
            this.redraw(index, index);
        }
    }

    protected void handleMouseHover(Event event) {
        int index = this.findSelectedIndexByLocation(event.x, event.y, false);
        if (index > -1) {
            if (this.fInformationControl == null) {
                this.showToolTip(index, event);
            }
            this.enableTooltipTimer();
        } else {
            this.hideToolTip();
        }
    }

    protected void handleMouseMove(Event event) {
        if (this.autoScrollDirection == 0) {
            this.doMouseMoving(event);
        }
        if (!this.mouseDown || this.mouseDoubleClick || this.getTotalElements() == 0) {
            return;
        }
        if ((event.stateMask & 0x80000) == 0) {
            return;
        }
        if ((event.stateMask & SWT.MOD2) != 0) {
            return;
        }
        this.update();
        this.doAutoScroll(event.x, event.y);
    }

    protected void handlePaint(Event event) {
        Rectangle clientArea = this.getClientArea();
        if (this.getTotalElements() == 0 || event.height == 0 || clientArea.width == 0 && clientArea.height == 0) {
            return;
        }
        int renderWidth = clientArea.width;
        int renderHeight = clientArea.height;
        int col_start = 0;
        int col_end = this.getMaxCol();
        int row_start = 0;
        int row_end = this.getMaxClientRow();
        if (event.y > 0) {
            Point start_pt = null;
            start_pt = this.movingSelectionStart != null ? this.getStartedPoint(this.movingSelectionStart.x, this.movingSelectionStart.y) : this.getStartedPoint(event.x + event.width, event.y + event.height);
            Point end_pt = this.getFinishedPoint(event.x, event.y);
            int s_x = start_pt.x;
            int e_x = end_pt.x;
            int s_y = start_pt.y;
            int e_y = end_pt.y;
            switch (this.getDirection(start_pt.x, start_pt.y, end_pt.x, end_pt.y)) {
                case 2: {
                    s_x = end_pt.x;
                    e_x = start_pt.x;
                    break;
                }
                case 3: {
                    s_x = end_pt.x;
                    e_x = start_pt.x;
                    s_y = end_pt.y;
                    e_y = start_pt.y;
                    break;
                }
                case 4: {
                    s_y = end_pt.y;
                    e_y = start_pt.y;
                }
            }
            col_start = Math.max(0, this.getSelectedCol(s_x - this.e_offset_x, true));
            col_end = Math.min(this.getSelectedCol(e_x + event.width - this.e_offset_x, true) + 1, this.getMaxCol());
            row_start = Math.max(0, this.getSelectedRow(s_y - this.e_offset_y, true));
            row_end = Math.min(this.getSelectedRow(e_y + event.height - this.e_offset_y, true) + 1, this.getMaxRow());
            renderWidth = s_x + e_x + event.width;
            renderHeight = s_y + e_y + event.height;
        } else {
            row_start = Math.max(0, this.current_top_row);
            row_end = Math.min(row_end + row_start + 1, this.getMaxRow());
        }
        this.performPaint(event.gc, col_start, col_end, row_start, row_end, 0, 0, renderWidth, renderHeight);
    }

    protected void handleResize(Event event) {
        this.resetInfo();
        this.setVerticalScrollBar(this.getVerticalBar());
        if (!this.claimBottomFreeSpace()) {
            this.calculateTopIndex();
        }
    }

    protected void handleFocusOut(Event event) {
    }

    protected void showToolTip(int index, Event event) {
        if (!this.show_tooltip || index == -1) {
            this.hideToolTip();
            return;
        }
        boolean isShift = (event.stateMask & SWT.MOD2) != 0;
        boolean isCtrl = (event.stateMask & SWT.MOD1) != 0;
        this.showToolTip(index, !isShift && !isCtrl);
    }

    protected void showToolTip(int index, boolean showExtra) {
        IIconInformationControl informationControl;
        String[] tooltipTexts = this.getToolTipText(index);
        if (showExtra) {
            boolean bl = showExtra = tooltipTexts.length > 1;
        }
        if ((informationControl = this.getInformationControl(showExtra)) != null) {
            int ly;
            int lx;
            Rectangle clientArea = this.getClientArea();
            informationControl.setHeader(tooltipTexts[0]);
            if (showExtra) {
                informationControl.setInformation(tooltipTexts[1]);
            }
            Point location = this.findLocation(index);
            Point t_size = informationControl.getShellSize();
            int x_gap = this.getElementWidth() / 2;
            int y_gap = showExtra ? this.getElementHeight() * 1 / 2 : this.getElementHeight();
            int display_x = location.x + x_gap;
            int display_y = location.y + y_gap;
            if (display_x + t_size.x > clientArea.width && (lx = location.x - t_size.x + x_gap) > 0) {
                display_x = lx;
            }
            if (display_y + t_size.y > clientArea.height && (ly = location.y - t_size.y + y_gap) > 0) {
                display_y = ly;
            }
            Point real_location = this.getViewActualLocation((Control)this, null, display_x - 2, display_y - 2);
            informationControl.setLocation(real_location);
            informationControl.setVisible(true);
        }
    }

    protected Point getViewActualLocation(Control from, Control to, int mx, int my) {
        Point mappedpt = this.getDisplay().map(from, to, 0, 0);
        Point newpt = new Point(mx, my);
        newpt.x += mappedpt.x;
        newpt.y += mappedpt.y;
        return newpt;
    }

    public BitSet getSelectedElements() {
        return (BitSet)this.selectedElements.clone();
    }

    protected String[] getToolTipText(int index) {
        if (this.toolTipProvider == null) {
            return IToolTipProvider.NO_TOOLTIP;
        }
        return this.toolTipProvider.toolTipText(index);
    }

    protected Image getStatusIcon(int index, boolean isSelected) {
        if (this.imageProvider == null) {
            return null;
        }
        return this.imageProvider.getStatusIcon(index, isSelected);
    }

    protected void drawSpecial(int index, GC gc, int x_loc, int y_loc, int width, int height) {
        if (this.imageProvider != null) {
            this.imageProvider.drawSpecial(index, gc, x_loc, y_loc, width, height);
        }
    }

    protected IIconInformationControl getInformationControl(boolean showDetails) {
        if (this.fInformationControl == null) {
            this.fInformationControl = this.iconHover.getHoverControlCreator(this.getShell(), showDetails, this.tooltip_wrap);
            this.fInformationControl.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    IconCanvas.this.handleInformationControlDisposed();
                }
            });
        }
        return this.fInformationControl;
    }

    protected void handleInformationControlDisposed() {
        this.fInformationControl = null;
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLocation(100, 200);
        shell.setSize(600, 300);
        shell.setLayout((Layout)new FillLayout());
        File normalFile = new File("/home/clement/Desktop/workspace_1.1/org.eclipse.ptp.ui/icons/node/node_running.gif");
        File selectedFile = new File("/home/clement/Desktop/workspace_1.1/org.eclipse.ptp.ui/icons/node/node_running_sel.gif");
        URL normalURL = null;
        URL selectedlURL = null;
        try {
            normalURL = normalFile.toURI().toURL();
            selectedlURL = selectedFile.toURI().toURL();
        }
        catch (Exception e) {
            System.out.println("Cannot create the URL: " + e.getMessage());
            return;
        }
        Image normalImage1 = ImageDescriptor.createFromURL((URL)normalURL).createImage();
        Image selectedImage1 = ImageDescriptor.createFromURL((URL)selectedlURL).createImage();
        int w = 16;
        int h = 16;
        final Image normalImage = new Image(normalImage1.getDevice(), normalImage1.getImageData().scaledTo(w, h));
        final Image selectedImage = new Image(selectedImage1.getDevice(), selectedImage1.getImageData().scaledTo(w, h));
        IconCanvas iconCanvas = new IconCanvas((Composite)shell, 0);
        iconCanvas.setShowTooltip(false);
        iconCanvas.setIconSize(w, h);
        iconCanvas.setFontSize(10);
        iconCanvas.setIconSpace(1, 4);
        iconCanvas.setTooltipWrap(true);
        iconCanvas.setContentProvider(new IContentProvider(){

            @Override
            public boolean hasElement(int index) {
                return true;
            }
        });
        iconCanvas.setImageProvider(new IImageProvider(){

            @Override
            public Image getStatusIcon(int index, boolean isSelected) {
                return isSelected ? selectedImage : normalImage;
            }

            @Override
            public void drawSpecial(int index, GC gc, int x_loc, int y_loc, int width, int height) {
            }
        });
        iconCanvas.setToolTipProvider(new IToolTipProvider(){

            @Override
            public String[] toolTipText(int index) {
                String t = "<i>12345678901234567890123456789a<br>";
                t = String.valueOf(t) + "12345678901234567890</i>1<b>23456789</b>a";
                t = String.valueOf(t) + "12345678901234567890123456789a";
                return new String[]{"Index: " + index, t};
            }

            @Override
            public void update(int index, String content) {
            }
        });
        iconCanvas.setTotal(200);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

