/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.actions;

import java.util.BitSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ptp.debug.core.IPSession;
import org.eclipse.ptp.debug.core.model.IPLocationSet;
import org.eclipse.ptp.internal.debug.ui.IPTPDebugUIConstants;
import org.eclipse.ptp.internal.debug.ui.PDebugImage;
import org.eclipse.ptp.internal.debug.ui.messages.Messages;
import org.eclipse.ptp.internal.debug.ui.views.ParallelDebugView;
import org.eclipse.ptp.internal.debug.ui.views.locations.PLocationView;
import org.eclipse.ptp.internal.ui.model.IElementHandler;
import org.eclipse.ptp.internal.ui.model.IElementSet;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class CreateLocationSetAction
extends Action {
    public static final String ID = "org.eclipse.ptp.debug.ui.CreateLocationSetAction";
    public static final String name = Messages.CreateLocationSetAction_0;
    protected PLocationView view;

    public CreateLocationSetAction(PLocationView view) {
        this.view = view;
        this.setText(name);
        this.setImageDescriptor(PDebugImage.getDescriptor("var_add_normal.gif"));
    }

    public void run() {
        if (this.view == null || this.view.getViewer() == null || !(this.view.getViewer().getInput() instanceof IPSession)) {
            this.setEnabled(false);
            return;
        }
        IPSession session = (IPSession)this.view.getViewer().getInput();
        if (session == null || !session.isReady()) {
            this.setEnabled(false);
            return;
        }
        if (!(this.view.getViewer().getSelection() instanceof IStructuredSelection)) {
            this.setEnabled(false);
            return;
        }
        ParallelDebugView parallelDebugView = null;
        try {
            IWorkbenchPage page = this.view.getViewSite().getPage();
            IViewPart part = page.showView(IPTPDebugUIConstants.ID_VIEW_PARALLELDEBUG);
            if (part instanceof ParallelDebugView) {
                parallelDebugView = (ParallelDebugView)part;
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (PartInitException partInitException) {}
        if (parallelDebugView == null) {
            this.setEnabled(false);
            return;
        }
        String setID = null;
        IStructuredSelection selection = (IStructuredSelection)this.view.getViewer().getSelection();
        IPLocationSet[] locations = selection.toList().toArray(new IPLocationSet[0]);
        IElementHandler setManager = parallelDebugView.getCurrentElementHandler();
        IPLocationSet[] iPLocationSetArray = locations;
        int n = locations.length;
        int n2 = 0;
        while (n2 < n) {
            IPLocationSet locationSet = iPLocationSetArray[n2];
            IElementSet rootSet = setManager.getSet("Root");
            BitSet elementsMatchingTasks = rootSet.contains((BitSet)locationSet.getTasks());
            String name = String.valueOf(locationSet.getFunction()) + ":" + locationSet.getFile() + ":" + locationSet.getLineNumber();
            if (setManager.getSet(name) != null) {
                parallelDebugView.getUIManager().removeSet(name, setManager);
            }
            setID = parallelDebugView.getUIManager().createSet(name, name, setManager, elementsMatchingTasks);
            ++n2;
        }
        if (setID != null) {
            parallelDebugView.selectSet(setManager.getSet(setID));
        }
        parallelDebugView.refresh(false);
    }
}

