/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPComputableFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypeList;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunction
extends PDOMCPPBinding
implements ICPPFunction,
IPDOMOverloader,
ICPPComputableFunction {
    private static final short ANNOT_PARAMETER_PACK = 8;
    private static final short ANNOT_IS_DELETED = 9;
    private static final short ANNOT_IS_CONSTEXPR = 10;
    private static final int NUM_PARAMS = 28;
    private static final int FIRST_PARAM = 32;
    protected static final int FUNCTION_TYPE = 36;
    private static final int SIGNATURE_HASH = 42;
    protected static final int EXCEPTION_SPEC = 46;
    private static final int ANNOTATION = 50;
    private static final int REQUIRED_ARG_COUNT = 52;
    private static final int RETURN_EXPRESSION = 54;
    protected static final int RECORD_SIZE = 60;
    private short fAnnotation = (short)-1;
    private int fRequiredArgCount = -1;
    private ICPPFunctionType fType;

    public PDOMCPPFunction(PDOMCPPLinkage linkage, PDOMNode parent, ICPPFunction function, boolean setTypes) throws CoreException, DOMException {
        super(linkage, parent, function.getNameCharArray());
        Database db = this.getDB();
        Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(function);
        this.getDB().putInt(this.record + 42L, sigHash != null ? sigHash : 0);
        db.putShort(this.record + 50L, this.getAnnotation(function));
        db.putShort(this.record + 52L, (short)function.getRequiredArgumentCount());
        if (setTypes) {
            PDOMCPPLinkage pDOMCPPLinkage = linkage;
            pDOMCPPLinkage.getClass();
            pDOMCPPLinkage.new PDOMCPPLinkage.ConfigureFunction(function, this);
        }
    }

    private short getAnnotation(ICPPFunction function) {
        int annot = PDOMCPPAnnotation.encodeAnnotation(function) & 0xFF;
        if (function.hasParameterPack()) {
            annot |= 0x100;
        }
        if (function.isDeleted()) {
            annot |= 0x200;
        }
        if (function.isConstexpr()) {
            annot |= 0x400;
        }
        return (short)annot;
    }

    public void initData(ICPPFunctionType ftype, ICPPParameter[] params, IType[] exceptionSpec, ICPPEvaluation returnExpression) {
        try {
            this.setType(ftype);
            this.setParameters(params);
            this.storeExceptionSpec(exceptionSpec);
            ((PDOMLinkage)this.getLinkage()).storeEvaluation(this.record + 54L, returnExpression);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        int requiredCount;
        if (!(newBinding instanceof ICPPFunction)) {
            return;
        }
        ICPPFunction func = (ICPPFunction)newBinding;
        ICPPFunctionType newType = func.getType();
        ICPPParameter[] newParams = func.getParameters();
        short newAnnotation = this.getAnnotation(func);
        int newBindingRequiredArgCount = func.getRequiredArgumentCount();
        this.fType = null;
        linkage.storeType(this.record + 36L, newType);
        PDOMCPPParameter oldParams = this.getFirstParameter(null);
        if (oldParams != null && this.hasDeclaration()) {
            int parCount = 0;
            requiredCount = 0;
            ICPPParameter[] iCPPParameterArray = newParams;
            int n = newParams.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPParameter newPar = iCPPParameterArray[n2];
                if (++parCount <= newBindingRequiredArgCount && !oldParams.hasDefaultValue()) {
                    requiredCount = parCount;
                }
                oldParams.update(newPar);
                long next = oldParams.getNextPtr();
                if (next == 0L) break;
                oldParams = new PDOMCPPParameter(linkage, next, null);
                ++n2;
            }
            if (parCount < newBindingRequiredArgCount) {
                requiredCount = newBindingRequiredArgCount;
            }
        } else {
            requiredCount = newBindingRequiredArgCount;
            this.setParameters(newParams);
            if (oldParams != null) {
                oldParams.delete(linkage);
            }
        }
        Database db = this.getDB();
        db.putShort(this.record + 50L, newAnnotation);
        this.fAnnotation = newAnnotation;
        db.putShort(this.record + 52L, (short)requiredCount);
        this.fRequiredArgCount = requiredCount;
        long oldRec = db.getRecPtr(this.record + 46L);
        this.storeExceptionSpec(this.extractExceptionSpec(func));
        if (oldRec != 0L) {
            PDOMCPPTypeList.clearTypes(this, oldRec);
        }
        linkage.storeEvaluation(this.record + 54L, CPPFunction.getReturnExpression(func));
    }

    private void storeExceptionSpec(IType[] exceptionSpec) throws CoreException {
        long typelist = PDOMCPPTypeList.putTypes(this, exceptionSpec);
        this.getDB().putRecPtr(this.record + 46L, typelist);
    }

    IType[] extractExceptionSpec(ICPPFunction binding) {
        Object exceptionSpec = binding instanceof ICPPMethod && ((ICPPMethod)binding).isImplicit() ? null : binding.getExceptionSpecification();
        return exceptionSpec;
    }

    private void setParameters(ICPPParameter[] params) throws CoreException {
        ILinkage linkage = this.getLinkage();
        Database db = this.getDB();
        db.putInt(this.record + 28L, params.length);
        db.putRecPtr(this.record + 32L, 0L);
        PDOMNode next = null;
        int i = params.length;
        while (--i >= 0) {
            next = new PDOMCPPParameter((PDOMLinkage)linkage, this, params[i], (PDOMCPPParameter)next);
        }
        db.putRecPtr(this.record + 32L, next == null ? 0L : next.getRecord());
    }

    private void setType(ICPPFunctionType ft) throws CoreException {
        this.fType = null;
        ((PDOMLinkage)this.getLinkage()).storeType(this.record + 36L, ft);
    }

    @Override
    public int getSignatureHash() throws CoreException {
        return this.getDB().getInt(this.record + 42L);
    }

    public static int getSignatureHash(PDOMLinkage linkage, long record) throws CoreException {
        return linkage.getDB().getInt(record + 42L);
    }

    public PDOMCPPFunction(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 60;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    private PDOMCPPParameter getFirstParameter(IType type) throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 32L);
        return rec != 0L ? new PDOMCPPParameter((PDOMLinkage)this.getLinkage(), rec, type) : null;
    }

    @Override
    public boolean isInline() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 2);
    }

    @Override
    public int getRequiredArgumentCount() {
        if (this.fRequiredArgCount == -1) {
            try {
                this.fRequiredArgCount = this.getDB().getShort(this.record + 52L);
            }
            catch (CoreException coreException) {
                this.fRequiredArgCount = 0;
            }
        }
        return this.fRequiredArgCount;
    }

    protected final short getAnnotation() {
        if (this.fAnnotation == -1) {
            try {
                this.fAnnotation = this.getDB().getShort(this.record + 50L);
            }
            catch (CoreException coreException) {
                this.fAnnotation = 0;
            }
        }
        return this.fAnnotation;
    }

    @Override
    public boolean isExternC() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 6);
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }

    @Override
    public ICPPParameter[] getParameters() {
        try {
            ILinkage linkage = this.getLinkage();
            Database db = this.getDB();
            ICPPFunctionType ft = this.getType();
            IType[] ptypes = ft == null ? IType.EMPTY_TYPE_ARRAY : ft.getParameterTypes();
            int n = db.getInt(this.record + 28L);
            ICPPParameter[] result = new ICPPParameter[n];
            long next = db.getRecPtr(this.record + 32L);
            int i = 0;
            while (i < n && next != 0L) {
                IType type = i < ptypes.length ? ptypes[i] : null;
                PDOMCPPParameter par = new PDOMCPPParameter((PDOMLinkage)linkage, next, type);
                next = par.getNextPtr();
                result[i] = par;
                ++i;
            }
            return result;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
        }
    }

    @Override
    public final ICPPFunctionType getType() {
        if (this.fType == null) {
            try {
                this.fType = (ICPPFunctionType)((PDOMLinkage)this.getLinkage()).loadType(this.record + 36L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fType = new ProblemFunctionType(10005);
            }
        }
        return this.fType;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 10);
    }

    @Override
    public boolean isDeleted() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 9);
    }

    @Override
    public boolean isExtern() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 1);
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 4);
    }

    @Override
    public boolean takesVarArgs() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 5);
    }

    @Override
    public boolean isNoReturn() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 6);
    }

    @Override
    public boolean hasParameterPack() {
        return PDOMCPPFunction.getBit(this.getAnnotation(), 8);
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    protected static int compareSignatures(IPDOMOverloader a, Object b) {
        if (b instanceof IPDOMOverloader) {
            IPDOMOverloader bb = (IPDOMOverloader)b;
            try {
                int mySM = a.getSignatureHash();
                int otherSM = bb.getSignatureHash();
                return mySM == otherSM ? 0 : (mySM < otherSM ? -1 : 1);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        } else assert (false);
        return 0;
    }

    @Override
    public IType[] getExceptionSpecification() {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 46L);
            return PDOMCPPTypeList.getTypes(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public ICPPEvaluation getReturnExpression() {
        if (!this.isConstexpr()) {
            return null;
        }
        try {
            return (ICPPEvaluation)((PDOMLinkage)this.getLinkage()).loadEvaluation(this.record + 54L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }
}

