/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.control.core.LaunchControllerManager;

public class RMLaunchUtils {
    public static ILaunchController getLaunchController(ILaunchConfiguration configuration) throws CoreException {
        String type = LaunchUtils.getTemplateName((ILaunchConfiguration)configuration);
        if (type != null) {
            String connName = LaunchUtils.getConnectionName((ILaunchConfiguration)configuration);
            String remId = LaunchUtils.getRemoteServicesId((ILaunchConfiguration)configuration);
            if (connName != null && remId != null) {
                return LaunchControllerManager.getInstance().getLaunchController(remId, connName, type);
            }
        }
        return null;
    }

    public static IRemoteConnection getRemoteConnection(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        String name;
        IRemoteServices services;
        String remId = LaunchUtils.getRemoteServicesId((ILaunchConfiguration)configuration);
        if (remId != null && (services = RemoteServices.getRemoteServices((String)remId, (IProgressMonitor)monitor)) != null && (name = LaunchUtils.getConnectionName((ILaunchConfiguration)configuration)) != null) {
            return services.getConnectionManager().getConnection(name);
        }
        return null;
    }

    public static IRemoteFileManager getLocalFileManager(ILaunchConfiguration configuration) throws CoreException {
        IRemoteServices localServices = RemoteServices.getLocalServices();
        IRemoteConnectionManager lconnMgr = localServices.getConnectionManager();
        IRemoteConnection lconn = lconnMgr.getConnection("Local");
        return localServices.getFileManager(lconn);
    }

    public static IRemoteFileManager getRemoteFileManager(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRemoteConnection conn = RMLaunchUtils.getRemoteConnection(configuration, monitor);
        if (!monitor.isCanceled()) {
            return conn.getRemoteServices().getFileManager(conn);
        }
        return null;
    }
}

