/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.lsf.ui.widgets;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.LSFQueryControl;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.LSFQueryDialog;
import org.eclipse.ptp.rm.ibm.lsf.ui.widgets.Messages;
import org.eclipse.ptp.rm.jaxb.control.ui.IWidgetDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ReservationQueryControl
extends LSFQueryControl {
    public ReservationQueryControl(Composite parent, IWidgetDescriptor wd) {
        super(parent, wd);
    }

    @Override
    protected void configureQueryButton(Button button, final IRemoteConnection connection) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ReservationQueryControl.this.getQueryResponse(connection)) {
                    ReservationQueryControl.this.dialog = new LSFQueryDialog(ReservationQueryControl.this.getShell(), Messages.ReservationQueryControl_0, ReservationQueryControl.this.columnLabels, ReservationQueryControl.this.commandResponse, false);
                    ReservationQueryControl.this.dialog.setSelectedValue(ReservationQueryControl.this.selectedValues);
                    int selection = ReservationQueryControl.this.dialog.open();
                    if (selection == 0) {
                        ReservationQueryControl.this.selectedValues = ReservationQueryControl.this.dialog.getSelectedValues();
                        ReservationQueryControl.this.notifyListeners();
                    }
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean getQueryResponse(IRemoteConnection connection) {
        IRemoteServices remoteServices = connection.getRemoteServices();
        IRemoteProcessBuilder processBuilder = remoteServices.getProcessBuilder(connection, new String[]{"brsvs", "-w"});
        IRemoteProcess process = null;
        try {
            process = processBuilder.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
            if (process.exitValue() != 0) return true;
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String data = reader.readLine();
            boolean headerLine = true;
            this.commandResponse.clear();
            while (true) {
                if (data == null) {
                    reader.close();
                    return true;
                }
                if (headerLine) {
                    if (data.equals("No reservation found")) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ReservationQueryControl_2, (String)Messages.ReservationQueryControl_3);
                        reader.close();
                        return false;
                    }
                    this.columnLabels = data.split(" +");
                    headerLine = false;
                } else {
                    data = data.replaceAll(" +/ +", "/");
                    String[] columnData = data.split(" +");
                    this.commandResponse.add(columnData);
                }
                data = reader.readLine();
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("Error querying reservations:\n" + e.getMessage()));
            return false;
        }
    }
}

