/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchMatchAdapter;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchResult;
import org.eclipse.ptp.rdt.ui.UIPlugin;
import org.eclipse.ptp.rdt.ui.messages.Messages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class GroupRemoteSearchQueryAdapter
implements ISearchQuery {
    private List<ISearchQuery> jobs;
    private ISearchResult result;

    public GroupRemoteSearchQueryAdapter(List<ISearchQuery> _jobs) {
        this.jobs = _jobs;
        this.result = this.jobs.get(0).getSearchResult();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.result;
    }

    private Match[] computeContainedMatches(AbstractTextSearchResult result, URI locationURI) throws CoreException {
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] elements = result.getElements();
        int i = 0;
        while (i < elements.length) {
            Match[] matches = result.getMatches(elements[i]);
            int j = 0;
            while (j < matches.length) {
                if (matches[j] instanceof RemoteSearchMatchAdapter) {
                    list.add(matches[j]);
                }
                ++j;
            }
            ++i;
        }
        return list.toArray(new Match[list.size()]);
    }

    public IStatus run(IProgressMonitor monitor) {
        int numOfJobs = this.jobs.size();
        monitor.beginTask(Messages.getString("GroupRemoteSearchQueryAdapter_0"), 2);
        final String JOBFAMILYNAME = Messages.getString("GroupRemoteSearchQueryAdapter_1");
        IJobManager jobMan = Job.getJobManager();
        IProgressMonitor myGroup = jobMan.createProgressGroup();
        myGroup.beginTask(JOBFAMILYNAME, numOfJobs * 300);
        try {
            for (final ISearchQuery query : this.jobs) {
                if (monitor.isCanceled()) {
                    jobMan.cancel((Object)JOBFAMILYNAME);
                    Status status = new Status(8, "org.eclipse.ptp.rdt.ui", "");
                    return status;
                }
                Job job = new Job(JOBFAMILYNAME){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask(JOBFAMILYNAME, 300);
                        if (monitor.isCanceled()) {
                            return new Status(8, "org.eclipse.ptp.rdt.ui", "");
                        }
                        query.run(monitor);
                        monitor.worked(300);
                        monitor.done();
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return this.getName().equals(family);
                    }
                };
                job.setProgressGroup(myGroup, numOfJobs * 300);
                job.setPriority(30);
                job.schedule();
            }
            try {
                jobMan.join((Object)JOBFAMILYNAME, null);
                monitor.worked(1);
            }
            catch (InterruptedException e) {
                UIPlugin.log(e);
            }
            this.combineResults();
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
        return new Status(0, "org.eclipse.ptp.rdt.ui", "");
    }

    private void combineResults() {
        RemoteSearchResult result = (RemoteSearchResult)this.jobs.get(0).getSearchResult();
        int i = 1;
        while (i < this.jobs.size()) {
            RemoteSearchResult result2 = (RemoteSearchResult)this.jobs.get(i).getSearchResult();
            Match[] matches = null;
            try {
                matches = this.computeContainedMatches(result2, null);
            }
            catch (CoreException e) {
                UIPlugin.log(e);
            }
            result.addMatches(matches);
            ++i;
        }
        this.result = result;
    }

    public String getLabel() {
        return this.result.getLabel();
    }
}

