/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.ptp.internal.rdt.core.search.RemoteLineSearchElement;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchLabelProvider;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchTreeContentProvider;
import org.eclipse.ptp.internal.rdt.ui.search.RemoteSearchViewPage;

public class RemoteSearchListLabelProvider
extends ColoringLabelProvider {
    private final RemoteSearchViewPage fPage;
    private final int fColumnIndex;

    public RemoteSearchListLabelProvider(RemoteSearchViewPage page, int columnIndex) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new RemoteSearchLabelProvider(page));
        this.fPage = page;
        this.fColumnIndex = columnIndex;
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        switch (this.fColumnIndex) {
            case 0: {
                if (!(element instanceof RemoteLineSearchElement)) break;
                RemoteLineSearchElement lineElement = (RemoteLineSearchElement)element;
                String location = RemoteSearchTreeContentProvider.getAbsolutePath(lineElement.getLocation()).toString();
                int lineNumber = lineElement.getLineNumber();
                cell.setText(Messages.format((String)CSearchMessages.CSearchResultCollector_location, (Object[])new Object[]{location, lineNumber}));
                cell.setImage(CDTSharedImages.getImage((String)"icons/obj16/searchm_obj.gif"));
                break;
            }
            case 1: {
                if (!(element instanceof RemoteLineSearchElement)) break;
                RemoteLineSearchElement lineElement = (RemoteLineSearchElement)element;
                ICElement enclosingElement = lineElement.getMatches()[0].getEnclosingElement();
                if (this.fPage.isShowEnclosingDefinitions() && enclosingElement != null) {
                    cell.setText(enclosingElement.getElementName());
                    cell.setImage(this.getImage(element));
                    break;
                }
                cell.setText("");
                break;
            }
            case 2: {
                super.update(cell);
                cell.setImage(null);
                break;
            }
            default: {
                cell.setText("");
            }
        }
    }
}

